/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.xmlparser;

import edu.uci.ics.hyracks.data.std.api.IMutableValueStorage;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.vxquery.datamodel.builders.nodes.AbstractNodeBuilder;
import org.apache.vxquery.datamodel.builders.nodes.AttributeNodeBuilder;
import org.apache.vxquery.datamodel.builders.nodes.CommentNodeBuilder;
import org.apache.vxquery.datamodel.builders.nodes.DictionaryBuilder;
import org.apache.vxquery.datamodel.builders.nodes.DocumentNodeBuilder;
import org.apache.vxquery.datamodel.builders.nodes.ElementNodeBuilder;
import org.apache.vxquery.datamodel.builders.nodes.PINodeBuilder;
import org.apache.vxquery.datamodel.builders.nodes.TextNodeBuilder;
import org.apache.vxquery.xmlparser.ITreeNodeIdProvider;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SAXContentHandler
implements ContentHandler,
LexicalHandler {
    private final ArrayBackedValueStorage docABVS = new ArrayBackedValueStorage();
    private final boolean createNodeIds;
    private final boolean attachTypes;
    private final ITreeNodeIdProvider nodeIdProvider;
    private final ArrayBackedValueStorage tempABVS;
    private final DocumentNodeBuilder docb;
    private final TextNodeBuilder tnb;
    private final CommentNodeBuilder cnb;
    private final PINodeBuilder pinb;
    private final AttributeNodeBuilder anb;
    private final DictionaryBuilder db;
    private final StringBuilder buffer;
    private final List<ElementNodeBuilder> enbStack;
    private final List<ElementNodeBuilder> freeENBList;
    private int nodeIdCounter;
    private boolean pendingText;

    public SAXContentHandler(boolean attachTypes, ITreeNodeIdProvider nodeIdProvider) {
        this.createNodeIds = nodeIdProvider != null;
        this.attachTypes = attachTypes;
        this.nodeIdProvider = nodeIdProvider;
        this.tempABVS = new ArrayBackedValueStorage();
        this.docb = new DocumentNodeBuilder();
        this.tnb = new TextNodeBuilder();
        this.cnb = new CommentNodeBuilder();
        this.pinb = new PINodeBuilder();
        this.anb = new AttributeNodeBuilder();
        this.db = new DictionaryBuilder();
        this.buffer = new StringBuilder();
        this.enbStack = new ArrayList<ElementNodeBuilder>();
        this.freeENBList = new ArrayList<ElementNodeBuilder>();
        this.pendingText = false;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(ch, start, length);
        this.pendingText = true;
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.flushText();
            this.docb.endChildrenChunk();
            this.docb.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            this.flushText();
            ElementNodeBuilder enb = this.enbStack.remove(this.enbStack.size() - 1);
            enb.endChildrenChunk();
            this.endChildInParent(enb);
            this.freeENB(enb);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.flushText();
            this.startChildInParent(this.pinb);
            this.tempABVS.reset();
            this.tempABVS.getDataOutput().writeUTF(target);
            if (this.createNodeIds) {
                this.pinb.setLocalNodeId(this.nodeIdCounter++);
            }
            this.pinb.setTarget((IValueReference)this.tempABVS);
            this.tempABVS.reset();
            this.tempABVS.getDataOutput().writeUTF(data);
            this.pinb.setContent((IValueReference)this.tempABVS);
            this.endChildInParent(this.pinb);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.db.reset();
            this.docABVS.reset();
            this.docb.reset((IMutableValueStorage)this.docABVS);
            if (this.createNodeIds) {
                this.docb.setLocalNodeId(this.nodeIdCounter++);
            }
            this.docb.startChildrenChunk();
            this.flushText();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        try {
            this.flushText();
            int idx = name.indexOf(58);
            String prefix = idx < 0 ? "" : name.substring(0, idx);
            ElementNodeBuilder enb = this.createENB();
            this.startChildInParent(enb);
            int uriCode = this.db.lookup(uri);
            int localNameCode = this.db.lookup(localName);
            int prefixCode = this.db.lookup(prefix);
            enb.setName(uriCode, localNameCode, prefixCode);
            if (this.attachTypes) {
                int typeUriCode = this.db.lookup("http://www.w3.org/2001/XMLSchema");
                int typeLocalNameCode = this.db.lookup("untyped");
                int typePrefixCode = this.db.lookup("xs");
                enb.setType(typeUriCode, typeLocalNameCode, typePrefixCode);
            }
            if (this.createNodeIds) {
                enb.setLocalNodeId(this.nodeIdCounter++);
            }
            enb.startAttributeChunk();
            int nAttrs = atts.getLength();
            for (int i = 0; i < nAttrs; ++i) {
                String aName = atts.getQName(i);
                int aIdx = aName.indexOf(58);
                int aPrefixCode = this.db.lookup(aIdx < 0 ? "" : aName.substring(0, aIdx));
                int aLocalNameCode = this.db.lookup(atts.getLocalName(i));
                int aUriCode = this.db.lookup(atts.getURI(i));
                String aValue = atts.getValue(i);
                this.tempABVS.reset();
                DataOutput tempOut = this.tempABVS.getDataOutput();
                tempOut.write(14);
                tempOut.writeUTF(aValue);
                enb.startAttribute(this.anb);
                this.anb.setName(aUriCode, aLocalNameCode, aPrefixCode);
                if (this.attachTypes) {
                    int typeUriCode = this.db.lookup("http://www.w3.org/2001/XMLSchema");
                    int typeLocalNameCode = this.db.lookup("untypedAtomic");
                    int typePrefixCode = this.db.lookup("xs");
                    this.anb.setType(typeUriCode, typeLocalNameCode, typePrefixCode);
                }
                if (this.createNodeIds) {
                    this.anb.setLocalNodeId(this.nodeIdCounter++);
                }
                this.anb.setValue((IValueReference)this.tempABVS);
                enb.endAttribute(this.anb);
            }
            enb.endAttributeChunk();
            enb.startChildrenChunk();
            this.enbStack.add(enb);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.flushText();
            this.startChildInParent(this.cnb);
            this.buffer.append(ch, start, length);
            this.tempABVS.reset();
            this.tempABVS.getDataOutput().writeUTF(this.buffer.toString());
            if (this.createNodeIds) {
                this.cnb.setLocalNodeId(this.nodeIdCounter++);
            }
            this.cnb.setValue((IValueReference)this.tempABVS);
            this.endChildInParent(this.cnb);
            this.buffer.delete(0, this.buffer.length());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    private void flushText() throws IOException {
        if (this.pendingText) {
            this.peekENBStackTop().startChild(this.tnb);
            this.tempABVS.reset();
            this.tempABVS.getDataOutput().writeUTF(this.buffer.toString());
            if (this.createNodeIds) {
                this.tnb.setLocalNodeId(this.nodeIdCounter++);
            }
            this.tnb.setValue((IValueReference)this.tempABVS);
            this.peekENBStackTop().endChild(this.tnb);
            this.buffer.delete(0, this.buffer.length());
            this.pendingText = false;
        }
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    public void write(ArrayBackedValueStorage abvs) throws IOException {
        DataOutput out = abvs.getDataOutput();
        out.write(107);
        int header = 2;
        if (this.attachTypes) {
            header = (byte)(header | 4);
        }
        if (this.createNodeIds) {
            header = (byte)(header | 1);
        }
        out.write(header);
        if (this.createNodeIds) {
            out.writeInt(this.nodeIdProvider.getId());
        }
        this.db.write(abvs);
        out.write(this.docABVS.getByteArray(), this.docABVS.getStartOffset(), this.docABVS.getLength());
    }

    private ElementNodeBuilder createENB() {
        if (this.freeENBList.isEmpty()) {
            return new ElementNodeBuilder();
        }
        return this.freeENBList.remove(this.freeENBList.size() - 1);
    }

    private void freeENB(ElementNodeBuilder enb) {
        this.freeENBList.add(enb);
    }

    private ElementNodeBuilder peekENBStackTop() {
        return this.enbStack.get(this.enbStack.size() - 1);
    }

    private void startChildInParent(AbstractNodeBuilder anb) throws IOException {
        if (this.enbStack.isEmpty()) {
            this.docb.startChild(anb);
        } else {
            this.peekENBStackTop().startChild(anb);
        }
    }

    private void endChildInParent(AbstractNodeBuilder anb) throws IOException {
        if (this.enbStack.isEmpty()) {
            this.docb.endChild(anb);
        } else {
            this.peekENBStackTop().endChild(anb);
        }
    }
}

