/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.util;

import java.util.Arrays;

public class GrowableIntArray {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int DEFAULT_GROWTH = 16;
    private int[] array;
    private int size;

    public GrowableIntArray() {
        this(16);
    }

    public GrowableIntArray(int initialCapacity) {
        this.array = new int[initialCapacity];
        this.size = 0;
    }

    public void clear() {
        this.size = 0;
    }

    public int[] getArray() {
        return this.array;
    }

    public int getSize() {
        return this.size;
    }

    public void append(int value) {
        if (this.array.length <= this.size) {
            this.grow(16);
        }
        this.array[this.size++] = value;
    }

    public void append(int[] inArray, int start, int length) {
        if (this.array.length <= this.size + length) {
            int increment = ((this.size + length - this.array.length - 1) / 16 + 1) * 16;
            this.grow(increment);
        }
        System.arraycopy(inArray, start, this.array, this.size, length);
        this.size += length;
    }

    public void insert(int index, int value) {
        if (index >= this.size) {
            if (index >= this.array.length) {
                int increment = ((index + 1 - this.array.length - 1) / 16 + 1) * 16;
                this.grow(increment);
            }
            this.size = index + 1;
        } else {
            if (this.size >= this.array.length) {
                this.grow(16);
            }
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
            ++this.size;
        }
        this.array[index] = value;
    }

    public void grow(int increment) {
        if (increment < 0) {
            throw new IllegalArgumentException(increment + " < 0");
        }
        if (increment == 0) {
            return;
        }
        this.array = Arrays.copyOf(this.array, this.array.length + increment);
    }
}

