/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.types;

import javax.xml.namespace.QName;
import org.apache.vxquery.context.RootStaticContextImpl;
import org.apache.vxquery.context.StaticContext;
import org.apache.vxquery.types.AnyItemType;
import org.apache.vxquery.types.AnyNodeType;
import org.apache.vxquery.types.AtomicType;
import org.apache.vxquery.types.DocumentType;
import org.apache.vxquery.types.ElementType;
import org.apache.vxquery.types.EmptySequenceType;
import org.apache.vxquery.types.ItemType;
import org.apache.vxquery.types.NoneType;
import org.apache.vxquery.types.Quantifier;
import org.apache.vxquery.types.SequenceType;

public class TypeUtils {
    public static SequenceType createSequenceType(String str) {
        return TypeUtils.createSequenceType(RootStaticContextImpl.INSTANCE, str);
    }

    public static SequenceType createSequenceType(StaticContext sCtx, String str) {
        ItemType it;
        str = str.trim();
        Quantifier q = Quantifier.QUANT_ONE;
        if (str.endsWith("?")) {
            q = Quantifier.QUANT_QUESTION;
            str = str.substring(0, str.length() - 1);
        } else if (str.endsWith("*")) {
            q = Quantifier.QUANT_STAR;
            str = str.substring(0, str.length() - 1);
        } else if (str.endsWith("+")) {
            q = Quantifier.QUANT_PLUS;
            str = str.substring(0, str.length() - 1);
        }
        if (str.equals("item()")) {
            it = AnyItemType.INSTANCE;
        } else if (str.equals("node()")) {
            it = AnyNodeType.INSTANCE;
        } else if (str.equals("document-node()")) {
            it = DocumentType.ANYDOCUMENT;
        } else if (str.equals("none")) {
            it = NoneType.INSTANCE;
        } else if (str.equals("element()")) {
            it = ElementType.ANYELEMENT;
        } else if (str.equals("empty-sequence()")) {
            it = EmptySequenceType.INSTANCE;
        } else {
            int idx = str.indexOf(58);
            if (idx < 0) {
                throw new IllegalStateException("QName has no prefix: " + str);
            }
            String prefix = str.substring(0, idx);
            String local = str.substring(idx + 1);
            String uri = sCtx.lookupNamespaceUri(prefix);
            if (uri == null) {
                throw new IllegalStateException("Prefix has no URI mapping: " + prefix);
            }
            QName qname = new QName(uri, local, prefix);
            it = (ItemType)((Object)sCtx.lookupSchemaType(qname));
            if (it == null) {
                throw new IllegalStateException("No type found: " + qname);
            }
        }
        return SequenceType.create(it, q);
    }

    public static boolean isSubtypeTypeOf(AtomicType subType, AtomicType superType) {
        while (subType.getTypeId() != superType.getTypeId()) {
            if (subType.getTypeId() == 3) {
                return false;
            }
            subType = (AtomicType)subType.getBaseType();
        }
        return true;
    }
}

