/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.types;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.vxquery.types.AnyItemType;
import org.apache.vxquery.types.AnyNodeType;
import org.apache.vxquery.types.AttributeType;
import org.apache.vxquery.types.BuiltinTypeRegistry;
import org.apache.vxquery.types.CommentType;
import org.apache.vxquery.types.DocumentType;
import org.apache.vxquery.types.ElementType;
import org.apache.vxquery.types.ItemType;
import org.apache.vxquery.types.ProcessingInstructionType;
import org.apache.vxquery.types.Quantifier;

public final class SequenceType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Map<ItemType, SequenceType[]> BUILTIN_SEQ_TYPES;
    private ItemType itemType;
    private Quantifier quantifier;

    private static void createBuiltinEntry(Map<ItemType, SequenceType[]> types, ItemType itemType) {
        types.put(itemType, new SequenceType[]{new SequenceType(itemType, Quantifier.QUANT_ZERO), new SequenceType(itemType, Quantifier.QUANT_ONE), new SequenceType(itemType, Quantifier.QUANT_QUESTION), new SequenceType(itemType, Quantifier.QUANT_STAR), new SequenceType(itemType, Quantifier.QUANT_PLUS)});
    }

    public static SequenceType create(ItemType itemType, Quantifier quantifier) {
        SequenceType[] types = BUILTIN_SEQ_TYPES.get(itemType);
        if (types == null) {
            return new SequenceType(itemType, quantifier);
        }
        return types[quantifier.ordinal()];
    }

    private SequenceType(ItemType itemType, Quantifier quantifier) {
        this.itemType = itemType;
        this.quantifier = quantifier;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.itemType == null ? 0 : this.itemType.hashCode());
        result = 31 * result + (this.quantifier == null ? 0 : this.quantifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceType other = (SequenceType)obj;
        if (this.itemType == null ? other.itemType != null : !this.itemType.equals(other.itemType)) {
            return false;
        }
        return this.quantifier == other.quantifier;
    }

    public String toString() {
        return String.valueOf(this.itemType) + Quantifier.toString(this.quantifier);
    }

    static {
        LinkedHashMap<ItemType, SequenceType[]> types = new LinkedHashMap<ItemType, SequenceType[]>();
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_ANY_ATOMIC);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_STRING);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_NORMALIZED_STRING);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_TOKEN);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_LANGUAGE);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_NMTOKEN);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_NAME);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_NCNAME);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_ID);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_IDREF);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_ENTITY);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_UNTYPED_ATOMIC);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_DATETIME);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_DATE);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_TIME);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_DURATION);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_YEAR_MONTH_DURATION);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_DAY_TIME_DURATION);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XSEXT_NUMERIC);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_FLOAT);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_DOUBLE);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_DECIMAL);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_INTEGER);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_NON_POSITIVE_INTEGER);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_NEGATIVE_INTEGER);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_LONG);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_LONG);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_INT);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_SHORT);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_BYTE);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_NON_NEGATIVE_INTEGER);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_UNSIGNED_LONG);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_UNSIGNED_INT);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_UNSIGNED_SHORT);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_UNSIGNED_BYTE);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_POSITIVE_INTEGER);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_G_YEAR_MONTH);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_G_YEAR);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_G_MONTH_DAY);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_G_DAY);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_G_MONTH);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_BOOLEAN);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_BASE64_BINARY);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_HEX_BINARY);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_ANY_URI);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_QNAME);
        SequenceType.createBuiltinEntry(types, BuiltinTypeRegistry.XS_NOTATION);
        SequenceType.createBuiltinEntry(types, AnyItemType.INSTANCE);
        SequenceType.createBuiltinEntry(types, AnyNodeType.INSTANCE);
        SequenceType.createBuiltinEntry(types, DocumentType.ANYDOCUMENT);
        SequenceType.createBuiltinEntry(types, ElementType.ANYELEMENT);
        SequenceType.createBuiltinEntry(types, AttributeType.ANYATTRIBUTE);
        SequenceType.createBuiltinEntry(types, CommentType.INSTANCE);
        SequenceType.createBuiltinEntry(types, ProcessingInstructionType.ANYPI);
        BUILTIN_SEQ_TYPES = Collections.unmodifiableMap(types);
    }
}

