/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.types;

import org.apache.vxquery.types.AbstractNodeType;
import org.apache.vxquery.types.AnyType;
import org.apache.vxquery.types.NameTest;
import org.apache.vxquery.types.NodeKind;
import org.apache.vxquery.types.SchemaType;

public final class ElementType
extends AbstractNodeType {
    public static final ElementType ANYELEMENT = new ElementType(NameTest.STAR_NAMETEST, AnyType.INSTANCE, true);
    private NameTest nameTest;
    private SchemaType contentType;
    private boolean nilled;

    public ElementType(NameTest nameTest, SchemaType contentType, boolean nilled) {
        this.nameTest = nameTest;
        this.contentType = contentType;
        this.nilled = nilled;
    }

    @Override
    public NodeKind getNodeKind() {
        return NodeKind.ELEMENT;
    }

    public NameTest getNameTest() {
        return this.nameTest;
    }

    public SchemaType getContentType() {
        return this.contentType;
    }

    public boolean isNilled() {
        return this.nilled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("element(");
        sb.append(this.nameTest != null ? this.nameTest : "*");
        if (this.contentType != null) {
            sb.append(", ").append(this.contentType);
        }
        if (this.nilled) {
            sb.append(", nilled");
        }
        return sb.append(")").toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
        result = 31 * result + (this.nameTest == null ? 0 : this.nameTest.hashCode());
        result = 31 * result + (this.nilled ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementType other = (ElementType)obj;
        if (this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType)) {
            return false;
        }
        if (this.nameTest == null ? other.nameTest != null : !this.nameTest.equals(other.nameTest)) {
            return false;
        }
        return this.nilled == other.nilled;
    }
}

