/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.types;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.vxquery.types.AnySimpleType;
import org.apache.vxquery.types.BuiltinAtomicType;
import org.apache.vxquery.types.BuiltinTypeQNames;
import org.apache.vxquery.types.DerivationProcess;
import org.apache.vxquery.types.SchemaType;
import org.apache.vxquery.types.SimpleType;

public final class BuiltinTypeRegistry {
    public static final BuiltinAtomicType XS_ANY_ATOMIC = new BuiltinAtomicType(3, AnySimpleType.INSTANCE, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_STRING = new BuiltinAtomicType(4, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_NORMALIZED_STRING = new BuiltinAtomicType(5, XS_STRING, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_TOKEN = new BuiltinAtomicType(6, XS_NORMALIZED_STRING, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_LANGUAGE = new BuiltinAtomicType(7, XS_TOKEN, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_NMTOKEN = new BuiltinAtomicType(8, XS_TOKEN, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_NAME = new BuiltinAtomicType(9, XS_TOKEN, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_NCNAME = new BuiltinAtomicType(10, XS_NAME, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_ID = new BuiltinAtomicType(11, XS_NCNAME, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_IDREF = new BuiltinAtomicType(12, XS_NCNAME, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_ENTITY = new BuiltinAtomicType(13, XS_NCNAME, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_UNTYPED_ATOMIC = new BuiltinAtomicType(14, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_DATETIME = new BuiltinAtomicType(15, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_DATE = new BuiltinAtomicType(16, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_TIME = new BuiltinAtomicType(17, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_DURATION = new BuiltinAtomicType(18, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_YEAR_MONTH_DURATION = new BuiltinAtomicType(19, XS_DURATION, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_DAY_TIME_DURATION = new BuiltinAtomicType(20, XS_DURATION, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XSEXT_NUMERIC = new BuiltinAtomicType(21, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_FLOAT = new BuiltinAtomicType(22, XSEXT_NUMERIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_DOUBLE = new BuiltinAtomicType(23, XSEXT_NUMERIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_DECIMAL = new BuiltinAtomicType(24, XSEXT_NUMERIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_INTEGER = new BuiltinAtomicType(25, XS_DECIMAL, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_NON_POSITIVE_INTEGER = new BuiltinAtomicType(26, XS_INTEGER, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_NEGATIVE_INTEGER = new BuiltinAtomicType(27, XS_NON_POSITIVE_INTEGER, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_LONG = new BuiltinAtomicType(28, XS_INTEGER, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_INT = new BuiltinAtomicType(29, XS_LONG, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_SHORT = new BuiltinAtomicType(30, XS_INT, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_BYTE = new BuiltinAtomicType(31, XS_SHORT, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_NON_NEGATIVE_INTEGER = new BuiltinAtomicType(32, XS_INTEGER, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_UNSIGNED_LONG = new BuiltinAtomicType(33, XS_NON_NEGATIVE_INTEGER, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_UNSIGNED_INT = new BuiltinAtomicType(34, XS_UNSIGNED_LONG, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_UNSIGNED_SHORT = new BuiltinAtomicType(35, XS_UNSIGNED_INT, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_UNSIGNED_BYTE = new BuiltinAtomicType(36, XS_UNSIGNED_SHORT, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_POSITIVE_INTEGER = new BuiltinAtomicType(37, XS_NON_NEGATIVE_INTEGER, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_G_YEAR_MONTH = new BuiltinAtomicType(38, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_G_YEAR = new BuiltinAtomicType(39, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_G_MONTH_DAY = new BuiltinAtomicType(40, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_G_DAY = new BuiltinAtomicType(41, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_G_MONTH = new BuiltinAtomicType(42, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_BOOLEAN = new BuiltinAtomicType(43, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_BASE64_BINARY = new BuiltinAtomicType(44, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_HEX_BINARY = new BuiltinAtomicType(45, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_ANY_URI = new BuiltinAtomicType(46, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_QNAME = new BuiltinAtomicType(47, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinAtomicType XS_NOTATION = new BuiltinAtomicType(48, XS_ANY_ATOMIC, DerivationProcess.RESTRICTION);
    public static final BuiltinTypeRegistry INSTANCE = new BuiltinTypeRegistry();
    private final SchemaType[] types = new SchemaType[52];
    private final QName[] typeNames;
    public static final Map<QName, SchemaType> TYPE_MAP;

    private BuiltinTypeRegistry() {
        this.types[1] = AnySimpleType.INSTANCE;
        this.types[3] = XS_ANY_ATOMIC;
        this.types[4] = XS_STRING;
        this.types[5] = XS_NORMALIZED_STRING;
        this.types[6] = XS_TOKEN;
        this.types[7] = XS_LANGUAGE;
        this.types[8] = XS_NMTOKEN;
        this.types[9] = XS_NAME;
        this.types[10] = XS_NCNAME;
        this.types[11] = XS_ID;
        this.types[12] = XS_IDREF;
        this.types[13] = XS_ENTITY;
        this.types[14] = XS_UNTYPED_ATOMIC;
        this.types[15] = XS_DATETIME;
        this.types[16] = XS_DATE;
        this.types[17] = XS_TIME;
        this.types[18] = XS_DURATION;
        this.types[19] = XS_YEAR_MONTH_DURATION;
        this.types[20] = XS_DAY_TIME_DURATION;
        this.types[21] = XSEXT_NUMERIC;
        this.types[22] = XS_FLOAT;
        this.types[23] = XS_DOUBLE;
        this.types[24] = XS_DECIMAL;
        this.types[25] = XS_INTEGER;
        this.types[26] = XS_NON_POSITIVE_INTEGER;
        this.types[27] = XS_NEGATIVE_INTEGER;
        this.types[28] = XS_LONG;
        this.types[29] = XS_INT;
        this.types[30] = XS_SHORT;
        this.types[31] = XS_BYTE;
        this.types[32] = XS_NON_NEGATIVE_INTEGER;
        this.types[33] = XS_UNSIGNED_LONG;
        this.types[34] = XS_UNSIGNED_INT;
        this.types[35] = XS_UNSIGNED_SHORT;
        this.types[36] = XS_UNSIGNED_BYTE;
        this.types[37] = XS_POSITIVE_INTEGER;
        this.types[38] = XS_G_YEAR_MONTH;
        this.types[39] = XS_G_YEAR;
        this.types[40] = XS_G_MONTH_DAY;
        this.types[41] = XS_G_DAY;
        this.types[42] = XS_G_MONTH;
        this.types[43] = XS_BOOLEAN;
        this.types[44] = XS_BASE64_BINARY;
        this.types[45] = XS_HEX_BINARY;
        this.types[46] = XS_ANY_URI;
        this.types[47] = XS_QNAME;
        this.types[48] = XS_NOTATION;
        this.typeNames = new QName[52];
        this.typeNames[0] = BuiltinTypeQNames.XS_ANY_TYPE_QNAME;
        this.typeNames[1] = BuiltinTypeQNames.XS_ANY_SIMPLE_TYPE_QNAME;
        this.typeNames[2] = BuiltinTypeQNames.XS_UNTYPED_QNAME;
        this.typeNames[3] = BuiltinTypeQNames.XS_ANY_ATOMIC_TYPE_QNAME;
        this.typeNames[4] = BuiltinTypeQNames.XS_STRING_TYPE_QNAME;
        this.typeNames[5] = BuiltinTypeQNames.XS_NORMALIZED_STRING_TYPE_QNAME;
        this.typeNames[6] = BuiltinTypeQNames.XS_TOKEN_TYPE_QNAME;
        this.typeNames[7] = BuiltinTypeQNames.XS_LANGUAGE_TYPE_QNAME;
        this.typeNames[8] = BuiltinTypeQNames.XS_NMTOKEN_TYPE_QNAME;
        this.typeNames[9] = BuiltinTypeQNames.XS_NAME_TYPE_QNAME;
        this.typeNames[10] = BuiltinTypeQNames.XS_NCNAME_TYPE_QNAME;
        this.typeNames[11] = BuiltinTypeQNames.XS_ID_TYPE_QNAME;
        this.typeNames[12] = BuiltinTypeQNames.XS_IDREF_TYPE_QNAME;
        this.typeNames[13] = BuiltinTypeQNames.XS_ENTITY_TYPE_QNAME;
        this.typeNames[14] = BuiltinTypeQNames.XS_UNTYPED_ATOMIC_TYPE_QNAME;
        this.typeNames[15] = BuiltinTypeQNames.XS_DATETIME_TYPE_QNAME;
        this.typeNames[16] = BuiltinTypeQNames.XS_DATE_TYPE_QNAME;
        this.typeNames[17] = BuiltinTypeQNames.XS_TIME_TYPE_QNAME;
        this.typeNames[18] = BuiltinTypeQNames.XS_DURATION_TYPE_QNAME;
        this.typeNames[19] = BuiltinTypeQNames.XS_YEAR_MONTH_DURATION_TYPE_QNAME;
        this.typeNames[20] = BuiltinTypeQNames.XS_DAY_TIME_DURATION_TYPE_QNAME;
        this.typeNames[21] = BuiltinTypeQNames.XSEXT_NUMERIC_TYPE_QNAME;
        this.typeNames[22] = BuiltinTypeQNames.XS_FLOAT_TYPE_QNAME;
        this.typeNames[23] = BuiltinTypeQNames.XS_DOUBLE_TYPE_QNAME;
        this.typeNames[24] = BuiltinTypeQNames.XS_DECIMAL_TYPE_QNAME;
        this.typeNames[25] = BuiltinTypeQNames.XS_INTEGER_TYPE_QNAME;
        this.typeNames[26] = BuiltinTypeQNames.XS_NON_POSITIVE_INTEGER_TYPE_QNAME;
        this.typeNames[27] = BuiltinTypeQNames.XS_NEGATIVE_INTEGER_TYPE_QNAME;
        this.typeNames[28] = BuiltinTypeQNames.XS_LONG_TYPE_QNAME;
        this.typeNames[29] = BuiltinTypeQNames.XS_INT_TYPE_QNAME;
        this.typeNames[30] = BuiltinTypeQNames.XS_SHORT_TYPE_QNAME;
        this.typeNames[31] = BuiltinTypeQNames.XS_BYTE_TYPE_QNAME;
        this.typeNames[32] = BuiltinTypeQNames.XS_NON_NEGATIVE_INTEGER_TYPE_QNAME;
        this.typeNames[33] = BuiltinTypeQNames.XS_UNSIGNED_LONG_TYPE_QNAME;
        this.typeNames[34] = BuiltinTypeQNames.XS_UNSIGNED_INT_TYPE_QNAME;
        this.typeNames[35] = BuiltinTypeQNames.XS_UNSIGNED_SHORT_TYPE_QNAME;
        this.typeNames[36] = BuiltinTypeQNames.XS_UNSIGNED_BYTE_TYPE_QNAME;
        this.typeNames[37] = BuiltinTypeQNames.XS_POSITIVE_INTEGER_TYPE_QNAME;
        this.typeNames[38] = BuiltinTypeQNames.XS_G_YEAR_MONTH_TYPE_QNAME;
        this.typeNames[39] = BuiltinTypeQNames.XS_G_YEAR_TYPE_QNAME;
        this.typeNames[40] = BuiltinTypeQNames.XS_G_MONTH_DAY_TYPE_QNAME;
        this.typeNames[41] = BuiltinTypeQNames.XS_G_DAY_TYPE_QNAME;
        this.typeNames[42] = BuiltinTypeQNames.XS_G_MONTH_TYPE_QNAME;
        this.typeNames[43] = BuiltinTypeQNames.XS_BOOLEAN_TYPE_QNAME;
        this.typeNames[44] = BuiltinTypeQNames.XS_BASE64_BINARY_TYPE_QNAME;
        this.typeNames[45] = BuiltinTypeQNames.XS_HEX_BINARY_TYPE_QNAME;
        this.typeNames[46] = BuiltinTypeQNames.XS_ANY_URI_TYPE_QNAME;
        this.typeNames[47] = BuiltinTypeQNames.XS_QNAME_TYPE_QNAME;
        this.typeNames[48] = BuiltinTypeQNames.XS_NOTATION_TYPE_QNAME;
    }

    public SchemaType getSchemaTypeById(int id) {
        return this.types[id];
    }

    public boolean isBuiltinTypeId(int id) {
        return id < 52;
    }

    public boolean isBuiltinType(SchemaType type) {
        return this.isBuiltinTypeId(type.getTypeId());
    }

    public SchemaType getBuiltinBaseType(SchemaType type) {
        while (!this.isBuiltinType(type)) {
            type = type.getBaseType();
        }
        return type;
    }

    public QName getTypeName(int id) {
        return this.typeNames[id];
    }

    static {
        LinkedHashMap<QName, SimpleType> typeMap = new LinkedHashMap<QName, SimpleType>();
        typeMap.put(BuiltinTypeQNames.XS_ANY_SIMPLE_TYPE_QNAME, AnySimpleType.INSTANCE);
        typeMap.put(BuiltinTypeQNames.XS_ANY_ATOMIC_TYPE_QNAME, XS_ANY_ATOMIC);
        typeMap.put(BuiltinTypeQNames.XS_STRING_TYPE_QNAME, XS_STRING);
        typeMap.put(BuiltinTypeQNames.XS_NORMALIZED_STRING_TYPE_QNAME, XS_NORMALIZED_STRING);
        typeMap.put(BuiltinTypeQNames.XS_TOKEN_TYPE_QNAME, XS_TOKEN);
        typeMap.put(BuiltinTypeQNames.XS_LANGUAGE_TYPE_QNAME, XS_LANGUAGE);
        typeMap.put(BuiltinTypeQNames.XS_NMTOKEN_TYPE_QNAME, XS_NMTOKEN);
        typeMap.put(BuiltinTypeQNames.XS_NAME_TYPE_QNAME, XS_NAME);
        typeMap.put(BuiltinTypeQNames.XS_NCNAME_TYPE_QNAME, XS_NCNAME);
        typeMap.put(BuiltinTypeQNames.XS_ID_TYPE_QNAME, XS_ID);
        typeMap.put(BuiltinTypeQNames.XS_IDREF_TYPE_QNAME, XS_IDREF);
        typeMap.put(BuiltinTypeQNames.XS_ENTITY_TYPE_QNAME, XS_ENTITY);
        typeMap.put(BuiltinTypeQNames.XS_UNTYPED_ATOMIC_TYPE_QNAME, XS_UNTYPED_ATOMIC);
        typeMap.put(BuiltinTypeQNames.XS_DATETIME_TYPE_QNAME, XS_DATETIME);
        typeMap.put(BuiltinTypeQNames.XS_DATE_TYPE_QNAME, XS_DATE);
        typeMap.put(BuiltinTypeQNames.XS_TIME_TYPE_QNAME, XS_TIME);
        typeMap.put(BuiltinTypeQNames.XS_DURATION_TYPE_QNAME, XS_DURATION);
        typeMap.put(BuiltinTypeQNames.XS_YEAR_MONTH_DURATION_TYPE_QNAME, XS_YEAR_MONTH_DURATION);
        typeMap.put(BuiltinTypeQNames.XS_DAY_TIME_DURATION_TYPE_QNAME, XS_DAY_TIME_DURATION);
        typeMap.put(BuiltinTypeQNames.XSEXT_NUMERIC_TYPE_QNAME, XSEXT_NUMERIC);
        typeMap.put(BuiltinTypeQNames.XS_FLOAT_TYPE_QNAME, XS_FLOAT);
        typeMap.put(BuiltinTypeQNames.XS_DOUBLE_TYPE_QNAME, XS_DOUBLE);
        typeMap.put(BuiltinTypeQNames.XS_DECIMAL_TYPE_QNAME, XS_DECIMAL);
        typeMap.put(BuiltinTypeQNames.XS_INTEGER_TYPE_QNAME, XS_INTEGER);
        typeMap.put(BuiltinTypeQNames.XS_NON_POSITIVE_INTEGER_TYPE_QNAME, XS_NON_POSITIVE_INTEGER);
        typeMap.put(BuiltinTypeQNames.XS_NEGATIVE_INTEGER_TYPE_QNAME, XS_NEGATIVE_INTEGER);
        typeMap.put(BuiltinTypeQNames.XS_LONG_TYPE_QNAME, XS_LONG);
        typeMap.put(BuiltinTypeQNames.XS_INT_TYPE_QNAME, XS_INT);
        typeMap.put(BuiltinTypeQNames.XS_SHORT_TYPE_QNAME, XS_SHORT);
        typeMap.put(BuiltinTypeQNames.XS_BYTE_TYPE_QNAME, XS_BYTE);
        typeMap.put(BuiltinTypeQNames.XS_NON_NEGATIVE_INTEGER_TYPE_QNAME, XS_NON_NEGATIVE_INTEGER);
        typeMap.put(BuiltinTypeQNames.XS_UNSIGNED_LONG_TYPE_QNAME, XS_UNSIGNED_LONG);
        typeMap.put(BuiltinTypeQNames.XS_UNSIGNED_INT_TYPE_QNAME, XS_UNSIGNED_INT);
        typeMap.put(BuiltinTypeQNames.XS_UNSIGNED_SHORT_TYPE_QNAME, XS_UNSIGNED_SHORT);
        typeMap.put(BuiltinTypeQNames.XS_UNSIGNED_BYTE_TYPE_QNAME, XS_UNSIGNED_BYTE);
        typeMap.put(BuiltinTypeQNames.XS_POSITIVE_INTEGER_TYPE_QNAME, XS_POSITIVE_INTEGER);
        typeMap.put(BuiltinTypeQNames.XS_G_YEAR_MONTH_TYPE_QNAME, XS_G_YEAR_MONTH);
        typeMap.put(BuiltinTypeQNames.XS_G_YEAR_TYPE_QNAME, XS_G_YEAR);
        typeMap.put(BuiltinTypeQNames.XS_G_MONTH_DAY_TYPE_QNAME, XS_G_MONTH_DAY);
        typeMap.put(BuiltinTypeQNames.XS_G_DAY_TYPE_QNAME, XS_G_DAY);
        typeMap.put(BuiltinTypeQNames.XS_G_MONTH_TYPE_QNAME, XS_G_MONTH);
        typeMap.put(BuiltinTypeQNames.XS_BOOLEAN_TYPE_QNAME, XS_BOOLEAN);
        typeMap.put(BuiltinTypeQNames.XS_BASE64_BINARY_TYPE_QNAME, XS_BASE64_BINARY);
        typeMap.put(BuiltinTypeQNames.XS_HEX_BINARY_TYPE_QNAME, XS_HEX_BINARY);
        typeMap.put(BuiltinTypeQNames.XS_ANY_URI_TYPE_QNAME, XS_ANY_URI);
        typeMap.put(BuiltinTypeQNames.XS_QNAME_TYPE_QNAME, XS_QNAME);
        typeMap.put(BuiltinTypeQNames.XS_NOTATION_TYPE_QNAME, XS_NOTATION);
        TYPE_MAP = Collections.unmodifiableMap(typeMap);
    }
}

