/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.types;

import org.apache.vxquery.types.AtomicType;
import org.apache.vxquery.types.BuiltinTypeRegistry;
import org.apache.vxquery.types.DerivationProcess;
import org.apache.vxquery.types.SchemaType;
import org.apache.vxquery.types.SimpleType;

final class BuiltinAtomicType
implements AtomicType {
    private final int id;
    private final SchemaType baseType;
    private final DerivationProcess derivationProcess;

    BuiltinAtomicType(int id, SimpleType baseType, DerivationProcess derivationProcess) {
        this.id = id;
        this.baseType = baseType;
        this.derivationProcess = derivationProcess;
    }

    @Override
    public boolean isAtomicType() {
        return true;
    }

    @Override
    public int getTypeId() {
        return this.id;
    }

    @Override
    public SchemaType getBaseType() {
        return this.baseType;
    }

    @Override
    public DerivationProcess getDerivationProcess() {
        return this.derivationProcess;
    }

    @Override
    public boolean isComplexType() {
        return false;
    }

    @Override
    public boolean isSimpleType() {
        return true;
    }

    public String toString() {
        return String.valueOf(BuiltinTypeRegistry.INSTANCE.getTypeName(this.id));
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuiltinAtomicType other = (BuiltinAtomicType)obj;
        return this.id == other.id;
    }
}

