/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.serializer;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.data.IPrinter;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.BooleanPointable;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.FloatPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.primitive.ShortPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.vxquery.datamodel.accessors.PointablePool;
import org.apache.vxquery.datamodel.accessors.PointablePoolFactory;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.accessors.atomic.CodedQNamePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSBinaryPointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDatePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDateTimePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDecimalPointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDurationPointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSQNamePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSTimePointable;
import org.apache.vxquery.datamodel.accessors.nodes.AttributeNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.DocumentNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.ElementNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.NodeTreePointable;
import org.apache.vxquery.datamodel.accessors.nodes.PINodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.TextOrCommentNodePointable;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.cast.CastToStringOperation;

public class XMLSerializer
implements IPrinter {
    private final PointablePool pp;
    private NodeTreePointable ntp;
    private ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
    private DataOutput dOut = this.abvs.getDataOutput();
    private CastToStringOperation castToString = new CastToStringOperation();

    public XMLSerializer() {
        this.pp = PointablePoolFactory.INSTANCE.createPointablePool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(byte[] b, int s, int l, PrintStream ps) {
        TaggedValuePointable tvp = this.pp.takeOne(TaggedValuePointable.class);
        try {
            tvp.set(b, s, l);
            this.printTaggedValuePointable(ps, tvp);
        }
        finally {
            this.pp.giveBack(tvp);
        }
    }

    public void printTaggedValuePointable(PrintStream ps, TaggedValuePointable tvp) {
        byte tag = tvp.getTag();
        switch (tag) {
            case 46: {
                this.printString(ps, tvp);
                break;
            }
            case 44: {
                this.printBase64Binary(ps, tvp);
                break;
            }
            case 43: {
                this.printBoolean(ps, tvp);
                break;
            }
            case 16: {
                this.printDate(ps, tvp);
                break;
            }
            case 15: {
                this.printDateTime(ps, tvp);
                break;
            }
            case 20: {
                this.printDTDuration(ps, tvp);
                break;
            }
            case 31: {
                this.printByte(ps, tvp);
                break;
            }
            case 24: {
                this.printDecimal(ps, tvp);
                break;
            }
            case 23: {
                this.printDouble(ps, tvp);
                break;
            }
            case 18: {
                this.printDuration(ps, tvp);
                break;
            }
            case 22: {
                this.printFloat(ps, tvp);
                break;
            }
            case 41: {
                this.printGDay(ps, tvp);
                break;
            }
            case 42: {
                this.printGMonth(ps, tvp);
                break;
            }
            case 40: {
                this.printGMonthDay(ps, tvp);
                break;
            }
            case 39: {
                this.printGYear(ps, tvp);
                break;
            }
            case 38: {
                this.printGYearMonth(ps, tvp);
                break;
            }
            case 45: {
                this.printHexBinary(ps, tvp);
                break;
            }
            case 29: 
            case 35: {
                this.printInt(ps, tvp);
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 37: {
                this.printInteger(ps, tvp);
                break;
            }
            case 48: {
                this.printString(ps, tvp);
                break;
            }
            case 47: {
                this.printQName(ps, tvp);
                break;
            }
            case 30: 
            case 36: {
                this.printShort(ps, tvp);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.printString(ps, tvp);
                break;
            }
            case 17: {
                this.printTime(ps, tvp);
                break;
            }
            case 14: {
                this.printString(ps, tvp);
                break;
            }
            case 19: {
                this.printYMDuration(ps, tvp);
                break;
            }
            case 100: {
                this.printSequence(ps, tvp);
                break;
            }
            case 107: {
                this.printNodeTree(ps, tvp);
                break;
            }
            case 101: {
                this.printDocumentNode(ps, tvp);
                break;
            }
            case 102: {
                this.printElementNode(ps, tvp);
                break;
            }
            case 103: {
                this.printAttributeNode(ps, tvp);
                break;
            }
            case 104: {
                this.printTextNode(ps, tvp);
                break;
            }
            case 105: {
                this.printCommentNode(ps, tvp);
                break;
            }
            case 106: {
                this.printPINode(ps, tvp);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Encountered tag: " + tvp.getTag());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printDecimal(PrintStream ps, TaggedValuePointable tvp) {
        XSDecimalPointable dp = this.pp.takeOne(XSDecimalPointable.class);
        try {
            tvp.getValue((IPointable)dp);
            this.abvs.reset();
            this.castToString.convertDecimal(dp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(dp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printNodeTree(PrintStream ps, TaggedValuePointable tvp) {
        if (this.ntp != null) {
            throw new IllegalStateException("Nested NodeTreePointable found");
        }
        this.ntp = this.pp.takeOne(NodeTreePointable.class);
        TaggedValuePointable rootTVP = this.pp.takeOne(TaggedValuePointable.class);
        try {
            tvp.getValue((IPointable)this.ntp);
            this.ntp.getRootNode(rootTVP);
            this.printTaggedValuePointable(ps, rootTVP);
        }
        finally {
            this.pp.giveBack(rootTVP);
            this.pp.giveBack(this.ntp);
            this.ntp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printPINode(PrintStream ps, TaggedValuePointable tvp) {
        PINodePointable pnp = this.pp.takeOne(PINodePointable.class);
        UTF8StringPointable utf8sp = this.pp.takeOne(UTF8StringPointable.class);
        try {
            tvp.getValue((IPointable)pnp);
            ps.append("<?");
            pnp.getTarget(this.ntp, (IPointable)utf8sp);
            this.printString(ps, utf8sp);
            ps.append(' ');
            pnp.getContent(this.ntp, (IPointable)utf8sp);
            this.printString(ps, utf8sp);
            ps.append("?>");
        }
        finally {
            this.pp.giveBack(pnp);
            this.pp.giveBack(utf8sp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printCommentNode(PrintStream ps, TaggedValuePointable tvp) {
        TextOrCommentNodePointable tcnp = this.pp.takeOne(TextOrCommentNodePointable.class);
        UTF8StringPointable utf8sp = this.pp.takeOne(UTF8StringPointable.class);
        try {
            tvp.getValue((IPointable)tcnp);
            tcnp.getValue(this.ntp, (IPointable)utf8sp);
            ps.append("<!--");
            this.printString(ps, utf8sp);
            ps.append("-->");
        }
        finally {
            this.pp.giveBack(tcnp);
            this.pp.giveBack(utf8sp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printTextNode(PrintStream ps, TaggedValuePointable tvp) {
        TextOrCommentNodePointable tcnp = this.pp.takeOne(TextOrCommentNodePointable.class);
        UTF8StringPointable utf8sp = this.pp.takeOne(UTF8StringPointable.class);
        try {
            tvp.getValue((IPointable)tcnp);
            tcnp.getValue(this.ntp, (IPointable)utf8sp);
            this.printString(ps, utf8sp);
        }
        finally {
            this.pp.giveBack(tcnp);
            this.pp.giveBack(utf8sp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printAttributeNode(PrintStream ps, TaggedValuePointable tvp) {
        AttributeNodePointable anp = this.pp.takeOne(AttributeNodePointable.class);
        CodedQNamePointable cqp = this.pp.takeOne(CodedQNamePointable.class);
        UTF8StringPointable utf8sp = this.pp.takeOne(UTF8StringPointable.class);
        TaggedValuePointable valueTVP = this.pp.takeOne(TaggedValuePointable.class);
        try {
            tvp.getValue((IPointable)anp);
            anp.getName(cqp);
            this.printPrefixedQName(ps, cqp, utf8sp);
            ps.append("=\"");
            anp.getValue(this.ntp, (IPointable)valueTVP);
            this.printTaggedValuePointable(ps, valueTVP);
            ps.append('\"');
        }
        finally {
            this.pp.giveBack(valueTVP);
            this.pp.giveBack(utf8sp);
            this.pp.giveBack(anp);
            this.pp.giveBack(cqp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printElementNode(PrintStream ps, TaggedValuePointable tvp) {
        ElementNodePointable enp = this.pp.takeOne(ElementNodePointable.class);
        CodedQNamePointable cqp = this.pp.takeOne(CodedQNamePointable.class);
        UTF8StringPointable utf8sp = this.pp.takeOne(UTF8StringPointable.class);
        SequencePointable seqp = this.pp.takeOne(SequencePointable.class);
        try {
            tvp.getValue((IPointable)enp);
            enp.getName(cqp);
            ps.append('<');
            this.printPrefixedQName(ps, cqp, utf8sp);
            int nsCount = enp.getNamespaceEntryCount(this.ntp);
            for (int i = 0; i < nsCount; ++i) {
                ps.append(" xmlns:");
                this.ntp.getString(enp.getNamespacePrefixCode(this.ntp, i), (IPointable)utf8sp);
                this.printString(ps, utf8sp);
                ps.append("=\"");
                this.ntp.getString(enp.getNamespaceURICode(this.ntp, i), (IPointable)utf8sp);
                this.printString(ps, utf8sp);
                ps.append("\"");
            }
            enp.getAttributeSequence(this.ntp, seqp);
            if (seqp.getByteArray() != null && seqp.getEntryCount() > 0) {
                ps.append(' ');
                this.printSequence(ps, seqp);
            }
            enp.getChildrenSequence(this.ntp, seqp);
            if (seqp.getByteArray() != null) {
                ps.append('>');
                this.printSequence(ps, seqp);
                ps.append("</");
                this.printPrefixedQName(ps, cqp, utf8sp);
                ps.append('>');
            } else {
                ps.append("/>");
            }
        }
        finally {
            this.pp.giveBack(seqp);
            this.pp.giveBack(utf8sp);
            this.pp.giveBack(cqp);
            this.pp.giveBack(enp);
        }
    }

    private void printPrefixedQName(PrintStream ps, CodedQNamePointable cqp, UTF8StringPointable utf8sp) {
        this.ntp.getString(cqp.getPrefixCode(), (IPointable)utf8sp);
        if (utf8sp.getStringLength() > 0) {
            this.printString(ps, utf8sp);
            ps.append(':');
        }
        this.ntp.getString(cqp.getLocalCode(), (IPointable)utf8sp);
        this.printString(ps, utf8sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printDocumentNode(PrintStream ps, TaggedValuePointable tvp) {
        DocumentNodePointable dnp = this.pp.takeOne(DocumentNodePointable.class);
        SequencePointable seqp = this.pp.takeOne(SequencePointable.class);
        try {
            ps.append("<?xml version=\"1.0\"?>\n");
            tvp.getValue((IPointable)dnp);
            dnp.getContent(this.ntp, seqp);
            this.printSequence(ps, seqp);
        }
        finally {
            this.pp.giveBack(seqp);
            this.pp.giveBack(dnp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSequence(PrintStream ps, TaggedValuePointable tvp) {
        SequencePointable seqp = this.pp.takeOne(SequencePointable.class);
        try {
            tvp.getValue((IPointable)seqp);
            this.printSequence(ps, seqp);
        }
        finally {
            this.pp.giveBack(seqp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSequence(PrintStream ps, SequencePointable seqp) {
        VoidPointable vp = this.pp.takeOne(VoidPointable.class);
        try {
            int len = seqp.getEntryCount();
            for (int i = 0; i < len; ++i) {
                seqp.getEntry(i, (IPointable)vp);
                this.print(vp.getByteArray(), vp.getStartOffset(), vp.getLength(), ps);
            }
        }
        finally {
            this.pp.giveBack(vp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printBase64Binary(PrintStream ps, TaggedValuePointable tvp) {
        XSBinaryPointable bp = this.pp.takeOne(XSBinaryPointable.class);
        try {
            tvp.getValue((IPointable)bp);
            this.abvs.reset();
            this.castToString.convertBase64Binary(bp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(bp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printBoolean(PrintStream ps, TaggedValuePointable tvp) {
        BooleanPointable bp = this.pp.takeOne(BooleanPointable.class);
        try {
            tvp.getValue((IPointable)bp);
            ps.print(bp.getBoolean());
        }
        finally {
            this.pp.giveBack(bp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printByte(PrintStream ps, TaggedValuePointable tvp) {
        BytePointable bp = this.pp.takeOne(BytePointable.class);
        try {
            tvp.getValue((IPointable)bp);
            ps.print(bp.byteValue());
        }
        finally {
            this.pp.giveBack(bp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printDouble(PrintStream ps, TaggedValuePointable tvp) {
        DoublePointable dp = this.pp.takeOne(DoublePointable.class);
        try {
            tvp.getValue((IPointable)dp);
            this.abvs.reset();
            this.castToString.convertDouble(dp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(dp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printDate(PrintStream ps, TaggedValuePointable tvp) {
        XSDatePointable dp = this.pp.takeOne(XSDatePointable.class);
        try {
            tvp.getValue((IPointable)dp);
            this.abvs.reset();
            this.castToString.convertDate(dp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(dp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printDateTime(PrintStream ps, TaggedValuePointable tvp) {
        XSDateTimePointable dtp = this.pp.takeOne(XSDateTimePointable.class);
        try {
            tvp.getValue((IPointable)dtp);
            this.abvs.reset();
            this.castToString.convertDatetime(dtp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(dtp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printDTDuration(PrintStream ps, TaggedValuePointable tvp) {
        LongPointable lp = this.pp.takeOne(LongPointable.class);
        try {
            tvp.getValue((IPointable)lp);
            this.abvs.reset();
            this.castToString.convertDTDuration(lp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(lp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printDuration(PrintStream ps, TaggedValuePointable tvp) {
        XSDurationPointable dp = this.pp.takeOne(XSDurationPointable.class);
        try {
            tvp.getValue((IPointable)dp);
            this.abvs.reset();
            this.castToString.convertDuration(dp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(dp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printFloat(PrintStream ps, TaggedValuePointable tvp) {
        FloatPointable fp = this.pp.takeOne(FloatPointable.class);
        try {
            tvp.getValue((IPointable)fp);
            this.abvs.reset();
            this.castToString.convertFloat(fp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(fp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printGDay(PrintStream ps, TaggedValuePointable tvp) {
        XSDatePointable dp = this.pp.takeOne(XSDatePointable.class);
        try {
            tvp.getValue((IPointable)dp);
            this.abvs.reset();
            this.castToString.convertGDay(dp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(dp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printGMonth(PrintStream ps, TaggedValuePointable tvp) {
        XSDatePointable dp = this.pp.takeOne(XSDatePointable.class);
        try {
            tvp.getValue((IPointable)dp);
            this.abvs.reset();
            this.castToString.convertGMonth(dp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(dp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printGMonthDay(PrintStream ps, TaggedValuePointable tvp) {
        XSDatePointable dp = this.pp.takeOne(XSDatePointable.class);
        try {
            tvp.getValue((IPointable)dp);
            this.abvs.reset();
            this.castToString.convertGMonthDay(dp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(dp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printGYear(PrintStream ps, TaggedValuePointable tvp) {
        XSDatePointable dp = this.pp.takeOne(XSDatePointable.class);
        try {
            tvp.getValue((IPointable)dp);
            this.abvs.reset();
            this.castToString.convertGYear(dp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(dp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printGYearMonth(PrintStream ps, TaggedValuePointable tvp) {
        XSDatePointable dp = this.pp.takeOne(XSDatePointable.class);
        try {
            tvp.getValue((IPointable)dp);
            this.abvs.reset();
            this.castToString.convertGYearMonth(dp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(dp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printHexBinary(PrintStream ps, TaggedValuePointable tvp) {
        XSBinaryPointable bp = this.pp.takeOne(XSBinaryPointable.class);
        try {
            tvp.getValue((IPointable)bp);
            this.abvs.reset();
            this.castToString.convertHexBinary(bp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(bp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printInt(PrintStream ps, TaggedValuePointable tvp) {
        IntegerPointable ip = this.pp.takeOne(IntegerPointable.class);
        try {
            tvp.getValue((IPointable)ip);
            ps.print(ip.intValue());
        }
        finally {
            this.pp.giveBack(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printInteger(PrintStream ps, TaggedValuePointable tvp) {
        LongPointable lp = this.pp.takeOne(LongPointable.class);
        try {
            tvp.getValue((IPointable)lp);
            ps.print(lp.longValue());
        }
        finally {
            this.pp.giveBack(lp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printShort(PrintStream ps, TaggedValuePointable tvp) {
        ShortPointable sp = this.pp.takeOne(ShortPointable.class);
        try {
            tvp.getValue((IPointable)sp);
            ps.print(sp.shortValue());
        }
        finally {
            this.pp.giveBack(sp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printQName(PrintStream ps, TaggedValuePointable tvp) {
        XSQNamePointable dp = this.pp.takeOne(XSQNamePointable.class);
        try {
            tvp.getValue((IPointable)dp);
            this.abvs.reset();
            this.castToString.convertQName(dp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(dp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStringAbvs(PrintStream ps) {
        UTF8StringPointable utf8sp = this.pp.takeOne(UTF8StringPointable.class);
        try {
            utf8sp.set(this.abvs.getByteArray(), this.abvs.getStartOffset() + 1, this.abvs.getLength() - 1);
            this.printString(ps, utf8sp);
        }
        finally {
            this.pp.giveBack(utf8sp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printString(PrintStream ps, TaggedValuePointable tvp) {
        UTF8StringPointable utf8sp = this.pp.takeOne(UTF8StringPointable.class);
        try {
            tvp.getValue((IPointable)utf8sp);
            this.printString(ps, utf8sp);
        }
        finally {
            this.pp.giveBack(utf8sp);
        }
    }

    private void printString(PrintStream ps, UTF8StringPointable utf8sp) {
        int cLen;
        int offset = 2;
        for (int utfLen = utf8sp.getUTFLength(); utfLen > 0; utfLen -= cLen) {
            char c = utf8sp.charAt(offset);
            switch (c) {
                case '<': {
                    ps.append("&lt;");
                    break;
                }
                case '>': {
                    ps.append("&gt;");
                    break;
                }
                case '&': {
                    ps.append("&amp;");
                    break;
                }
                case '\"': {
                    ps.append("&quot;");
                    break;
                }
                case '\'': {
                    ps.append("&apos;");
                    break;
                }
                default: {
                    ps.append(c);
                }
            }
            cLen = UTF8StringPointable.getModifiedUTF8Len((char)c);
            offset += cLen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printTime(PrintStream ps, TaggedValuePointable tvp) {
        XSTimePointable tp = this.pp.takeOne(XSTimePointable.class);
        try {
            tvp.getValue((IPointable)tp);
            this.abvs.reset();
            this.castToString.convertTime(tp, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(tp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printYMDuration(PrintStream ps, TaggedValuePointable tvp) {
        IntegerPointable ip = this.pp.takeOne(IntegerPointable.class);
        try {
            tvp.getValue((IPointable)ip);
            this.abvs.reset();
            this.castToString.convertYMDuration(ip, this.dOut);
            this.printStringAbvs(ps);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.pp.giveBack(ip);
        }
    }

    public void init() throws AlgebricksException {
    }
}

