/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.util;

import edu.uci.ics.hyracks.api.exceptions.HyracksDataException;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.primitive.BooleanPointable;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.FloatPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.primitive.ShortPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import edu.uci.ics.hyracks.dataflow.common.comm.util.ByteBufferInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.vxquery.context.DynamicContext;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSBinaryPointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDatePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDateTimePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDecimalPointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDurationPointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSQNamePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSTimePointable;
import org.apache.vxquery.datamodel.accessors.nodes.AttributeNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.DocumentNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.ElementNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.NodeTreePointable;
import org.apache.vxquery.datamodel.accessors.nodes.PINodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.TextOrCommentNodePointable;
import org.apache.vxquery.datamodel.api.IDate;
import org.apache.vxquery.datamodel.api.ITime;
import org.apache.vxquery.datamodel.api.ITimezone;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.arithmetic.AbstractArithmeticOperation;
import org.apache.vxquery.runtime.functions.cast.CastToDoubleOperation;
import org.apache.vxquery.runtime.functions.comparison.AbstractValueComparisonOperation;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;
import org.apache.vxquery.types.BuiltinTypeRegistry;
import org.apache.vxquery.xmlparser.XMLParser;
import org.xml.sax.InputSource;

public class FunctionHelper {
    public static void arithmeticOperation(AbstractArithmeticOperation aOp, DynamicContext dCtx, TaggedValuePointable tvp1, TaggedValuePointable tvp2, IPointable result) throws SystemException {
        ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        DataOutput dOut = abvs.getDataOutput();
        ArrayBackedValueStorage abvsArgument1 = new ArrayBackedValueStorage();
        DataOutput dOutArgument1 = abvsArgument1.getDataOutput();
        ArrayBackedValueStorage abvsArgument2 = new ArrayBackedValueStorage();
        DataOutput dOutArgument2 = abvsArgument2.getDataOutput();
        TypedPointables tp1 = new TypedPointables();
        TypedPointables tp2 = new TypedPointables();
        CastToDoubleOperation castToDouble = new CastToDoubleOperation();
        abvs.reset();
        try {
            int tid1 = FunctionHelper.getBaseTypeForArithmetics(tvp1.getTag());
            int tid2 = FunctionHelper.getBaseTypeForArithmetics(tvp2.getTag());
            LongPointable longp1 = (LongPointable)LongPointable.FACTORY.createPointable();
            DoublePointable doublep1 = (DoublePointable)DoublePointable.FACTORY.createPointable();
            switch (tvp1.getTag()) {
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    abvsArgument1.reset();
                    FunctionHelper.getIntegerPointable(tvp1, dOutArgument1);
                    longp1.set(abvsArgument1.getByteArray(), abvsArgument1.getStartOffset() + 1, LongPointable.TYPE_TRAITS.getFixedLength());
                    break;
                }
                case 23: {
                    tvp1.getValue((IPointable)doublep1);
                    break;
                }
                case 14: {
                    tid1 = 23;
                    tvp1.getValue((IPointable)tp1.utf8sp);
                    abvsArgument1.reset();
                    castToDouble.convertUntypedAtomic(tp1.utf8sp, dOutArgument1);
                    doublep1.set(abvsArgument1.getByteArray(), abvsArgument1.getStartOffset() + 1, DoublePointable.TYPE_TRAITS.getFixedLength());
                }
            }
            LongPointable longp2 = (LongPointable)LongPointable.FACTORY.createPointable();
            DoublePointable doublep2 = (DoublePointable)DoublePointable.FACTORY.createPointable();
            switch (tvp2.getTag()) {
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    abvsArgument2.reset();
                    FunctionHelper.getIntegerPointable(tvp2, dOutArgument2);
                    longp2.set(abvsArgument2.getByteArray(), abvsArgument2.getStartOffset() + 1, LongPointable.TYPE_TRAITS.getFixedLength());
                    break;
                }
                case 23: {
                    tvp2.getValue((IPointable)doublep2);
                    break;
                }
                case 14: {
                    tid2 = 23;
                    tvp2.getValue((IPointable)tp2.utf8sp);
                    abvsArgument2.reset();
                    castToDouble.convertUntypedAtomic(tp2.utf8sp, dOutArgument2);
                    doublep2.set(abvsArgument2.getByteArray(), abvsArgument2.getStartOffset() + 1, DoublePointable.TYPE_TRAITS.getFixedLength());
                }
            }
            switch (tid1) {
                case 24: {
                    tvp1.getValue((IPointable)tp1.decp);
                    switch (tid2) {
                        case 24: {
                            tvp2.getValue((IPointable)tp2.decp);
                            aOp.operateDecimalDecimal(tp1.decp, tp2.decp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 25: {
                            aOp.operateDecimalInteger(tp1.decp, longp2, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 22: {
                            tvp2.getValue((IPointable)tp2.floatp);
                            aOp.operateDecimalFloat(tp1.decp, tp2.floatp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 23: {
                            aOp.operateDecimalDouble(tp1.decp, doublep2, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 20: {
                            tvp2.getValue((IPointable)tp2.longp);
                            aOp.operateDecimalDTDuration(tp1.decp, tp2.longp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 19: {
                            tvp2.getValue((IPointable)tp2.intp);
                            aOp.operateDecimalYMDuration(tp1.decp, tp2.intp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                    }
                    break;
                }
                case 25: {
                    switch (tid2) {
                        case 24: {
                            tvp2.getValue((IPointable)tp2.decp);
                            aOp.operateIntegerDecimal(longp1, tp2.decp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 25: {
                            aOp.operateIntegerInteger(longp1, longp2, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 22: {
                            tvp2.getValue((IPointable)tp2.floatp);
                            aOp.operateIntegerFloat(longp1, tp2.floatp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 23: {
                            aOp.operateIntegerDouble(longp1, doublep2, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 20: {
                            tvp2.getValue((IPointable)tp2.longp);
                            aOp.operateIntegerDTDuration(longp1, tp2.longp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 19: {
                            tvp2.getValue((IPointable)tp2.intp);
                            aOp.operateIntegerYMDuration(longp1, tp2.intp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                    }
                    break;
                }
                case 22: {
                    tvp1.getValue((IPointable)tp1.floatp);
                    switch (tid2) {
                        case 24: {
                            tvp2.getValue((IPointable)tp2.decp);
                            aOp.operateFloatDecimal(tp1.floatp, tp2.decp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 25: {
                            aOp.operateFloatInteger(tp1.floatp, longp2, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 22: {
                            tvp2.getValue((IPointable)tp2.floatp);
                            aOp.operateFloatFloat(tp1.floatp, tp2.floatp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 23: {
                            aOp.operateFloatDouble(tp1.floatp, doublep2, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 20: {
                            tvp2.getValue((IPointable)tp2.longp);
                            aOp.operateFloatDTDuration(tp1.floatp, tp2.longp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 19: {
                            tvp2.getValue((IPointable)tp2.intp);
                            aOp.operateFloatYMDuration(tp1.floatp, tp2.intp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                    }
                    break;
                }
                case 23: {
                    switch (tid2) {
                        case 24: {
                            tvp2.getValue((IPointable)tp2.decp);
                            aOp.operateDoubleDecimal(doublep1, tp2.decp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 25: {
                            aOp.operateDoubleInteger(doublep1, longp2, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 22: {
                            tvp2.getValue((IPointable)tp2.floatp);
                            aOp.operateDoubleFloat(doublep1, tp2.floatp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 23: {
                            aOp.operateDoubleDouble(doublep1, doublep2, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 20: {
                            tvp2.getValue((IPointable)tp2.longp);
                            aOp.operateDoubleDTDuration(doublep1, tp2.longp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 19: {
                            tvp2.getValue((IPointable)tp2.intp);
                            aOp.operateDoubleYMDuration(doublep1, tp2.intp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                    }
                    break;
                }
                case 16: {
                    tvp1.getValue((IPointable)tp1.datep);
                    switch (tid2) {
                        case 16: {
                            tvp2.getValue((IPointable)tp2.datep);
                            aOp.operateDateDate(tp1.datep, tp2.datep, dCtx, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 20: {
                            tvp2.getValue((IPointable)tp2.longp);
                            aOp.operateDateDTDuration(tp1.datep, tp2.longp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 19: {
                            tvp2.getValue((IPointable)tp2.intp);
                            aOp.operateDateYMDuration(tp1.datep, tp2.intp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                    }
                    break;
                }
                case 15: {
                    tvp1.getValue((IPointable)tp1.datetimep);
                    switch (tid2) {
                        case 15: {
                            tvp2.getValue((IPointable)tp2.datetimep);
                            aOp.operateDatetimeDatetime(tp1.datetimep, tp2.datetimep, dCtx, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 20: {
                            tvp2.getValue((IPointable)tp2.longp);
                            aOp.operateDatetimeDTDuration(tp1.datetimep, tp2.longp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 19: {
                            tvp2.getValue((IPointable)tp2.intp);
                            aOp.operateDatetimeYMDuration(tp1.datetimep, tp2.intp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                    }
                    break;
                }
                case 17: {
                    tvp1.getValue((IPointable)tp1.timep);
                    switch (tid2) {
                        case 17: {
                            tvp2.getValue((IPointable)tp2.timep);
                            aOp.operateTimeTime(tp1.timep, tp2.timep, dCtx, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 20: {
                            tvp2.getValue((IPointable)tp2.longp);
                            aOp.operateTimeDTDuration(tp1.timep, tp2.longp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                    }
                    break;
                }
                case 20: {
                    tvp1.getValue((IPointable)tp1.longp);
                    switch (tid2) {
                        case 24: {
                            tvp2.getValue((IPointable)tp2.decp);
                            aOp.operateDTDurationDecimal(tp1.longp, tp2.decp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 25: {
                            aOp.operateDTDurationInteger(tp1.longp, longp2, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 22: {
                            tvp2.getValue((IPointable)tp2.floatp);
                            aOp.operateDTDurationFloat(tp1.longp, tp2.floatp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 23: {
                            aOp.operateDTDurationDouble(tp1.longp, doublep2, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 16: {
                            tvp2.getValue((IPointable)tp2.datep);
                            aOp.operateDTDurationDate(tp1.longp, tp2.datep, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 17: {
                            tvp2.getValue((IPointable)tp2.timep);
                            aOp.operateDTDurationTime(tp1.longp, tp2.timep, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 15: {
                            tvp2.getValue((IPointable)tp2.datetimep);
                            aOp.operateDTDurationDatetime(tp1.longp, tp2.datetimep, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 20: {
                            tvp2.getValue((IPointable)tp2.longp);
                            aOp.operateDTDurationDTDuration(tp1.longp, tp2.longp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                    }
                    break;
                }
                case 19: {
                    tvp1.getValue((IPointable)tp1.intp);
                    switch (tid2) {
                        case 24: {
                            tvp2.getValue((IPointable)tp2.decp);
                            aOp.operateYMDurationDecimal(tp1.intp, tp2.decp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 25: {
                            aOp.operateYMDurationInteger(tp1.intp, longp2, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 22: {
                            tvp2.getValue((IPointable)tp2.floatp);
                            aOp.operateYMDurationFloat(tp1.intp, tp2.floatp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 23: {
                            aOp.operateYMDurationDouble(tp1.intp, doublep2, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 16: {
                            tvp2.getValue((IPointable)tp2.datep);
                            aOp.operateYMDurationDate(tp1.intp, tp2.datep, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 15: {
                            tvp2.getValue((IPointable)tp2.datetimep);
                            aOp.operateYMDurationDatetime(tp1.intp, tp2.datetimep, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                        case 19: {
                            tvp2.getValue((IPointable)tp2.intp);
                            aOp.operateYMDurationYMDuration(tp1.intp, tp2.intp, dOut);
                            result.set((IValueReference)abvs);
                            return;
                        }
                    }
                }
            }
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
        }
        throw new SystemException(ErrorCode.XPTY0004);
    }

    public static boolean compareTaggedValues(AbstractValueComparisonOperation aOp, TaggedValuePointable tvp1, TaggedValuePointable tvp2, DynamicContext dCtx) throws SystemException {
        TypedPointables tp1 = new TypedPointables();
        TypedPointables tp2 = new TypedPointables();
        int tid1 = FunctionHelper.getBaseTypeForComparisons(tvp1.getTag());
        int tid2 = FunctionHelper.getBaseTypeForComparisons(tvp2.getTag());
        try {
            switch (tid1) {
                case 24: {
                    tvp1.getValue((IPointable)tp1.decp);
                    switch (tid2) {
                        case 24: {
                            tvp2.getValue((IPointable)tp2.decp);
                            return aOp.operateDecimalDecimal(tp1.decp, tp2.decp);
                        }
                        case 25: {
                            tvp2.getValue((IPointable)tp2.longp);
                            return aOp.operateDecimalInteger(tp1.decp, tp2.longp);
                        }
                        case 22: {
                            tvp2.getValue((IPointable)tp2.floatp);
                            return aOp.operateDecimalFloat(tp1.decp, tp2.floatp);
                        }
                        case 23: {
                            tvp2.getValue((IPointable)tp2.doublep);
                            return aOp.operateDecimalDouble(tp1.decp, tp2.doublep);
                        }
                    }
                    break;
                }
                case 25: {
                    tvp1.getValue((IPointable)tp1.longp);
                    switch (tid2) {
                        case 24: {
                            tvp2.getValue((IPointable)tp2.decp);
                            return aOp.operateIntegerDecimal(tp1.longp, tp2.decp);
                        }
                        case 25: {
                            tvp2.getValue((IPointable)tp2.longp);
                            return aOp.operateIntegerInteger(tp1.longp, tp2.longp);
                        }
                        case 22: {
                            tvp2.getValue((IPointable)tp2.floatp);
                            return aOp.operateIntegerFloat(tp1.longp, tp2.floatp);
                        }
                        case 23: {
                            tvp2.getValue((IPointable)tp2.doublep);
                            return aOp.operateIntegerDouble(tp1.longp, tp2.doublep);
                        }
                    }
                    break;
                }
                case 22: {
                    tvp1.getValue((IPointable)tp1.floatp);
                    switch (tid2) {
                        case 24: {
                            tvp2.getValue((IPointable)tp2.decp);
                            return aOp.operateFloatDecimal(tp1.floatp, tp2.decp);
                        }
                        case 25: {
                            tvp2.getValue((IPointable)tp2.longp);
                            return aOp.operateFloatInteger(tp1.floatp, tp2.longp);
                        }
                        case 22: {
                            tvp2.getValue((IPointable)tp2.floatp);
                            return aOp.operateFloatFloat(tp1.floatp, tp2.floatp);
                        }
                        case 23: {
                            tvp2.getValue((IPointable)tp2.doublep);
                            return aOp.operateFloatDouble(tp1.floatp, tp2.doublep);
                        }
                    }
                    break;
                }
                case 23: {
                    tvp1.getValue((IPointable)tp1.doublep);
                    switch (tid2) {
                        case 24: {
                            tvp2.getValue((IPointable)tp2.decp);
                            return aOp.operateDoubleDecimal(tp1.doublep, tp2.decp);
                        }
                        case 25: {
                            tvp2.getValue((IPointable)tp2.longp);
                            return aOp.operateDoubleInteger(tp1.doublep, tp2.longp);
                        }
                        case 22: {
                            tvp2.getValue((IPointable)tp2.floatp);
                            return aOp.operateDoubleFloat(tp1.doublep, tp2.floatp);
                        }
                        case 23: {
                            tvp2.getValue((IPointable)tp2.doublep);
                            return aOp.operateDoubleDouble(tp1.doublep, tp2.doublep);
                        }
                    }
                    break;
                }
                case 43: {
                    tvp1.getValue((IPointable)tp1.boolp);
                    switch (tid2) {
                        case 43: {
                            tvp2.getValue((IPointable)tp2.boolp);
                            return aOp.operateBooleanBoolean(tp1.boolp, tp2.boolp);
                        }
                    }
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    tvp1.getValue((IPointable)tp1.utf8sp);
                    switch (tid2) {
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 46: {
                            tvp2.getValue((IPointable)tp2.utf8sp);
                            return aOp.operateStringString(tp1.utf8sp, tp2.utf8sp);
                        }
                    }
                    break;
                }
                case 16: {
                    tvp1.getValue((IPointable)tp1.datep);
                    switch (tid2) {
                        case 16: {
                            tvp2.getValue((IPointable)tp2.datep);
                            return aOp.operateDateDate(tp1.datep, tp2.datep, dCtx);
                        }
                    }
                    break;
                }
                case 15: {
                    tvp1.getValue((IPointable)tp1.datetimep);
                    switch (tid2) {
                        case 15: {
                            tvp2.getValue((IPointable)tp2.datetimep);
                            return aOp.operateDatetimeDatetime(tp1.datetimep, tp2.datetimep, dCtx);
                        }
                    }
                    break;
                }
                case 17: {
                    tvp1.getValue((IPointable)tp1.timep);
                    switch (tid2) {
                        case 17: {
                            tvp2.getValue((IPointable)tp2.timep);
                            return aOp.operateTimeTime(tp1.timep, tp2.timep, dCtx);
                        }
                    }
                    break;
                }
                case 18: {
                    tvp1.getValue((IPointable)tp1.durationp);
                    switch (tid2) {
                        case 20: {
                            tvp2.getValue((IPointable)tp2.longp);
                            return aOp.operateDurationDTDuration(tp1.durationp, tp2.longp);
                        }
                        case 18: {
                            tvp2.getValue((IPointable)tp2.durationp);
                            return aOp.operateDurationDuration(tp1.durationp, tp2.durationp);
                        }
                        case 19: {
                            tvp2.getValue((IPointable)tp2.intp);
                            return aOp.operateDurationYMDuration(tp1.durationp, tp2.intp);
                        }
                    }
                    break;
                }
                case 20: {
                    tvp1.getValue((IPointable)tp1.longp);
                    switch (tid2) {
                        case 20: {
                            tvp2.getValue((IPointable)tp2.longp);
                            return aOp.operateDTDurationDTDuration(tp1.longp, tp2.longp);
                        }
                        case 18: {
                            tvp2.getValue((IPointable)tp2.durationp);
                            return aOp.operateDTDurationDuration(tp1.longp, tp2.durationp);
                        }
                        case 19: {
                            tvp2.getValue((IPointable)tp2.intp);
                            return aOp.operateDTDurationYMDuration(tp1.longp, tp2.intp);
                        }
                    }
                    break;
                }
                case 19: {
                    tvp1.getValue((IPointable)tp1.intp);
                    switch (tid2) {
                        case 20: {
                            tvp2.getValue((IPointable)tp2.longp);
                            return aOp.operateYMDurationDTDuration(tp1.intp, tp2.longp);
                        }
                        case 18: {
                            tvp2.getValue((IPointable)tp2.durationp);
                            return aOp.operateYMDurationDuration(tp1.intp, tp2.durationp);
                        }
                        case 19: {
                            tvp2.getValue((IPointable)tp2.intp);
                            return aOp.operateYMDurationYMDuration(tp1.intp, tp2.intp);
                        }
                    }
                    break;
                }
                case 41: {
                    tvp1.getValue((IPointable)tp1.datep);
                    switch (tid2) {
                        case 41: {
                            tvp2.getValue((IPointable)tp2.datep);
                            return aOp.operateGDayGDay(tp1.datep, tp2.datep, dCtx);
                        }
                    }
                    break;
                }
                case 40: {
                    tvp1.getValue((IPointable)tp1.datep);
                    switch (tid2) {
                        case 40: {
                            tvp2.getValue((IPointable)tp2.datep);
                            return aOp.operateGMonthDayGMonthDay(tp1.datep, tp2.datep, dCtx);
                        }
                    }
                    break;
                }
                case 42: {
                    tvp1.getValue((IPointable)tp1.datep);
                    switch (tid2) {
                        case 42: {
                            tvp2.getValue((IPointable)tp2.datep);
                            return aOp.operateGMonthGMonth(tp1.datep, tp2.datep, dCtx);
                        }
                    }
                    break;
                }
                case 38: {
                    tvp1.getValue((IPointable)tp1.datep);
                    switch (tid2) {
                        case 38: {
                            tvp2.getValue((IPointable)tp2.datep);
                            return aOp.operateGYearMonthGYearMonth(tp1.datep, tp2.datep, dCtx);
                        }
                    }
                    break;
                }
                case 39: {
                    tvp1.getValue((IPointable)tp1.datep);
                    switch (tid2) {
                        case 39: {
                            tvp2.getValue((IPointable)tp2.datep);
                            return aOp.operateGYearGYear(tp1.datep, tp2.datep, dCtx);
                        }
                    }
                    break;
                }
                case 45: {
                    tvp1.getValue((IPointable)tp1.binaryp);
                    switch (tid2) {
                        case 45: {
                            tvp2.getValue((IPointable)tp2.binaryp);
                            return aOp.operateHexBinaryHexBinary(tp1.binaryp, tp2.binaryp);
                        }
                    }
                    break;
                }
                case 44: {
                    tvp1.getValue((IPointable)tp1.binaryp);
                    switch (tid2) {
                        case 44: {
                            tvp2.getValue((IPointable)tp2.binaryp);
                            return aOp.operateBase64BinaryBase64Binary(tp1.binaryp, tp2.binaryp);
                        }
                    }
                    break;
                }
                case 46: {
                    tvp1.getValue((IPointable)tp1.utf8sp);
                    switch (tid2) {
                        case 46: {
                            tvp2.getValue((IPointable)tp2.utf8sp);
                            return aOp.operateAnyURIAnyURI(tp1.utf8sp, tp2.utf8sp);
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: {
                            tvp2.getValue((IPointable)tp2.utf8sp);
                            return aOp.operateStringString(tp1.utf8sp, tp2.utf8sp);
                        }
                    }
                    break;
                }
                case 47: {
                    tvp1.getValue((IPointable)tp1.qnamep);
                    switch (tid2) {
                        case 47: {
                            tvp2.getValue((IPointable)tp2.qnamep);
                            return aOp.operateQNameQName(tp1.qnamep, tp2.qnamep);
                        }
                    }
                    break;
                }
                case 48: {
                    tvp1.getValue((IPointable)tp1.utf8sp);
                    switch (tid2) {
                        case 48: {
                            tvp2.getValue((IPointable)tp2.utf8sp);
                            return aOp.operateNotationNotation(tp1.utf8sp, tp2.utf8sp);
                        }
                    }
                }
            }
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
        }
        throw new SystemException(ErrorCode.XPTY0004);
    }

    public static int getBaseTypeForArithmetics(int tid) throws SystemException {
        if (tid >= 52) {
            throw new SystemException(ErrorCode.XPTY0004);
        }
        switch (tid) {
            case 4: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                return tid;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return 25;
            }
            case 3: {
                throw new SystemException(ErrorCode.XPTY0004);
            }
        }
        tid = BuiltinTypeRegistry.INSTANCE.getSchemaTypeById(tid).getBaseType().getTypeId();
        return tid;
    }

    public static int getBaseTypeForComparisons(int tid) throws SystemException {
        while (true) {
            switch (tid) {
                case 4: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    return tid;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    return 25;
                }
                case 3: 
                case 100: {
                    throw new SystemException(ErrorCode.XPTY0004);
                }
            }
            tid = BuiltinTypeRegistry.INSTANCE.getSchemaTypeById(tid).getBaseType().getTypeId();
        }
    }

    public static int getBaseTypeForGeneralComparisons(int tid) throws SystemException {
        while (true) {
            switch (tid) {
                case 4: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 107: {
                    return tid;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    return 23;
                }
                case 3: {
                    throw new SystemException(ErrorCode.XPTY0004);
                }
            }
            tid = BuiltinTypeRegistry.INSTANCE.getSchemaTypeById(tid).getBaseType().getTypeId();
        }
    }

    public static void getDoublePointable(TaggedValuePointable tvp, DataOutput dOut) throws SystemException, IOException {
        double value;
        TypedPointables tp = new TypedPointables();
        switch (tvp.getTag()) {
            case 24: {
                tvp.getValue((IPointable)tp.decp);
                value = tp.decp.doubleValue();
                break;
            }
            case 23: {
                tvp.getValue((IPointable)tp.doublep);
                value = tp.doublep.doubleValue();
                break;
            }
            case 22: {
                tvp.getValue((IPointable)tp.floatp);
                value = tp.floatp.doubleValue();
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 37: {
                tvp.getValue((IPointable)tp.longp);
                value = tp.longp.doubleValue();
                break;
            }
            case 29: 
            case 35: {
                tvp.getValue((IPointable)tp.intp);
                value = tp.intp.doubleValue();
                break;
            }
            case 30: 
            case 36: {
                tvp.getValue((IPointable)tp.shortp);
                value = tp.shortp.doubleValue();
                break;
            }
            case 31: {
                tvp.getValue((IPointable)tp.bytep);
                value = tp.bytep.doubleValue();
                break;
            }
            default: {
                value = 0.0;
            }
        }
        dOut.write(23);
        dOut.writeDouble(value);
    }

    public static void getIntegerPointable(TaggedValuePointable tvp, DataOutput dOut) throws SystemException, IOException {
        long value;
        TypedPointables tp = new TypedPointables();
        switch (tvp.getTag()) {
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 37: {
                tvp.getValue((IPointable)tp.longp);
                value = tp.longp.longValue();
                break;
            }
            case 29: 
            case 35: {
                tvp.getValue((IPointable)tp.intp);
                value = tp.intp.longValue();
                break;
            }
            case 30: 
            case 36: {
                tvp.getValue((IPointable)tp.shortp);
                value = tp.shortp.longValue();
                break;
            }
            case 31: {
                tvp.getValue((IPointable)tp.bytep);
                value = tp.bytep.longValue();
                break;
            }
            default: {
                value = 0L;
            }
        }
        dOut.write(25);
        dOut.writeLong(value);
    }

    public static int getLocalNodeId(TaggedValuePointable tvp1) {
        TaggedValuePointable tvp = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
        TypedPointables tp = new TypedPointables();
        int localNodeId = -1;
        if (tvp1.getTag() == 107) {
            tvp1.getValue((IPointable)tp.ntp);
            tp.ntp.getRootNode(tvp);
            switch (tvp.getTag()) {
                case 103: {
                    tvp.getValue((IPointable)tp.anp);
                    localNodeId = tp.anp.getLocalNodeId(tp.ntp);
                    break;
                }
                case 104: 
                case 105: {
                    tvp.getValue((IPointable)tp.tocnp);
                    localNodeId = tp.tocnp.getLocalNodeId(tp.ntp);
                    break;
                }
                case 101: {
                    tvp.getValue((IPointable)tp.dnp);
                    localNodeId = tp.dnp.getLocalNodeId(tp.ntp);
                    break;
                }
                case 102: {
                    tvp.getValue((IPointable)tp.enp);
                    localNodeId = tp.enp.getLocalNodeId(tp.ntp);
                    break;
                }
                case 106: {
                    tvp.getValue((IPointable)tp.pinp);
                    localNodeId = tp.pinp.getLocalNodeId(tp.ntp);
                    break;
                }
                default: {
                    localNodeId = -1;
                }
            }
        }
        return localNodeId;
    }

    public static int getNumberOfDigits(long value) {
        if (value == 0L) {
            return 0;
        }
        double nDigitsRaw = Math.log10(value);
        int nDigits = (int)nDigitsRaw;
        if (nDigits > 11 && nDigitsRaw == (double)nDigits) {
            return nDigits;
        }
        return nDigits + 1;
    }

    public static long getPowerOf10(double value, long max, long min) {
        value = Math.abs(value);
        for (long i = min; i < max; ++i) {
            if (!(Math.pow(10.0, i) > value)) continue;
            return i;
        }
        return max;
    }

    public static String getStringFromPointable(UTF8StringPointable stringp, ByteBufferInputStream bbis, DataInputStream di) throws SystemException {
        try {
            bbis.setByteBuffer(ByteBuffer.wrap(Arrays.copyOfRange(stringp.getByteArray(), stringp.getStartOffset(), stringp.getLength() + stringp.getStartOffset())), 0);
            return di.readUTF();
        }
        catch (IOException e) {
            throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
        }
    }

    public static long getTimezone(ITimezone timezonep) {
        return timezonep.getTimezoneHour() * 3600000L + timezonep.getTimezoneMinute() * 60000L;
    }

    public static boolean isDerivedFromDouble(int tid) {
        switch (tid) {
            case 22: 
            case 23: 
            case 24: {
                return true;
            }
        }
        return FunctionHelper.isDerivedFromInteger(tid);
    }

    public static boolean isDerivedFromInteger(int tid) {
        switch (tid) {
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDerivedFromString(int tid) {
        switch (tid) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumberPostive(long value) {
        return (value & Long.MIN_VALUE) == 0L;
    }

    public static void printUTF8String(UTF8StringPointable stringp) {
        System.err.println(" printUTF8String START length = " + stringp.getUTFLength());
        UTF8StringCharacterIterator charIterator = new UTF8StringCharacterIterator(stringp);
        charIterator.reset();
        char c = charIterator.next();
        while (c != '\u0000') {
            System.err.println("   parse value '" + c + "' as '" + Character.valueOf(c) + "'");
            c = charIterator.next();
        }
        System.err.println(" printUTF8String END");
    }

    public static void readInDocFromPointable(UTF8StringPointable stringp, InputSource in, ByteBufferInputStream bbis, DataInputStream di, ArrayBackedValueStorage abvs, XMLParser parser) throws HyracksDataException {
        String fName;
        try {
            fName = FunctionHelper.getStringFromPointable(stringp, bbis, di);
        }
        catch (SystemException e) {
            throw new HyracksDataException((Throwable)e);
        }
        File file = new File(fName);
        parser.parseFile(file, in, abvs);
    }

    public static boolean transformThenCompareMinMaxTaggedValues(AbstractValueComparisonOperation aOp, TaggedValuePointable tvp1, TaggedValuePointable tvp2, DynamicContext dCtx) throws SystemException {
        TaggedValuePointable tvp1new = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
        TaggedValuePointable tvp2new = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
        ArrayBackedValueStorage abvsArgument1 = new ArrayBackedValueStorage();
        DataOutput dOutArgument1 = abvsArgument1.getDataOutput();
        ArrayBackedValueStorage abvsArgument2 = new ArrayBackedValueStorage();
        DataOutput dOutArgument2 = abvsArgument2.getDataOutput();
        CastToDoubleOperation castToDouble = new CastToDoubleOperation();
        UTF8StringPointable stringp = (UTF8StringPointable)UTF8StringPointable.FACTORY.createPointable();
        UTF8StringPointable stringp2 = (UTF8StringPointable)UTF8StringPointable.FACTORY.createPointable();
        try {
            abvsArgument1.reset();
            if (tvp1.getTag() == 14) {
                tvp1.getValue((IPointable)stringp);
                castToDouble.convertUntypedAtomic(stringp, dOutArgument1);
                tvp1new.set(abvsArgument1.getByteArray(), abvsArgument1.getStartOffset(), DoublePointable.TYPE_TRAITS.getFixedLength() + 1);
            } else if (FunctionHelper.isDerivedFromInteger(tvp1.getTag())) {
                FunctionHelper.getIntegerPointable(tvp1, dOutArgument1);
                tvp1new.set(abvsArgument1.getByteArray(), abvsArgument1.getStartOffset(), LongPointable.TYPE_TRAITS.getFixedLength() + 1);
            } else {
                tvp1new = tvp1;
            }
            abvsArgument2.reset();
            if (tvp2.getTag() == 14) {
                tvp2.getValue((IPointable)stringp2);
                castToDouble.convertUntypedAtomic(stringp2, dOutArgument2);
                tvp2new.set(abvsArgument2.getByteArray(), abvsArgument2.getStartOffset(), DoublePointable.TYPE_TRAITS.getFixedLength() + 1);
            } else if (FunctionHelper.isDerivedFromInteger(tvp2.getTag())) {
                FunctionHelper.getIntegerPointable(tvp2, dOutArgument2);
                tvp2new.set(abvsArgument2.getByteArray(), abvsArgument2.getStartOffset(), LongPointable.TYPE_TRAITS.getFixedLength() + 1);
            } else {
                tvp2new = tvp2;
            }
            return FunctionHelper.compareTaggedValues(aOp, tvp1new, tvp2new, dCtx);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
        }
    }

    public static void writeChar(char c, DataOutput dOut) {
        try {
            if (c >= '\u0001' && c <= '\u007f') {
                dOut.write((byte)c);
            } else if (c > '\u07ff') {
                dOut.write((byte)(0xE0 | c >> 12 & 0xF));
                dOut.write((byte)(0x80 | c >> 6 & 0x3F));
                dOut.write((byte)(0x80 | c >> 0 & 0x3F));
            } else {
                dOut.write((byte)(0xC0 | c >> 6 & 0x1F));
                dOut.write((byte)(0x80 | c >> 0 & 0x3F));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeCharSequence(CharSequence charSequence, DataOutput dOut) {
        for (int i = 0; i < charSequence.length(); ++i) {
            FunctionHelper.writeChar(charSequence.charAt(i), dOut);
        }
    }

    public static void writeDateAsString(IDate date, DataOutput dOut) {
        FunctionHelper.writeNumberWithPadding(date.getYear(), 4, dOut);
        FunctionHelper.writeChar('-', dOut);
        FunctionHelper.writeNumberWithPadding(date.getMonth(), 2, dOut);
        FunctionHelper.writeChar('-', dOut);
        FunctionHelper.writeNumberWithPadding(date.getDay(), 2, dOut);
    }

    public static void writeNumberWithPadding(long value, int padding, DataOutput dOut) {
        if (value < 0L) {
            FunctionHelper.writeChar('-', dOut);
            value = Math.abs(value);
        }
        int nDigits = FunctionHelper.getNumberOfDigits(value);
        while (padding > nDigits) {
            FunctionHelper.writeChar('0', dOut);
            --padding;
        }
        long pow10 = (long)Math.pow(10.0, nDigits - 1);
        for (int i = nDigits - 1; i >= 0; --i) {
            FunctionHelper.writeChar((char)(48L + value / pow10), dOut);
            value %= pow10;
            pow10 /= 10L;
        }
    }

    public static void writeTimeAsString(ITime time, DataOutput dOut) {
        FunctionHelper.writeNumberWithPadding(time.getHour(), 2, dOut);
        FunctionHelper.writeChar(':', dOut);
        FunctionHelper.writeNumberWithPadding(time.getMinute(), 2, dOut);
        FunctionHelper.writeChar(':', dOut);
        FunctionHelper.writeNumberWithPadding(time.getMilliSecond() / 1000L, 2, dOut);
        if (time.getMilliSecond() % 1000L != 0L) {
            FunctionHelper.writeChar('.', dOut);
            FunctionHelper.writeNumberWithPadding(time.getMilliSecond() % 1000L, 3, dOut);
        }
    }

    public static void writeTimezoneAsString(ITimezone timezone, DataOutput dOut) {
        long timezoneHour = timezone.getTimezoneHour();
        long timezoneMinute = timezone.getTimezoneMinute();
        if (timezoneHour != 127L && timezoneMinute != 127L) {
            if (timezoneHour == 0L && timezoneMinute == 0L) {
                FunctionHelper.writeChar('Z', dOut);
            } else {
                if (timezoneHour >= 0L && timezoneMinute >= 0L) {
                    FunctionHelper.writeChar('+', dOut);
                } else {
                    FunctionHelper.writeChar('-', dOut);
                    timezoneHour = Math.abs(timezoneHour);
                    timezoneMinute = Math.abs(timezoneMinute);
                }
                FunctionHelper.writeNumberWithPadding(timezoneHour, 2, dOut);
                FunctionHelper.writeChar(':', dOut);
                FunctionHelper.writeNumberWithPadding(timezoneMinute, 2, dOut);
            }
        }
    }

    public static class TypedPointables {
        public BooleanPointable boolp = (BooleanPointable)BooleanPointable.FACTORY.createPointable();
        public BytePointable bytep = (BytePointable)BytePointable.FACTORY.createPointable();
        public DoublePointable doublep = (DoublePointable)DoublePointable.FACTORY.createPointable();
        public FloatPointable floatp = (FloatPointable)FloatPointable.FACTORY.createPointable();
        public IntegerPointable intp = (IntegerPointable)IntegerPointable.FACTORY.createPointable();
        public LongPointable longp = (LongPointable)LongPointable.FACTORY.createPointable();
        public ShortPointable shortp = (ShortPointable)ShortPointable.FACTORY.createPointable();
        public SequencePointable seqp = (SequencePointable)SequencePointable.FACTORY.createPointable();
        public UTF8StringPointable utf8sp = (UTF8StringPointable)UTF8StringPointable.FACTORY.createPointable();
        public XSBinaryPointable binaryp = (XSBinaryPointable)XSBinaryPointable.FACTORY.createPointable();
        public XSDatePointable datep = (XSDatePointable)XSDatePointable.FACTORY.createPointable();
        public XSDateTimePointable datetimep = (XSDateTimePointable)XSDateTimePointable.FACTORY.createPointable();
        public XSDecimalPointable decp = (XSDecimalPointable)XSDecimalPointable.FACTORY.createPointable();
        public XSDurationPointable durationp = (XSDurationPointable)XSDurationPointable.FACTORY.createPointable();
        public XSTimePointable timep = (XSTimePointable)XSTimePointable.FACTORY.createPointable();
        public XSQNamePointable qnamep = (XSQNamePointable)XSQNamePointable.FACTORY.createPointable();
        public AttributeNodePointable anp = (AttributeNodePointable)AttributeNodePointable.FACTORY.createPointable();
        public DocumentNodePointable dnp = (DocumentNodePointable)DocumentNodePointable.FACTORY.createPointable();
        public ElementNodePointable enp = (ElementNodePointable)ElementNodePointable.FACTORY.createPointable();
        public NodeTreePointable ntp = (NodeTreePointable)NodeTreePointable.FACTORY.createPointable();
        public PINodePointable pinp = (PINodePointable)PINodePointable.FACTORY.createPointable();
        public TextOrCommentNodePointable tocnp = (TextOrCommentNodePointable)TextOrCommentNodePointable.FACTORY.createPointable();
    }
}

