/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.util;

import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.PointablePool;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.accessors.nodes.AttributeNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.DocumentNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.ElementNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.NodeTreePointable;
import org.apache.vxquery.datamodel.accessors.nodes.PINodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.TextOrCommentNodePointable;

public class AtomizeHelper {
    AttributeNodePointable anp = (AttributeNodePointable)AttributeNodePointable.FACTORY.createPointable();
    DocumentNodePointable dnp = (DocumentNodePointable)DocumentNodePointable.FACTORY.createPointable();
    ElementNodePointable enp = (ElementNodePointable)ElementNodePointable.FACTORY.createPointable();
    NodeTreePointable ntp = (NodeTreePointable)NodeTreePointable.FACTORY.createPointable();
    PINodePointable pnp = (PINodePointable)PINodePointable.FACTORY.createPointable();
    SequencePointable sp = (SequencePointable)SequencePointable.FACTORY.createPointable();
    TextOrCommentNodePointable tcnp = (TextOrCommentNodePointable)TextOrCommentNodePointable.FACTORY.createPointable();
    ArrayBackedValueStorage tempABVS = new ArrayBackedValueStorage();
    TaggedValuePointable tempTVP = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
    VoidPointable vp = (VoidPointable)VoidPointable.FACTORY.createPointable();

    public void atomize(TaggedValuePointable tvp, PointablePool pp, IPointable result) throws IOException {
        switch (tvp.getTag()) {
            case 107: {
                tvp.getValue((IPointable)this.ntp);
                this.atomizeNode(this.ntp, pp, result);
                break;
            }
            default: {
                result.set((IValueReference)tvp);
            }
        }
    }

    public void atomizeNode(NodeTreePointable ntp, PointablePool pp, IPointable result) throws IOException {
        ntp.getRootNode(this.tempTVP);
        switch (this.tempTVP.getTag()) {
            case 103: {
                this.tempTVP.getValue((IPointable)this.anp);
                this.anp.getValue(ntp, result);
                break;
            }
            case 104: 
            case 105: {
                this.tempTVP.getValue((IPointable)this.tcnp);
                this.tcnp.getValue(ntp, (IPointable)this.vp);
                this.tempABVS.reset();
                this.tempABVS.getDataOutput().write(14);
                this.tempABVS.append((IValueReference)this.vp);
                result.set(this.tempABVS.getByteArray(), this.tempABVS.getStartOffset(), this.tempABVS.getLength());
                break;
            }
            case 101: {
                this.tempTVP.getValue((IPointable)this.dnp);
                this.dnp.getContent(ntp, this.sp);
                AtomizeHelper.buildStringConcatenation(this.sp, pp, this.tempABVS, ntp);
                result.set(this.tempABVS.getByteArray(), this.tempABVS.getStartOffset(), this.tempABVS.getLength());
                break;
            }
            case 102: {
                this.tempTVP.getValue((IPointable)this.enp);
                if (!this.enp.childrenChunkExists()) break;
                this.enp.getChildrenSequence(ntp, this.sp);
                AtomizeHelper.buildStringConcatenation(this.sp, pp, this.tempABVS, ntp);
                result.set(this.tempABVS.getByteArray(), this.tempABVS.getStartOffset(), this.tempABVS.getLength());
                break;
            }
            case 106: {
                this.tempTVP.getValue((IPointable)this.pnp);
                this.pnp.getContent(ntp, (IPointable)this.vp);
                this.tempABVS.reset();
                this.tempABVS.getDataOutput().write(14);
                this.tempABVS.append((IValueReference)this.vp);
                result.set(this.tempABVS.getByteArray(), this.tempABVS.getStartOffset(), this.tempABVS.getLength());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildConcatenationRec(SequencePointable sp, PointablePool pp, DataOutput out, NodeTreePointable ntp) throws IOException {
        TaggedValuePointable tempTVP2 = pp.takeOne(TaggedValuePointable.class);
        int nItems = sp.getEntryCount();
        block10: for (int i = 0; i < nItems; ++i) {
            sp.getEntry(i, (IPointable)tempTVP2);
            switch (tempTVP2.getTag()) {
                case 104: {
                    TextOrCommentNodePointable tcnp = pp.takeOne(TextOrCommentNodePointable.class);
                    VoidPointable vp = pp.takeOne(VoidPointable.class);
                    try {
                        tempTVP2.getValue((IPointable)tcnp);
                        tcnp.getValue(ntp, (IPointable)vp);
                        out.write(vp.getByteArray(), vp.getStartOffset() + 2, vp.getLength() - 2);
                        continue block10;
                    }
                    finally {
                        pp.giveBack(vp);
                        pp.giveBack(tcnp);
                    }
                }
                case 102: {
                    ElementNodePointable enp = pp.takeOne(ElementNodePointable.class);
                    SequencePointable sp2 = pp.takeOne(SequencePointable.class);
                    try {
                        tempTVP2.getValue((IPointable)enp);
                        if (!enp.childrenChunkExists()) continue block10;
                        enp.getChildrenSequence(ntp, sp2);
                        AtomizeHelper.buildConcatenationRec(sp2, pp, out, ntp);
                        continue block10;
                    }
                    finally {
                        pp.giveBack(sp2);
                        pp.giveBack(enp);
                    }
                }
            }
        }
        pp.giveBack(tempTVP2);
    }

    public static void buildStringConcatenation(SequencePointable sp, PointablePool pp, ArrayBackedValueStorage tempABVS, NodeTreePointable ntp) throws IOException {
        tempABVS.reset();
        DataOutput out = tempABVS.getDataOutput();
        out.write(14);
        out.write(0);
        out.write(0);
        AtomizeHelper.buildConcatenationRec(sp, pp, out, ntp);
        int utflen = tempABVS.getLength() - 3;
        byte[] bytes = tempABVS.getByteArray();
        bytes[1] = (byte)(utflen >>> 8 & 0xFF);
        bytes[2] = (byte)(utflen >>> 0 & 0xFF);
    }
}

