/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.type;

import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.accessors.nodes.NodeTreePointable;
import org.apache.vxquery.datamodel.accessors.nodes.PINodePointable;
import org.apache.vxquery.types.AnyItemType;
import org.apache.vxquery.types.AtomicType;
import org.apache.vxquery.types.AttributeType;
import org.apache.vxquery.types.BuiltinTypeRegistry;
import org.apache.vxquery.types.DocumentType;
import org.apache.vxquery.types.ElementType;
import org.apache.vxquery.types.ItemType;
import org.apache.vxquery.types.NodeKind;
import org.apache.vxquery.types.NodeType;
import org.apache.vxquery.types.ProcessingInstructionType;
import org.apache.vxquery.types.Quantifier;
import org.apache.vxquery.types.SchemaType;
import org.apache.vxquery.types.SequenceType;

public class SequenceTypeMatcher {
    private final NodeTreePointable ntp = (NodeTreePointable)NodeTreePointable.FACTORY.createPointable();
    private final TaggedValuePointable tempTVP1 = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
    private final PINodePointable pinp = (PINodePointable)PINodePointable.FACTORY.createPointable();
    private final UTF8StringPointable utf8sp = (UTF8StringPointable)UTF8StringPointable.FACTORY.createPointable();
    private final SequencePointable seqp = (SequencePointable)SequencePointable.FACTORY.createPointable();
    private final TaggedValuePointable tempTVP2 = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
    private SequenceType sequenceType;

    public boolean sequenceTypeMatch(TaggedValuePointable tvp) {
        byte tag = tvp.getTag();
        Quantifier stq = this.sequenceType.getQuantifier();
        ItemType it = this.sequenceType.getItemType();
        if (tag == 100) {
            tvp.getValue((IPointable)this.seqp);
            Quantifier vq = this.getSequenceQuantifier(this.seqp);
            if (stq.isSubQuantifier(vq)) {
                if (it instanceof AnyItemType) {
                    return true;
                }
                int n = this.seqp.getEntryCount();
                for (int i = 0; i < n; ++i) {
                    this.seqp.getEntry(i, (IPointable)this.tempTVP2);
                    if (this.itemSequenceTypeMatch(this.tempTVP2, it)) continue;
                    return false;
                }
                return true;
            }
        } else if (stq.isSubQuantifier(Quantifier.QUANT_ONE)) {
            return this.itemSequenceTypeMatch(tvp, it);
        }
        return false;
    }

    private boolean itemSequenceTypeMatch(TaggedValuePointable tvp, ItemType it) {
        byte tag = tvp.getTag();
        if (it instanceof AnyItemType) {
            return true;
        }
        if (it.isAtomicType()) {
            AtomicType ait = (AtomicType)it;
            if (BuiltinTypeRegistry.INSTANCE.isBuiltinTypeId(tag)) {
                SchemaType vType;
                for (vType = BuiltinTypeRegistry.INSTANCE.getSchemaTypeById(tag); vType != null && vType.getTypeId() != ait.getTypeId(); vType = vType.getBaseType()) {
                }
                return vType != null;
            }
        } else if (it instanceof NodeType && tag == 107) {
            NodeType nt = (NodeType)it;
            NodeKind kind = nt.getNodeKind();
            if (kind == NodeKind.ANY) {
                return true;
            }
            tvp.getValue((IPointable)this.ntp);
            this.ntp.getRootNode(this.tempTVP1);
            switch (this.tempTVP1.getTag()) {
                case 103: {
                    if (kind != NodeKind.ATTRIBUTE || !nt.equals(AttributeType.ANYATTRIBUTE)) break;
                    return true;
                }
                case 105: {
                    return kind == NodeKind.ATTRIBUTE;
                }
                case 101: {
                    if (kind != NodeKind.DOCUMENT || !nt.equals(DocumentType.ANYDOCUMENT)) break;
                    return true;
                }
                case 102: {
                    if (kind != NodeKind.ELEMENT || !nt.equals(ElementType.ANYELEMENT)) break;
                    return true;
                }
                case 106: {
                    if (kind != NodeKind.PI) break;
                    if (nt.equals(ProcessingInstructionType.ANYPI)) {
                        return true;
                    }
                    ProcessingInstructionType pit = (ProcessingInstructionType)nt;
                    this.tempTVP1.getValue((IPointable)this.pinp);
                    this.pinp.getTarget(this.ntp, (IPointable)this.utf8sp);
                    byte[] target = pit.getTarget();
                    return this.utf8sp.compareTo(target, 0, target.length) == 0;
                }
                case 104: {
                    return kind == NodeKind.TEXT;
                }
            }
        }
        return false;
    }

    public boolean matchesAllInstances(SequenceType testST) {
        Quantifier stq = this.sequenceType.getQuantifier();
        ItemType it = this.sequenceType.getItemType();
        if (stq.isSubQuantifier(testST.getQuantifier())) {
            if (it instanceof AnyItemType) {
                return true;
            }
            if (it.isAtomicType() && testST.getItemType().isAtomicType()) {
                AtomicType ait = (AtomicType)it;
                AtomicType testIT = (AtomicType)testST.getItemType();
                if (BuiltinTypeRegistry.INSTANCE.isBuiltinTypeId(testIT.getTypeId())) {
                    SchemaType vType;
                    for (vType = BuiltinTypeRegistry.INSTANCE.getSchemaTypeById(testIT.getTypeId()); vType != null && vType.getTypeId() != ait.getTypeId(); vType = vType.getBaseType()) {
                    }
                    return vType != null;
                }
            } else if (it instanceof NodeType && testST.getItemType() instanceof NodeType) {
                NodeType nt = (NodeType)it;
                NodeKind kind = nt.getNodeKind();
                NodeType testNT = (NodeType)testST.getItemType();
                NodeKind testKind = testNT.getNodeKind();
                if (kind == NodeKind.ANY || kind == testKind) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private Quantifier getSequenceQuantifier(SequencePointable seqp) {
        switch (seqp.getEntryCount()) {
            case 0: {
                return Quantifier.QUANT_ZERO;
            }
            case 1: {
                return Quantifier.QUANT_ONE;
            }
        }
        return Quantifier.QUANT_PLUS;
    }

    public void setSequenceType(SequenceType sType) {
        this.sequenceType = sType;
    }

    public String toString() {
        return "sequenceMatcher[" + this.sequenceType + "]";
    }
}

