/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.strings;

import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.vxquery.runtime.functions.strings.ICharacterIterator;

public class UTF8StringCharacterIterator
implements ICharacterIterator {
    private static final Logger LOGGER = Logger.getLogger(UTF8StringCharacterIterator.class.getName());
    private int byteOffset;
    private final UTF8StringPointable stringp;

    public UTF8StringCharacterIterator(UTF8StringPointable stringp) {
        this.stringp = stringp;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    @Override
    public char next() {
        char c = '\u0000';
        if (this.byteOffset < this.stringp.getLength()) {
            c = this.stringp.charAt(this.byteOffset);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("  UTF8StringCharacterIterator char[" + this.byteOffset + "] = " + c);
            }
            this.byteOffset = c >= '\u0001' && c <= '\u007f' ? ++this.byteOffset : (c > '\u07ff' ? (this.byteOffset += 3) : (this.byteOffset += 2));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("  END UTF8StringCharacterIterator char[" + this.byteOffset + "] = " + c);
        }
        return c;
    }

    @Override
    public void reset() {
        this.byteOffset = 2;
    }

    public void setByteOffset(int byteOffset) {
        this.byteOffset = byteOffset;
    }
}

