/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.strings;

import org.apache.vxquery.runtime.functions.strings.ICharacterIterator;

public class SubstringCharacterIterator
implements ICharacterIterator {
    private final ICharacterIterator in;
    private int start;
    private int length;
    private int charOffset;

    public SubstringCharacterIterator(ICharacterIterator in) {
        this.in = in;
    }

    public void setBounds(int start, int length) {
        this.start = start;
        this.length = length;
    }

    @Override
    public char next() {
        char c = this.in.next();
        if (c == '\u0000') {
            return c;
        }
        if (this.charOffset < this.start) {
            ++this.charOffset;
            return this.next();
        }
        if (this.charOffset < this.start + this.length || this.length == Integer.MAX_VALUE) {
            ++this.charOffset;
            return c;
        }
        return '\u0000';
    }

    @Override
    public void reset() {
        this.in.reset();
        this.charOffset = 1;
    }
}

