/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.strings;

import org.apache.vxquery.runtime.functions.strings.ICharacterIterator;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;

public class SubstringAfterCharacterIterator
implements ICharacterIterator {
    private ICharacterIterator searchIterator;
    private final UTF8StringCharacterIterator stringIterator;
    private boolean found = false;

    public SubstringAfterCharacterIterator(UTF8StringCharacterIterator stringIterator) {
        this.stringIterator = stringIterator;
    }

    public void setSearch(ICharacterIterator searchIterator) {
        this.searchIterator = searchIterator;
    }

    @Override
    public char next() {
        char c1 = '\u0000';
        if (!this.found) {
            this.searchIterator.reset();
            int currentByteOffset = 0;
            boolean firstPass = true;
            while (true) {
                c1 = this.stringIterator.next();
                char c2 = this.searchIterator.next();
                if (firstPass) {
                    currentByteOffset = this.stringIterator.getByteOffset();
                    firstPass = false;
                }
                if (c2 == '\u0000') {
                    this.found = true;
                    break;
                }
                if (c1 == '\u0000') {
                    return '\u0000';
                }
                if (c1 == c2) continue;
                this.searchIterator.reset();
                this.stringIterator.setByteOffset(currentByteOffset);
                firstPass = true;
            }
        }
        if (c1 != '\u0000') {
            return c1;
        }
        return this.stringIterator.next();
    }

    @Override
    public void reset() {
        this.stringIterator.reset();
    }
}

