/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.strings;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.strings.AbstractCharacterIteratorCopyingEvaluator;
import org.apache.vxquery.runtime.functions.strings.AbstractCharacterIteratorCopyingEvaluatorFactory;
import org.apache.vxquery.runtime.functions.strings.SubstringCharacterIterator;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;
import org.apache.vxquery.runtime.functions.util.FunctionHelper;

public class FnSubstringEvaluatorFactory
extends AbstractCharacterIteratorCopyingEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public FnSubstringEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    protected static int getIntParameter(TaggedValuePointable tvp, DoublePointable doublep, LongPointable longp) throws SystemException {
        switch (tvp.getTag()) {
            case 25: {
                tvp.getValue((IPointable)longp);
                return longp.intValue();
            }
            case 23: {
                tvp.getValue((IPointable)doublep);
                return doublep.intValue();
            }
        }
        throw new SystemException(ErrorCode.FORG0006);
    }

    @Override
    protected IScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        final UTF8StringPointable stringp = (UTF8StringPointable)UTF8StringPointable.FACTORY.createPointable();
        final DoublePointable doublep = (DoublePointable)DoublePointable.FACTORY.createPointable();
        final LongPointable longp = (LongPointable)LongPointable.FACTORY.createPointable();
        final ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        final SubstringCharacterIterator charIterator = new SubstringCharacterIterator(new UTF8StringCharacterIterator(stringp));
        final SequencePointable seqp = (SequencePointable)SequencePointable.FACTORY.createPointable();
        final TaggedValuePointable tvp = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
        return new AbstractCharacterIteratorCopyingEvaluator(args, charIterator){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected void preEvaluate(TaggedValuePointable[] args) throws SystemException {
                int startingLocation = 1;
                int length = Integer.MAX_VALUE;
                abvs.reset();
                charIterator.reset();
                TaggedValuePointable tvp1 = args[0];
                if (tvp1.getTag() == 100) {
                    tvp1.getValue((IPointable)seqp);
                    if (seqp.getEntryCount() != 0) throw new SystemException(ErrorCode.FORG0006);
                    XDMConstants.setEmptyString((IPointable)tvp);
                    tvp.getValue((IPointable)stringp);
                } else {
                    if (!FunctionHelper.isDerivedFromString(tvp1.getTag())) {
                        throw new SystemException(ErrorCode.FORG0006);
                    }
                    tvp1.getValue((IPointable)stringp);
                }
                startingLocation = FnSubstringEvaluatorFactory.getIntParameter(args[1], doublep, longp);
                if (args.length > 2) {
                    length = FnSubstringEvaluatorFactory.getIntParameter(args[2], doublep, longp);
                }
                charIterator.setBounds(startingLocation, length);
            }
        };
    }
}

