/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.strings;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluatorFactory;
import org.apache.vxquery.runtime.functions.cast.CastToStringOperation;
import org.apache.vxquery.runtime.functions.util.FunctionHelper;

public class FnStringScalarEvaluatorFactory
extends AbstractTaggedValueArgumentScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public FnStringScalarEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        final ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        final DataOutput dOut = abvs.getDataOutput();
        final CastToStringOperation castToString = new CastToStringOperation();
        final FunctionHelper.TypedPointables tp = new FunctionHelper.TypedPointables();
        return new AbstractTaggedValueArgumentScalarEvaluator(args){

            @Override
            protected void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
                TaggedValuePointable tvp1 = args[0];
                try {
                    abvs.reset();
                    switch (tvp1.getTag()) {
                        case 46: {
                            tvp1.getValue((IPointable)tp.utf8sp);
                            castToString.convertAnyURI(tp.utf8sp, dOut);
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: {
                            tvp1.getValue((IPointable)tp.utf8sp);
                            castToString.convertString(tp.utf8sp, dOut);
                            break;
                        }
                        case 14: {
                            tvp1.getValue((IPointable)tp.utf8sp);
                            castToString.convertUntypedAtomic(tp.utf8sp, dOut);
                            break;
                        }
                        case 44: {
                            tvp1.getValue((IPointable)tp.binaryp);
                            castToString.convertBase64Binary(tp.binaryp, dOut);
                            break;
                        }
                        case 45: {
                            tvp1.getValue((IPointable)tp.binaryp);
                            castToString.convertHexBinary(tp.binaryp, dOut);
                            break;
                        }
                        case 43: {
                            tvp1.getValue((IPointable)tp.boolp);
                            castToString.convertBoolean(tp.boolp, dOut);
                            break;
                        }
                        case 15: {
                            tvp1.getValue((IPointable)tp.datetimep);
                            castToString.convertDatetime(tp.datetimep, dOut);
                            break;
                        }
                        case 20: {
                            tvp1.getValue((IPointable)tp.longp);
                            castToString.convertDTDuration(tp.longp, dOut);
                            break;
                        }
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 37: {
                            tvp1.getValue((IPointable)tp.longp);
                            castToString.convertInteger(tp.longp, dOut);
                            break;
                        }
                        case 18: {
                            tvp1.getValue((IPointable)tp.durationp);
                            castToString.convertDuration(tp.durationp, dOut);
                            break;
                        }
                        case 16: {
                            tvp1.getValue((IPointable)tp.datep);
                            castToString.convertDate(tp.datep, dOut);
                            break;
                        }
                        case 41: {
                            tvp1.getValue((IPointable)tp.datep);
                            castToString.convertGDay(tp.datep, dOut);
                            break;
                        }
                        case 40: {
                            tvp1.getValue((IPointable)tp.datep);
                            castToString.convertGMonthDay(tp.datep, dOut);
                            break;
                        }
                        case 42: {
                            tvp1.getValue((IPointable)tp.datep);
                            castToString.convertGMonth(tp.datep, dOut);
                            break;
                        }
                        case 38: {
                            tvp1.getValue((IPointable)tp.datep);
                            castToString.convertGYearMonth(tp.datep, dOut);
                            break;
                        }
                        case 39: {
                            tvp1.getValue((IPointable)tp.datep);
                            castToString.convertGYear(tp.datep, dOut);
                            break;
                        }
                        case 47: {
                            tvp1.getValue((IPointable)tp.qnamep);
                            castToString.convertQName(tp.qnamep, dOut);
                            break;
                        }
                        case 17: {
                            tvp1.getValue((IPointable)tp.timep);
                            castToString.convertTime(tp.timep, dOut);
                            break;
                        }
                        case 19: {
                            tvp1.getValue((IPointable)tp.intp);
                            castToString.convertYMDuration(tp.intp, dOut);
                            break;
                        }
                        case 29: 
                        case 35: {
                            tvp1.getValue((IPointable)tp.intp);
                            castToString.convertInt(tp.intp, dOut);
                            break;
                        }
                        case 24: {
                            tvp1.getValue((IPointable)tp.decp);
                            castToString.convertDecimal(tp.decp, dOut);
                            break;
                        }
                        case 23: {
                            tvp1.getValue((IPointable)tp.doublep);
                            castToString.convertDouble(tp.doublep, dOut);
                            break;
                        }
                        case 22: {
                            tvp1.getValue((IPointable)tp.floatp);
                            castToString.convertFloat(tp.floatp, dOut);
                            break;
                        }
                        case 30: 
                        case 36: {
                            tvp1.getValue((IPointable)tp.shortp);
                            castToString.convertShort(tp.shortp, dOut);
                            break;
                        }
                        case 31: {
                            tvp1.getValue((IPointable)tp.bytep);
                            castToString.convertByte(tp.bytep, dOut);
                            break;
                        }
                        case 100: {
                            tvp1.getValue((IPointable)tp.seqp);
                            if (tp.seqp.getEntryCount() == 0) {
                                XDMConstants.setEmptyString(result);
                                return;
                            }
                        }
                        default: {
                            throw new SystemException(ErrorCode.XPDY0002);
                        }
                    }
                    result.set((IValueReference)abvs);
                }
                catch (IOException e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
            }
        };
    }
}

