/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.strings;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluatorFactory;
import org.apache.vxquery.runtime.functions.util.FunctionHelper;

public class FnStringJoinEvaluatorFactory
extends AbstractTaggedValueArgumentScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public FnStringJoinEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        final TaggedValuePointable tvp = new TaggedValuePointable();
        final UTF8StringPointable stringp1 = (UTF8StringPointable)UTF8StringPointable.FACTORY.createPointable();
        final UTF8StringPointable stringp2 = (UTF8StringPointable)UTF8StringPointable.FACTORY.createPointable();
        final ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        final SequencePointable seq = (SequencePointable)SequencePointable.FACTORY.createPointable();
        return new AbstractTaggedValueArgumentScalarEvaluator(args){

            @Override
            protected void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
                abvs.reset();
                TaggedValuePointable tvp1 = args[0];
                TaggedValuePointable tvp2 = args[1];
                if (!FunctionHelper.isDerivedFromString(tvp2.getTag())) {
                    throw new SystemException(ErrorCode.FORG0006);
                }
                if (FunctionHelper.isDerivedFromString(tvp1.getTag())) {
                    try {
                        DataOutput out = abvs.getDataOutput();
                        tvp1.getValue((IPointable)stringp1);
                        out.write(4);
                        out.write(stringp1.getByteArray(), stringp1.getStartOffset(), stringp1.getLength());
                        result.set(abvs.getByteArray(), abvs.getStartOffset(), abvs.getLength());
                    }
                    catch (IOException e) {
                        throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                    }
                    return;
                }
                if (tvp1.getTag() != 100) {
                    throw new SystemException(ErrorCode.FORG0006);
                }
                tvp1.getValue((IPointable)seq);
                tvp2.getValue((IPointable)stringp2);
                try {
                    DataOutput out = abvs.getDataOutput();
                    out.write(4);
                    out.write(0);
                    out.write(0);
                    int seqLen = seq.getEntryCount();
                    if (seqLen != 0) {
                        for (int j = 0; j < seqLen; ++j) {
                            if (j > 0) {
                                out.write(stringp2.getByteArray(), stringp2.getStartOffset() + 2, stringp2.getUTFLength());
                            }
                            seq.getEntry(j, (IPointable)tvp);
                            if (!FunctionHelper.isDerivedFromString(tvp.getTag())) {
                                throw new SystemException(ErrorCode.FORG0006);
                            }
                            tvp.getValue((IPointable)stringp1);
                            out.write(stringp1.getByteArray(), stringp1.getStartOffset() + 2, stringp1.getUTFLength());
                        }
                        abvs.getByteArray()[1] = (byte)(abvs.getLength() - 3 >>> 8 & 0xFF);
                        abvs.getByteArray()[2] = (byte)(abvs.getLength() - 3 >>> 0 & 0xFF);
                    }
                    result.set(abvs.getByteArray(), abvs.getStartOffset(), abvs.getLength());
                }
                catch (IOException e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
            }
        };
    }
}

