/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.strings;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluatorFactory;
import org.apache.vxquery.runtime.functions.strings.ICharacterIterator;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;
import org.apache.vxquery.runtime.functions.util.FunctionHelper;

public class FnContainsEvaluatorFactory
extends AbstractTaggedValueArgumentScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public FnContainsEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        final UTF8StringPointable stringp1 = (UTF8StringPointable)UTF8StringPointable.FACTORY.createPointable();
        final UTF8StringPointable stringp2 = (UTF8StringPointable)UTF8StringPointable.FACTORY.createPointable();
        final UTF8StringPointable stringp3 = (UTF8StringPointable)UTF8StringPointable.FACTORY.createPointable();
        final UTF8StringCharacterIterator charIterator1 = new UTF8StringCharacterIterator(stringp1);
        final UTF8StringCharacterIterator charIterator2 = new UTF8StringCharacterIterator(stringp2);
        final SequencePointable seqp = (SequencePointable)SequencePointable.FACTORY.createPointable();
        return new AbstractTaggedValueArgumentScalarEvaluator(args){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
                byte[] booleanResult = new byte[]{43, 0};
                TaggedValuePointable tvp1 = args[0];
                TaggedValuePointable tvp2 = args[1];
                if (tvp1.getTag() == 100) {
                    tvp1.getValue((IPointable)seqp);
                    if (seqp.getEntryCount() != 0) throw new SystemException(ErrorCode.FORG0006);
                    XDMConstants.setEmptyString((IPointable)stringp1);
                } else {
                    if (!FunctionHelper.isDerivedFromString(tvp1.getTag())) {
                        throw new SystemException(ErrorCode.FORG0006);
                    }
                    tvp1.getValue((IPointable)stringp1);
                }
                if (tvp2.getTag() == 100) {
                    tvp2.getValue((IPointable)seqp);
                    if (seqp.getEntryCount() != 0) throw new SystemException(ErrorCode.FORG0006);
                    XDMConstants.setEmptyString((IPointable)stringp2);
                } else {
                    if (!FunctionHelper.isDerivedFromString(tvp2.getTag())) {
                        throw new SystemException(ErrorCode.FORG0006);
                    }
                    tvp2.getValue((IPointable)stringp2);
                }
                charIterator1.reset();
                charIterator2.reset();
                if (args.length > 2) {
                    TaggedValuePointable tvp3 = args[2];
                    if (!FunctionHelper.isDerivedFromString(tvp3.getTag())) {
                        throw new SystemException(ErrorCode.FORG0006);
                    }
                    tvp3.getValue((IPointable)stringp3);
                }
                if (stringp1.getLength() > 2 && stringp2.getLength() > 2) {
                    char c1;
                    char c2 = charIterator2.next();
                    do {
                        if ((c1 = charIterator1.next()) != c2) continue;
                        int offset1 = charIterator1.getByteOffset();
                        if (this.checkSubString(charIterator1, charIterator2)) {
                            booleanResult[1] = 1;
                            break;
                        }
                        charIterator2.reset();
                        c2 = charIterator2.next();
                        charIterator1.setByteOffset(offset1);
                    } while (c1 != '\u0000');
                } else if (stringp2.getLength() == 2) {
                    booleanResult[1] = 1;
                }
                result.set(booleanResult, 0, 2);
            }

            private boolean checkSubString(ICharacterIterator charIterator12, ICharacterIterator charIterator22) {
                char c2;
                char c1;
                do {
                    c1 = charIterator12.next();
                    c2 = charIterator22.next();
                    if (c2 != '\u0000') continue;
                    return true;
                } while (c1 == c2);
                return false;
            }
        };
    }
}

