/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.strings;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluatorFactory;
import org.apache.vxquery.runtime.functions.cast.CastToStringOperation;
import org.apache.vxquery.runtime.functions.util.FunctionHelper;

public class FnConcatEvaluatorFactory
extends AbstractTaggedValueArgumentScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public FnConcatEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        final UTF8StringPointable stringp = (UTF8StringPointable)UTF8StringPointable.FACTORY.createPointable();
        final ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        final ArrayBackedValueStorage abvsInner = new ArrayBackedValueStorage();
        final DataOutput dOutInner = abvsInner.getDataOutput();
        final CastToStringOperation castToString = new CastToStringOperation();
        final FunctionHelper.TypedPointables tp = new FunctionHelper.TypedPointables();
        return new AbstractTaggedValueArgumentScalarEvaluator(args){

            @Override
            protected void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
                abvs.reset();
                try {
                    DataOutput out = abvs.getDataOutput();
                    out.write(4);
                    out.write(255);
                    out.write(255);
                    for (int i = 0; i < args.length; ++i) {
                        TaggedValuePointable tvp = args[i];
                        if (!FunctionHelper.isDerivedFromString(tvp.getTag())) {
                            try {
                                abvsInner.reset();
                                switch (tvp.getTag()) {
                                    case 46: {
                                        tvp.getValue((IPointable)tp.utf8sp);
                                        castToString.convertAnyURI(tp.utf8sp, dOutInner);
                                        break;
                                    }
                                    case 14: {
                                        tvp.getValue((IPointable)tp.utf8sp);
                                        castToString.convertUntypedAtomic(tp.utf8sp, dOutInner);
                                        break;
                                    }
                                    case 44: {
                                        tvp.getValue((IPointable)tp.binaryp);
                                        castToString.convertBase64Binary(tp.binaryp, dOutInner);
                                        break;
                                    }
                                    case 45: {
                                        tvp.getValue((IPointable)tp.binaryp);
                                        castToString.convertHexBinary(tp.binaryp, dOutInner);
                                        break;
                                    }
                                    case 43: {
                                        tvp.getValue((IPointable)tp.boolp);
                                        castToString.convertBoolean(tp.boolp, dOutInner);
                                        break;
                                    }
                                    case 15: {
                                        tvp.getValue((IPointable)tp.datetimep);
                                        castToString.convertDatetime(tp.datetimep, dOutInner);
                                        break;
                                    }
                                    case 20: {
                                        tvp.getValue((IPointable)tp.longp);
                                        castToString.convertDTDuration(tp.longp, dOutInner);
                                        break;
                                    }
                                    case 25: 
                                    case 26: 
                                    case 27: 
                                    case 28: 
                                    case 32: 
                                    case 33: 
                                    case 34: 
                                    case 37: {
                                        tvp.getValue((IPointable)tp.longp);
                                        castToString.convertInteger(tp.longp, dOutInner);
                                        break;
                                    }
                                    case 18: {
                                        tvp.getValue((IPointable)tp.durationp);
                                        castToString.convertDuration(tp.durationp, dOutInner);
                                        break;
                                    }
                                    case 16: {
                                        tvp.getValue((IPointable)tp.datep);
                                        castToString.convertDate(tp.datep, dOutInner);
                                        break;
                                    }
                                    case 41: {
                                        tvp.getValue((IPointable)tp.datep);
                                        castToString.convertGDay(tp.datep, dOutInner);
                                        break;
                                    }
                                    case 40: {
                                        tvp.getValue((IPointable)tp.datep);
                                        castToString.convertGMonthDay(tp.datep, dOutInner);
                                        break;
                                    }
                                    case 42: {
                                        tvp.getValue((IPointable)tp.datep);
                                        castToString.convertGMonth(tp.datep, dOutInner);
                                        break;
                                    }
                                    case 38: {
                                        tvp.getValue((IPointable)tp.datep);
                                        castToString.convertGYearMonth(tp.datep, dOutInner);
                                        break;
                                    }
                                    case 39: {
                                        tvp.getValue((IPointable)tp.datep);
                                        castToString.convertGYear(tp.datep, dOutInner);
                                        break;
                                    }
                                    case 47: {
                                        tvp.getValue((IPointable)tp.qnamep);
                                        castToString.convertQName(tp.qnamep, dOutInner);
                                        break;
                                    }
                                    case 17: {
                                        tvp.getValue((IPointable)tp.timep);
                                        castToString.convertTime(tp.timep, dOutInner);
                                        break;
                                    }
                                    case 19: {
                                        tvp.getValue((IPointable)tp.intp);
                                        castToString.convertYMDuration(tp.intp, dOutInner);
                                        break;
                                    }
                                    case 29: 
                                    case 35: {
                                        tvp.getValue((IPointable)tp.intp);
                                        castToString.convertInt(tp.intp, dOutInner);
                                        break;
                                    }
                                    case 24: {
                                        tvp.getValue((IPointable)tp.decp);
                                        castToString.convertDecimal(tp.decp, dOutInner);
                                        break;
                                    }
                                    case 23: {
                                        tvp.getValue((IPointable)tp.doublep);
                                        castToString.convertDouble(tp.doublep, dOutInner);
                                        break;
                                    }
                                    case 22: {
                                        tvp.getValue((IPointable)tp.floatp);
                                        castToString.convertFloat(tp.floatp, dOutInner);
                                        break;
                                    }
                                    case 30: 
                                    case 36: {
                                        tvp.getValue((IPointable)tp.shortp);
                                        castToString.convertShort(tp.shortp, dOutInner);
                                        break;
                                    }
                                    case 31: {
                                        tvp.getValue((IPointable)tp.bytep);
                                        castToString.convertByte(tp.bytep, dOutInner);
                                        break;
                                    }
                                    case 100: {
                                        tvp.getValue((IPointable)tp.seqp);
                                        if (tp.seqp.getEntryCount() == 0) {
                                            dOutInner.write(4);
                                            dOutInner.write(0);
                                            dOutInner.write(0);
                                            break;
                                        }
                                    }
                                    default: {
                                        throw new SystemException(ErrorCode.XPTY0004);
                                    }
                                }
                                stringp.set(abvsInner.getByteArray(), abvsInner.getStartOffset() + 1, abvsInner.getLength() - 1);
                            }
                            catch (IOException e) {
                                throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                            }
                        } else {
                            tvp.getValue((IPointable)stringp);
                        }
                        if (stringp.getUTFLength() <= 0) continue;
                        out.write(stringp.getByteArray(), stringp.getStartOffset() + 2, stringp.getUTFLength());
                    }
                    abvs.getByteArray()[1] = (byte)(abvs.getLength() - 3 >>> 8 & 0xFF);
                    abvs.getByteArray()[2] = (byte)(abvs.getLength() - 3 >>> 0 & 0xFF);
                    result.set(abvs.getByteArray(), abvs.getStartOffset(), abvs.getLength());
                }
                catch (IOException e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
            }
        };
    }
}

