/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.strings;

import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;
import org.apache.vxquery.runtime.functions.strings.ICharacterIterator;
import org.apache.vxquery.runtime.functions.util.FunctionHelper;

public abstract class AbstractCharacterIteratorCopyingEvaluator
extends AbstractTaggedValueArgumentScalarEvaluator {
    private final ICharacterIterator charIterator;
    private final ArrayBackedValueStorage abvs;

    public AbstractCharacterIteratorCopyingEvaluator(IScalarEvaluator[] args, ICharacterIterator charIterator) {
        super(args);
        this.charIterator = charIterator;
        this.abvs = new ArrayBackedValueStorage();
    }

    @Override
    public final void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
        this.preEvaluate(args);
        this.abvs.reset();
        this.charIterator.reset();
        try {
            char c;
            DataOutput out = this.abvs.getDataOutput();
            out.write(4);
            out.write(0);
            out.write(0);
            while ('\u0000' != (c = this.charIterator.next())) {
                FunctionHelper.writeChar(c, out);
            }
            this.abvs.getByteArray()[1] = (byte)(this.abvs.getLength() - 3 >>> 8 & 0xFF);
            this.abvs.getByteArray()[2] = (byte)(this.abvs.getLength() - 3 >>> 0 & 0xFF);
            result.set(this.abvs.getByteArray(), this.abvs.getStartOffset(), this.abvs.getLength());
        }
        catch (IOException e) {
            throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
        }
    }

    protected abstract void preEvaluate(TaggedValuePointable[] var1) throws SystemException;
}

