/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.step;

import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.accessors.atomic.CodedQNamePointable;
import org.apache.vxquery.datamodel.accessors.nodes.AttributeNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.ElementNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.NodeTreePointable;
import org.apache.vxquery.types.AttributeType;
import org.apache.vxquery.types.ElementType;
import org.apache.vxquery.types.NameTest;
import org.apache.vxquery.types.NodeType;
import org.apache.vxquery.types.SequenceType;

public class NodeTestFilter {
    public static INodeFilter getNodeTestFilter(SequenceType sType) {
        INodeFilter filter;
        NodeType nodeType = (NodeType)sType.getItemType();
        switch (nodeType.getNodeKind()) {
            case ATTRIBUTE: {
                AttributeType aType = (AttributeType)nodeType;
                NameTest nameTest = aType.getNameTest();
                byte[] uri = nameTest.getUri();
                byte[] localName = nameTest.getLocalName();
                final UTF8StringPointable urip = (UTF8StringPointable)(uri == null ? null : UTF8StringPointable.FACTORY.createPointable());
                final UTF8StringPointable localp = (UTF8StringPointable)(localName == null ? null : UTF8StringPointable.FACTORY.createPointable());
                if (uri != null) {
                    urip.set(uri, 0, uri.length);
                }
                if (localName != null) {
                    localp.set(localName, 0, localName.length);
                }
                final IPointable temp = VoidPointable.FACTORY.createPointable();
                final AttributeNodePointable anp = (AttributeNodePointable)AttributeNodePointable.FACTORY.createPointable();
                final CodedQNamePointable cqp = (CodedQNamePointable)CodedQNamePointable.FACTORY.createPointable();
                filter = new INodeFilter(){

                    @Override
                    public boolean accept(NodeTreePointable ntp, TaggedValuePointable tvp) {
                        if (tvp.getTag() != 103) {
                            return false;
                        }
                        tvp.getValue((IPointable)anp);
                        anp.getName(cqp);
                        if (urip != null) {
                            ntp.getString(cqp.getNamespaceCode(), temp);
                            if (urip.compareTo(temp) != 0) {
                                return false;
                            }
                        }
                        if (localp != null) {
                            ntp.getString(cqp.getLocalCode(), temp);
                            if (localp.compareTo(temp) != 0) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case COMMENT: {
                filter = new INodeFilter(){

                    @Override
                    public boolean accept(NodeTreePointable ntp, TaggedValuePointable tvp) {
                        return tvp.getTag() == 105;
                    }
                };
                break;
            }
            case DOCUMENT: {
                filter = new INodeFilter(){

                    @Override
                    public boolean accept(NodeTreePointable ntp, TaggedValuePointable tvp) {
                        return tvp.getTag() == 101;
                    }
                };
                break;
            }
            case ELEMENT: {
                ElementType eType = (ElementType)nodeType;
                NameTest nameTest = eType.getNameTest();
                byte[] uri = nameTest.getUri();
                byte[] localName = nameTest.getLocalName();
                final UTF8StringPointable urip = (UTF8StringPointable)(uri == null ? null : UTF8StringPointable.FACTORY.createPointable());
                final UTF8StringPointable localp = (UTF8StringPointable)(localName == null ? null : UTF8StringPointable.FACTORY.createPointable());
                if (uri != null) {
                    urip.set(uri, 0, uri.length);
                }
                if (localName != null) {
                    localp.set(localName, 0, localName.length);
                }
                final IPointable temp = VoidPointable.FACTORY.createPointable();
                final ElementNodePointable enp = (ElementNodePointable)ElementNodePointable.FACTORY.createPointable();
                final CodedQNamePointable cqp = (CodedQNamePointable)CodedQNamePointable.FACTORY.createPointable();
                filter = new INodeFilter(){

                    @Override
                    public boolean accept(NodeTreePointable ntp, TaggedValuePointable tvp) {
                        if (tvp.getTag() != 102) {
                            return false;
                        }
                        tvp.getValue((IPointable)enp);
                        enp.getName(cqp);
                        if (urip != null) {
                            ntp.getString(cqp.getNamespaceCode(), temp);
                            if (urip.compareTo(temp) != 0) {
                                return false;
                            }
                        }
                        if (localp != null) {
                            ntp.getString(cqp.getLocalCode(), temp);
                            if (localp.compareTo(temp) != 0) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case PI: {
                filter = new INodeFilter(){

                    @Override
                    public boolean accept(NodeTreePointable ntp, TaggedValuePointable tvp) {
                        return tvp.getTag() == 106;
                    }
                };
                break;
            }
            case TEXT: {
                filter = new INodeFilter(){

                    @Override
                    public boolean accept(NodeTreePointable ntp, TaggedValuePointable tvp) {
                        return tvp.getTag() == 104;
                    }
                };
                break;
            }
            default: {
                filter = new INodeFilter(){

                    @Override
                    public boolean accept(NodeTreePointable ntp, TaggedValuePointable tvp) {
                        return true;
                    }
                };
            }
        }
        return filter;
    }

    public static interface INodeFilter {
        public boolean accept(NodeTreePointable var1, TaggedValuePointable var2);
    }
}

