/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.step;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.PointablePool;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.step.AbstractChildPathStep;
import org.apache.vxquery.runtime.functions.step.NodeTestFilter;
import org.apache.vxquery.types.SequenceType;

public class ChildPathStepUnnesting
extends AbstractChildPathStep {
    private int indexSeqArgs;
    private int seqArgsLength;
    private int indexSequence;
    private final IntegerPointable ip = (IntegerPointable)IntegerPointable.FACTORY.createPointable();
    private final SequencePointable seqItem = (SequencePointable)SequencePointable.FACTORY.createPointable();
    private final SequencePointable seqNtp = (SequencePointable)SequencePointable.FACTORY.createPointable();
    private final TaggedValuePointable tvpItem = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
    private final TaggedValuePointable tvpNtp = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
    private final TaggedValuePointable tvpStep = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
    NodeTestFilter.INodeFilter filter;

    public ChildPathStepUnnesting(IHyracksTaskContext ctx, PointablePool pp) {
        super(ctx, pp);
    }

    protected void init(TaggedValuePointable[] args) throws SystemException {
        this.indexSeqArgs = 0;
        this.indexSequence = 0;
        if (args[1].getTag() != 29) {
            throw new IllegalArgumentException("Expected int value tag, got: " + args[1].getTag());
        }
        args[1].getValue((IPointable)this.ip);
        SequenceType sType = this.dCtx.getStaticContext().lookupSequenceType(this.ip.getInteger());
        this.filter = NodeTestFilter.getNodeTestFilter(sType);
        if (args[0].getTag() == 100) {
            args[0].getValue((IPointable)this.seqNtp);
            this.seqArgsLength = this.seqNtp.getEntryCount();
        } else if (args[0].getTag() == 107) {
            args[0].getValue((IPointable)this.ntp);
            this.seqArgsLength = -1;
        } else {
            throw new SystemException(ErrorCode.SYSE0001);
        }
    }

    public boolean step(IPointable result) throws AlgebricksException {
        if (this.seqArgsLength > 0) {
            while (this.indexSeqArgs < this.seqArgsLength) {
                this.seqNtp.getEntry(this.indexSeqArgs, (IPointable)this.tvpNtp);
                if (this.tvpNtp.getTag() != 107) {
                    String description = (Object)((Object)ErrorCode.SYSE0001) + ": " + ErrorCode.SYSE0001.getDescription();
                    throw new AlgebricksException(description);
                }
                this.tvpNtp.getValue((IPointable)this.ntp);
                this.ntp.getRootNode(this.tvpStep);
                if (!this.stepNodeTree(this.tvpStep, 0, result)) continue;
                return true;
            }
        } else {
            this.ntp.getRootNode(this.tvpStep);
            if (this.stepNodeTree(this.tvpStep, 0, result)) {
                return true;
            }
        }
        return false;
    }

    protected boolean stepNodeTree(TaggedValuePointable tvpInput, int level, IPointable result) throws AlgebricksException {
        this.getSequence(tvpInput, this.seqItem);
        int seqLength = this.seqItem.getEntryCount();
        while (this.indexSequence < seqLength) {
            this.seqItem.getEntry(this.indexSequence, (IPointable)this.tvpItem);
            if (this.filter.accept(this.ntp, this.tvpItem)) {
                try {
                    this.setNodeToResult(this.tvpItem, result);
                    ++this.indexSequence;
                    return true;
                }
                catch (IOException e) {
                    String description = (Object)((Object)ErrorCode.SYSE0001) + ": " + ErrorCode.SYSE0001.getDescription();
                    throw new AlgebricksException(description);
                }
            }
            ++this.indexSequence;
        }
        this.indexSequence = 0;
        return false;
    }
}

