/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.step;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IMutableValueStorage;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.vxquery.datamodel.accessors.PointablePool;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.accessors.nodes.DocumentNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.ElementNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.NodeTreePointable;
import org.apache.vxquery.datamodel.builders.nodes.NodeSubTreeBuilder;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.step.AbstractChildPathStep;
import org.apache.vxquery.runtime.functions.step.NodeTestFilter;
import org.apache.vxquery.types.SequenceType;

public class ChildPathStepOperatorDescriptor
extends AbstractChildPathStep {
    private List<NodeTestFilter.INodeFilter> filter = new ArrayList<NodeTestFilter.INodeFilter>();
    private int[] indexSequence;
    private final ArrayBackedValueStorage nodeAbvs = new ArrayBackedValueStorage();
    protected final NodeTreePointable ntp = (NodeTreePointable)NodeTreePointable.FACTORY.createPointable();
    private final TaggedValuePointable tvpItem = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
    private final DocumentNodePointable dnp = (DocumentNodePointable)DocumentNodePointable.FACTORY.createPointable();
    private final ElementNodePointable enp = (ElementNodePointable)ElementNodePointable.FACTORY.createPointable();
    private final TaggedValuePointable tvpStep = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
    private final NodeSubTreeBuilder nstb = new NodeSubTreeBuilder();

    public ChildPathStepOperatorDescriptor(IHyracksTaskContext ctx, PointablePool pp) {
        super(ctx, pp);
    }

    @Override
    protected void getSequence(TaggedValuePointable tvp, SequencePointable seqp) {
        switch (tvp.getTag()) {
            case 101: {
                tvp.getValue((IPointable)this.dnp);
                this.dnp.getContent(this.ntp, seqp);
                return;
            }
            case 102: {
                tvp.getValue((IPointable)this.enp);
                if (!this.enp.childrenChunkExists()) break;
                this.enp.getChildrenSequence(this.ntp, seqp);
                return;
            }
        }
        XDMConstants.setEmptySequence((IPointable)seqp);
    }

    public void init(TaggedValuePointable tvp, List<Integer> typeCodes) throws SystemException {
        this.indexSequence = new int[typeCodes.size()];
        for (int i = 0; i < typeCodes.size(); ++i) {
            this.indexSequence[i] = 0;
        }
        this.setFilterCode(typeCodes);
        if (tvp.getTag() != 107) {
            throw new SystemException(ErrorCode.SYSE0001);
        }
        tvp.getValue((IPointable)this.ntp);
    }

    protected void setFilterCode(List<Integer> typeCodes) {
        for (int typeCode : typeCodes) {
            SequenceType sType = this.dCtx.getStaticContext().lookupSequenceType(typeCode);
            NodeTestFilter.INodeFilter f = NodeTestFilter.getNodeTestFilter(sType);
            this.filter.add(f);
        }
    }

    @Override
    protected void setNodeToResult(TaggedValuePointable tvpItem, IPointable result) throws IOException {
        this.nodeAbvs.reset();
        this.nstb.reset((IMutableValueStorage)this.nodeAbvs);
        this.nstb.setChildNode(this.ntp, tvpItem);
        this.nstb.finish();
        result.set(this.nodeAbvs.getByteArray(), this.nodeAbvs.getStartOffset(), this.nodeAbvs.getLength());
    }

    public boolean step(IPointable result) throws AlgebricksException {
        this.ntp.getRootNode(this.tvpStep);
        return this.stepNodeTree(this.tvpStep, 0, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean stepNodeTree(TaggedValuePointable tvpInput, int level, IPointable result) throws AlgebricksException {
        SequencePointable seqItem = this.pp.takeOne(SequencePointable.class);
        try {
            this.getSequence(tvpInput, seqItem);
            int seqLength = seqItem.getEntryCount();
            while (this.indexSequence[level] < seqLength) {
                seqItem.getEntry(this.indexSequence[level], (IPointable)this.tvpItem);
                if (this.filter.get(level).accept(this.ntp, this.tvpItem)) {
                    if (level + 1 >= this.indexSequence.length) {
                        this.setNodeToResult(this.tvpItem, result);
                        int n = level;
                        this.indexSequence[n] = this.indexSequence[n] + 1;
                        boolean bl = true;
                        return bl;
                    }
                    if (this.stepNodeTree(this.tvpItem, level + 1, result)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                int n = level;
                this.indexSequence[n] = this.indexSequence[n] + 1;
            }
            this.indexSequence[level] = 0;
            boolean bl = false;
            return bl;
        }
        finally {
            this.pp.giveBack(seqItem);
        }
    }
}

