/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.sequence;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentAggregateEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentAggregateEvaluatorFactory;
import org.apache.vxquery.util.GrowableIntArray;

public class SequenceAggregateEvaluatorFactory
extends AbstractTaggedValueArgumentAggregateEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public SequenceAggregateEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IAggregateEvaluator createEvaluator(IScalarEvaluator[] args) throws AlgebricksException {
        final ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        final GrowableIntArray slots = new GrowableIntArray();
        final ArrayBackedValueStorage dataArea = new ArrayBackedValueStorage();
        final SequencePointable seq = (SequencePointable)SequencePointable.FACTORY.createPointable();
        final VoidPointable p = (VoidPointable)VoidPointable.FACTORY.createPointable();
        return new AbstractTaggedValueArgumentAggregateEvaluator(args){

            public void init() throws AlgebricksException {
                abvs.reset();
                slots.clear();
                dataArea.reset();
            }

            public void finish(IPointable result) throws AlgebricksException {
                if (slots.getSize() != 1) {
                    try {
                        this.assembleResult(abvs, slots, dataArea);
                    }
                    catch (SystemException e) {
                        throw new AlgebricksException((Throwable)e);
                    }
                    result.set((IValueReference)abvs);
                } else {
                    result.set((IValueReference)dataArea);
                }
            }

            @Override
            protected void step(TaggedValuePointable[] args) throws SystemException {
                TaggedValuePointable tvp = args[0];
                if (tvp.getTag() == 100) {
                    tvp.getValue((IPointable)seq);
                    int seqLen = seq.getEntryCount();
                    for (int j = 0; j < seqLen; ++j) {
                        seq.getEntry(j, (IPointable)p);
                        this.addItem((IPointable)p);
                    }
                } else {
                    this.addItem((IPointable)tvp);
                }
            }

            private void assembleResult(ArrayBackedValueStorage abvs2, GrowableIntArray slots2, ArrayBackedValueStorage dataArea2) throws SystemException {
                try {
                    DataOutput out = abvs2.getDataOutput();
                    out.write(100);
                    int size = slots2.getSize();
                    out.writeInt(size);
                    if (size > 0) {
                        int[] slotArray = slots2.getArray();
                        for (int i = 0; i < size; ++i) {
                            out.writeInt(slotArray[i]);
                        }
                        out.write(dataArea2.getByteArray(), dataArea2.getStartOffset(), dataArea2.getLength());
                    }
                }
                catch (IOException e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
            }

            private void addItem(IPointable p2) throws SystemException {
                try {
                    dataArea.getDataOutput().write(p2.getByteArray(), p2.getStartOffset(), p2.getLength());
                    slots.append(dataArea.getLength());
                }
                catch (IOException e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
            }
        };
    }
}

