/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.numeric;

import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.FloatPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.atomic.XSDecimalPointable;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.numeric.AbstractNumericOperation;

public class FnRoundOperation
extends AbstractNumericOperation {
    @Override
    public void operateDecimal(XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(24);
        dOut.write(decp.getDecimalPlace());
        dOut.writeLong(Math.round(decp.getDecimalValue()));
    }

    @Override
    public void operateDouble(DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        double value = doublep.getDouble();
        if (value < 0.0 && value >= -0.5) {
            value = -0.0;
        } else if (!Double.isNaN(value) && !Double.isInfinite(value) && value != 0.0) {
            value = Math.round(value);
        }
        dOut.write(23);
        dOut.writeDouble(value);
    }

    @Override
    public void operateFloat(FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        float value = floatp.getFloat();
        if (value < 0.0f && value >= -0.5f) {
            value = -0.0f;
        } else if (!Float.isNaN(value) && !Float.isInfinite(value) && value != 0.0f) {
            value = Math.round(value);
        }
        dOut.write(22);
        dOut.writeFloat(value);
    }

    @Override
    public void operateInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(25);
        dOut.writeLong(longp.getLong());
    }
}

