/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.numeric;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.FloatPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.primitive.ShortPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDecimalPointable;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluatorFactory;
import org.apache.vxquery.runtime.functions.cast.CastToDecimalOperation;
import org.apache.vxquery.runtime.functions.util.FunctionHelper;
import org.apache.vxquery.types.BuiltinTypeRegistry;

public class FnRoundHalfToEvenScalarEvaluatorFactory
extends AbstractTaggedValueArgumentScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public FnRoundHalfToEvenScalarEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected AbstractTaggedValueArgumentScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        return new AbstractTaggedValueArgumentScalarEvaluator(args){
            final ArrayBackedValueStorage abvs;
            final DataOutput dOut;
            final ArrayBackedValueStorage abvsInner;
            final DataOutput dOutInner;
            final FunctionHelper.TypedPointables tp;
            final LongPointable longp;
            final CastToDecimalOperation castToDecimal;
            {
                this.abvs = new ArrayBackedValueStorage();
                this.dOut = this.abvs.getDataOutput();
                this.abvsInner = new ArrayBackedValueStorage();
                this.dOutInner = this.abvsInner.getDataOutput();
                this.tp = new FunctionHelper.TypedPointables();
                this.longp = (LongPointable)LongPointable.FACTORY.createPointable();
                this.castToDecimal = new CastToDecimalOperation();
            }

            @Override
            protected void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
                TaggedValuePointable tvp1 = args[0];
                int tid = this.getBaseTypeForArithmetics(tvp1.getTag());
                long precision = 0L;
                if (args.length > 1) {
                    TaggedValuePointable tvp2 = args[1];
                    if (tvp2.getTag() != 25) {
                        throw new SystemException(ErrorCode.FORG0006);
                    }
                    tvp2.getValue((IPointable)this.longp);
                    precision = this.longp.getLong();
                }
                try {
                    switch (tid) {
                        case 22: {
                            tvp1.getValue((IPointable)this.tp.floatp);
                            if (this.tp.floatp.getFloat() != 0.0f && !Float.isNaN(this.tp.floatp.getFloat()) && !Float.isInfinite(this.tp.floatp.getFloat())) break;
                            result.set(tvp1.getByteArray(), tvp1.getStartOffset(), FloatPointable.TYPE_TRAITS.getFixedLength() + 1);
                            return;
                        }
                        case 23: {
                            tvp1.getValue((IPointable)this.tp.doublep);
                            if (this.tp.doublep.getDouble() != 0.0 && !Double.isNaN(this.tp.doublep.getDouble()) && !Double.isInfinite(this.tp.doublep.getDouble())) break;
                            result.set(tvp1.getByteArray(), tvp1.getStartOffset(), DoublePointable.TYPE_TRAITS.getFixedLength() + 1);
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
                try {
                    this.getDecimalPointable(this.tp, tvp1);
                }
                catch (IOException e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
                long decimalPlace = this.tp.decp.getDecimalPlace();
                if (precision - decimalPlace < 0L) {
                    long decimalValue = this.tp.decp.getDecimalValue();
                    decimalValue = (long)((double)decimalValue / Math.pow(10.0, -(precision - decimalPlace)));
                    this.tp.decp.setDecimal(decimalValue, (byte)precision);
                }
                try {
                    switch (tvp1.getTag()) {
                        case 24: {
                            this.dOut.write(24);
                            this.dOut.write(this.tp.decp.getByteArray(), this.tp.decp.getStartOffset(), XSDecimalPointable.TYPE_TRAITS.getFixedLength());
                            result.set(this.abvs.getByteArray(), this.abvs.getStartOffset(), XSDecimalPointable.TYPE_TRAITS.getFixedLength() + 1);
                            return;
                        }
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 37: {
                            this.dOut.write(tvp1.getTag());
                            this.dOut.writeLong(this.tp.decp.longValue());
                            result.set(this.abvs.getByteArray(), this.abvs.getStartOffset(), LongPointable.TYPE_TRAITS.getFixedLength() + 1);
                            return;
                        }
                        case 29: 
                        case 35: {
                            this.dOut.write(tvp1.getTag());
                            this.dOut.writeInt(this.tp.decp.intValue());
                            result.set(this.abvs.getByteArray(), this.abvs.getStartOffset(), IntegerPointable.TYPE_TRAITS.getFixedLength() + 1);
                            return;
                        }
                        case 30: 
                        case 36: {
                            this.dOut.write(tvp1.getTag());
                            this.dOut.writeShort(this.tp.decp.shortValue());
                            result.set(this.abvs.getByteArray(), this.abvs.getStartOffset(), ShortPointable.TYPE_TRAITS.getFixedLength() + 1);
                            return;
                        }
                        case 31: {
                            this.dOut.write(tvp1.getTag());
                            this.dOut.writeByte(this.tp.decp.byteValue());
                            result.set(this.abvs.getByteArray(), this.abvs.getStartOffset(), BytePointable.TYPE_TRAITS.getFixedLength() + 1);
                            return;
                        }
                        case 22: {
                            this.dOut.write(22);
                            this.dOut.writeFloat(this.tp.decp.floatValue());
                            result.set(this.abvs.getByteArray(), this.abvs.getStartOffset(), FloatPointable.TYPE_TRAITS.getFixedLength() + 1);
                            return;
                        }
                        case 23: {
                            this.dOut.write(23);
                            this.dOut.writeDouble(this.tp.decp.doubleValue());
                            result.set(this.abvs.getByteArray(), this.abvs.getStartOffset(), DoublePointable.TYPE_TRAITS.getFixedLength() + 1);
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
            }

            private void getDecimalPointable(FunctionHelper.TypedPointables tp, TaggedValuePointable tvp) throws SystemException, IOException {
                long value;
                this.abvsInner.reset();
                switch (tvp.getTag()) {
                    case 24: {
                        tvp.getValue((IPointable)tp.decp);
                        return;
                    }
                    case 22: {
                        tvp.getValue((IPointable)tp.floatp);
                        this.castToDecimal.convertFloat(tp.floatp, this.dOutInner);
                        tp.decp.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset() + 1, XSDecimalPointable.TYPE_TRAITS.getFixedLength());
                        return;
                    }
                    case 23: {
                        tvp.getValue((IPointable)tp.doublep);
                        this.castToDecimal.convertDouble(tp.doublep, this.dOutInner);
                        tp.decp.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset() + 1, XSDecimalPointable.TYPE_TRAITS.getFixedLength());
                        return;
                    }
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 37: {
                        tvp.getValue((IPointable)tp.longp);
                        value = tp.longp.longValue();
                        break;
                    }
                    case 29: 
                    case 35: {
                        tvp.getValue((IPointable)tp.intp);
                        value = tp.intp.longValue();
                        break;
                    }
                    case 30: 
                    case 36: {
                        tvp.getValue((IPointable)tp.shortp);
                        value = tp.shortp.longValue();
                        break;
                    }
                    case 31: {
                        tvp.getValue((IPointable)tp.bytep);
                        value = tp.bytep.longValue();
                        break;
                    }
                    default: {
                        throw new SystemException(ErrorCode.XPTY0004);
                    }
                }
                this.dOutInner.write(24);
                tp.decp.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset() + 1, XSDecimalPointable.TYPE_TRAITS.getFixedLength());
                tp.decp.setDecimal(value, (byte)0);
            }

            private int getBaseTypeForArithmetics(int tid) throws SystemException {
                while (true) {
                    switch (tid) {
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            return tid;
                        }
                        case 3: {
                            throw new SystemException(ErrorCode.XPTY0004);
                        }
                    }
                    tid = BuiltinTypeRegistry.INSTANCE.getSchemaTypeById(tid).getBaseType().getTypeId();
                }
            }
        };
    }
}

