/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.numeric;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluatorFactory;
import org.apache.vxquery.runtime.functions.numeric.AbstractNumericOperation;
import org.apache.vxquery.runtime.functions.util.FunctionHelper;
import org.apache.vxquery.types.BuiltinTypeRegistry;

public abstract class AbstractNumericScalarEvaluatorFactory
extends AbstractTaggedValueArgumentScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public AbstractNumericScalarEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected AbstractTaggedValueArgumentScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        return new AbstractTaggedValueArgumentScalarEvaluator(args){
            final AbstractNumericOperation aOp;
            final ArrayBackedValueStorage abvs;
            final DataOutput dOut;
            final ArrayBackedValueStorage abvsInteger;
            final DataOutput dOutInteger;
            final FunctionHelper.TypedPointables tp;
            {
                this.aOp = AbstractNumericScalarEvaluatorFactory.this.createNumericOperation();
                this.abvs = new ArrayBackedValueStorage();
                this.dOut = this.abvs.getDataOutput();
                this.abvsInteger = new ArrayBackedValueStorage();
                this.dOutInteger = this.abvsInteger.getDataOutput();
                this.tp = new FunctionHelper.TypedPointables();
            }

            @Override
            protected void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
                TaggedValuePointable tvp = args[0];
                int tid = this.getBaseTypeForArithmetics(tvp.getTag());
                this.abvs.reset();
                try {
                    switch (tid) {
                        case 100: {
                            tvp.getValue((IPointable)this.tp.seqp);
                            if (this.tp.seqp.getEntryCount() == 0) {
                                XDMConstants.setEmptySequence(result);
                                return;
                            }
                        }
                        case 24: {
                            tvp.getValue((IPointable)this.tp.decp);
                            this.aOp.operateDecimal(this.tp.decp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 25: {
                            LongPointable longp = (LongPointable)LongPointable.FACTORY.createPointable();
                            switch (tvp.getTag()) {
                                case 25: 
                                case 26: 
                                case 27: 
                                case 28: 
                                case 29: 
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: {
                                    this.abvsInteger.reset();
                                    FunctionHelper.getIntegerPointable(tvp, this.dOutInteger);
                                    longp.set(this.abvsInteger.getByteArray(), this.abvsInteger.getStartOffset() + 1, LongPointable.TYPE_TRAITS.getFixedLength());
                                }
                            }
                            this.aOp.operateInteger(longp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 22: {
                            tvp.getValue((IPointable)this.tp.floatp);
                            this.aOp.operateFloat(this.tp.floatp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 23: {
                            tvp.getValue((IPointable)this.tp.doublep);
                            this.aOp.operateDouble(this.tp.doublep, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                    }
                }
                catch (SystemException se) {
                    throw se;
                }
                catch (Exception e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
                throw new SystemException(ErrorCode.XPTY0004);
            }

            private int getBaseTypeForArithmetics(int tid) throws SystemException {
                while (true) {
                    switch (tid) {
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            return tid;
                        }
                        case 3: {
                            throw new SystemException(ErrorCode.XPTY0004);
                        }
                    }
                    tid = BuiltinTypeRegistry.INSTANCE.getSchemaTypeById(tid).getBaseType().getTypeId();
                }
            }
        };
    }

    protected abstract AbstractNumericOperation createNumericOperation();
}

