/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.node;

import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IMutableValueStorage;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import edu.uci.ics.hyracks.data.std.primitive.VoidPointable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.accessors.atomic.CodedQNamePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSQNamePointable;
import org.apache.vxquery.datamodel.accessors.nodes.AttributeNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.DocumentNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.ElementNodePointable;
import org.apache.vxquery.datamodel.accessors.nodes.NodeTreePointable;
import org.apache.vxquery.datamodel.builders.nodes.AttributeNodeBuilder;
import org.apache.vxquery.datamodel.builders.nodes.DictionaryBuilder;
import org.apache.vxquery.datamodel.builders.nodes.ElementNodeBuilder;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.node.AbstractNodeConstructorScalarEvaluator;

public class ElementNodeConstructorScalarEvaluator
extends AbstractNodeConstructorScalarEvaluator {
    private final ElementNodeBuilder enb = new ElementNodeBuilder();
    private final AttributeNodeBuilder anb = new AttributeNodeBuilder();
    private final List<ElementNodeBuilder> freeENBList = new ArrayList<ElementNodeBuilder>();
    private final XSQNamePointable namep = (XSQNamePointable)XSQNamePointable.FACTORY.createPointable();
    private final CodedQNamePointable cqp = (CodedQNamePointable)CodedQNamePointable.FACTORY.createPointable();
    private final UTF8StringPointable strp = (UTF8StringPointable)UTF8StringPointable.FACTORY.createPointable();
    private final SequencePointable seqp = (SequencePointable)SequencePointable.FACTORY.createPointable();

    public ElementNodeConstructorScalarEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) {
        super(ctx, args);
    }

    @Override
    protected void constructNode(DictionaryBuilder db, TaggedValuePointable[] args, IMutableValueStorage mvs) throws IOException, SystemException {
        this.enb.reset(mvs);
        TaggedValuePointable nameArg = args[0];
        if (nameArg.getTag() != 47) {
            throw new SystemException(ErrorCode.XPST0081);
        }
        nameArg.getValue((IPointable)this.namep);
        this.namep.getUri((IPointable)this.strp);
        int uriCode = db.lookup(this.strp);
        this.namep.getPrefix((IPointable)this.strp);
        int prefixCode = db.lookup(this.strp);
        this.namep.getLocalName((IPointable)this.strp);
        int localCode = db.lookup(this.strp);
        this.enb.setName(uriCode, localCode, prefixCode);
        TaggedValuePointable valueArg = args[1];
        this.enb.startAttributeChunk();
        int index = this.processAttributes(valueArg, db);
        this.enb.endAttributeChunk();
        this.enb.startChildrenChunk();
        if (index >= 0) {
            this.processChildren(valueArg, index, db);
        }
        this.enb.endChildrenChunk();
        this.enb.finish();
    }

    private int processAttributes(TaggedValuePointable tvp, DictionaryBuilder db) throws IOException {
        if (tvp.getTag() == 100) {
            tvp.getValue((IPointable)this.seqp);
            TaggedValuePointable tempTvp = this.ppool.takeOne(TaggedValuePointable.class);
            for (int i = 0; i < this.seqp.getEntryCount(); ++i) {
                this.seqp.getEntry(i, (IPointable)tempTvp);
                if (this.processIfAttribute(tempTvp, db)) continue;
                return i;
            }
            this.ppool.giveBack(tempTvp);
        } else if (!this.processIfAttribute(tvp, db)) {
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processIfAttribute(TaggedValuePointable tvp, DictionaryBuilder db) throws IOException {
        if (tvp.getTag() != 107) {
            return false;
        }
        NodeTreePointable ntp = this.ppool.takeOne(NodeTreePointable.class);
        try {
            TaggedValuePointable innerTvp;
            block12: {
                tvp.getValue((IPointable)ntp);
                innerTvp = this.ppool.takeOne(TaggedValuePointable.class);
                try {
                    ntp.getRootNode(innerTvp);
                    if (innerTvp.getTag() == 103) break block12;
                    boolean bl = false;
                    this.ppool.giveBack(innerTvp);
                    return bl;
                }
                catch (Throwable throwable) {
                    this.ppool.giveBack(innerTvp);
                    throw throwable;
                }
            }
            AttributeNodePointable anp = this.ppool.takeOne(AttributeNodePointable.class);
            try {
                innerTvp.getValue((IPointable)anp);
                this.copyAttribute(this.enb, db, ntp, anp);
            }
            finally {
                this.ppool.giveBack(anp);
            }
            boolean bl = true;
            this.ppool.giveBack(innerTvp);
            return bl;
        }
        finally {
            this.ppool.giveBack(ntp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAttribute(ElementNodeBuilder enb, DictionaryBuilder db, NodeTreePointable ntp, AttributeNodePointable anp) throws IOException {
        UTF8StringPointable strp = this.ppool.takeOne(UTF8StringPointable.class);
        VoidPointable vp = this.ppool.takeOne(VoidPointable.class);
        try {
            enb.startAttribute(this.anb);
            anp.getName(this.cqp);
            int newURICode = this.recode(this.cqp.getNamespaceCode(), ntp, db, strp);
            int newPrefixCode = this.recode(this.cqp.getPrefixCode(), ntp, db, strp);
            int newLocalCode = this.recode(this.cqp.getLocalCode(), ntp, db, strp);
            this.anb.setName(newURICode, newLocalCode, newPrefixCode);
            anp.getValue(ntp, (IPointable)vp);
            this.anb.setValue((IValueReference)vp);
            enb.endAttribute(this.anb);
        }
        finally {
            this.ppool.giveBack(vp);
            this.ppool.giveBack(strp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyElement(ElementNodeBuilder enb, DictionaryBuilder db, NodeTreePointable ntp, ElementNodePointable enp) throws IOException {
        UTF8StringPointable strp = this.ppool.takeOne(UTF8StringPointable.class);
        SequencePointable seqp = this.ppool.takeOne(SequencePointable.class);
        AttributeNodePointable anp = this.ppool.takeOne(AttributeNodePointable.class);
        TaggedValuePointable tvp = this.ppool.takeOne(TaggedValuePointable.class);
        ElementNodePointable cenp = this.ppool.takeOne(ElementNodePointable.class);
        try {
            int i;
            ElementNodeBuilder tempEnb = this.createENB();
            enb.startChild(tempEnb);
            enp.getName(this.cqp);
            int newURICode = this.recode(this.cqp.getNamespaceCode(), ntp, db, strp);
            int newPrefixCode = this.recode(this.cqp.getPrefixCode(), ntp, db, strp);
            int newLocalCode = this.recode(this.cqp.getLocalCode(), ntp, db, strp);
            tempEnb.setName(newURICode, newLocalCode, newPrefixCode);
            tempEnb.startAttributeChunk();
            if (enp.attributesChunkExists()) {
                enp.getAttributeSequence(ntp, seqp);
                for (i = 0; i < seqp.getEntryCount(); ++i) {
                    seqp.getEntry(i, (IPointable)tvp);
                    tvp.getValue((IPointable)anp);
                    this.copyAttribute(tempEnb, db, ntp, anp);
                }
            }
            tempEnb.endAttributeChunk();
            tempEnb.startChildrenChunk();
            if (enp.childrenChunkExists()) {
                enp.getChildrenSequence(ntp, seqp);
                block8: for (i = 0; i < seqp.getEntryCount(); ++i) {
                    seqp.getEntry(i, (IPointable)tvp);
                    byte nTag = tvp.getTag();
                    switch (nTag) {
                        case 102: {
                            tvp.getValue((IPointable)cenp);
                            this.copyElement(tempEnb, db, ntp, cenp);
                            continue block8;
                        }
                        case 104: 
                        case 105: 
                        case 106: {
                            tempEnb.addChild((IValueReference)tvp);
                        }
                    }
                }
            }
            tempEnb.endChildrenChunk();
            enb.endChild(tempEnb);
            this.freeENB(tempEnb);
        }
        finally {
            this.ppool.giveBack(cenp);
            this.ppool.giveBack(tvp);
            this.ppool.giveBack(anp);
            this.ppool.giveBack(seqp);
            this.ppool.giveBack(strp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDocument(ElementNodeBuilder enb, DictionaryBuilder db, NodeTreePointable ntp, DocumentNodePointable dnp) throws IOException {
        SequencePointable seqp = this.ppool.takeOne(SequencePointable.class);
        AttributeNodePointable anp = this.ppool.takeOne(AttributeNodePointable.class);
        TaggedValuePointable tvp = this.ppool.takeOne(TaggedValuePointable.class);
        ElementNodePointable cenp = this.ppool.takeOne(ElementNodePointable.class);
        try {
            dnp.getContent(ntp, seqp);
            for (int i = 0; i < seqp.getEntryCount(); ++i) {
                seqp.getEntry(i, (IPointable)tvp);
                if (tvp.getTag() != 102) continue;
                tvp.getValue((IPointable)cenp);
                this.copyElement(enb, db, ntp, cenp);
                break;
            }
        }
        finally {
            this.ppool.giveBack(cenp);
            this.ppool.giveBack(tvp);
            this.ppool.giveBack(anp);
            this.ppool.giveBack(seqp);
        }
    }

    private int recode(int oldCode, NodeTreePointable ntp, DictionaryBuilder db, UTF8StringPointable tempStrp) {
        ntp.getString(oldCode, (IPointable)tempStrp);
        return db.lookup(tempStrp);
    }

    private void processChildren(TaggedValuePointable tvp, int start, DictionaryBuilder db) throws IOException, SystemException {
        if (tvp.getTag() == 100) {
            tvp.getValue((IPointable)this.seqp);
            TaggedValuePointable tempTvp = this.ppool.takeOne(TaggedValuePointable.class);
            for (int i = start; i < this.seqp.getEntryCount(); ++i) {
                this.seqp.getEntry(i, (IPointable)tempTvp);
                this.processChild(tempTvp, db);
            }
            this.ppool.giveBack(tempTvp);
        } else {
            this.processChild(tvp, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processChild(TaggedValuePointable tvp, DictionaryBuilder db) throws IOException, SystemException {
        if (tvp.getTag() != 107) {
            this.enb.addChild((IValueReference)tvp);
            return;
        }
        NodeTreePointable ntp = this.ppool.takeOne(NodeTreePointable.class);
        try {
            tvp.getValue((IPointable)ntp);
            TaggedValuePointable innerTvp = this.ppool.takeOne(TaggedValuePointable.class);
            try {
                ntp.getRootNode(innerTvp);
                byte nTag = innerTvp.getTag();
                switch (nTag) {
                    case 103: {
                        throw new SystemException(ErrorCode.XQTY0024);
                    }
                    case 102: {
                        ElementNodePointable enp = this.ppool.takeOne(ElementNodePointable.class);
                        try {
                            innerTvp.getValue((IPointable)enp);
                            this.copyElement(this.enb, db, ntp, enp);
                            return;
                        }
                        finally {
                            this.ppool.giveBack(enp);
                        }
                    }
                    case 104: 
                    case 105: 
                    case 106: {
                        this.enb.addChild((IValueReference)innerTvp);
                        return;
                    }
                    case 101: {
                        DocumentNodePointable dnp = this.ppool.takeOne(DocumentNodePointable.class);
                        try {
                            innerTvp.getValue((IPointable)dnp);
                            this.copyDocument(this.enb, db, ntp, dnp);
                            return;
                        }
                        finally {
                            this.ppool.giveBack(dnp);
                        }
                    }
                }
                return;
            }
            finally {
                this.ppool.giveBack(innerTvp);
            }
        }
        finally {
            this.ppool.giveBack(ntp);
        }
    }

    private ElementNodeBuilder createENB() {
        if (this.freeENBList.isEmpty()) {
            return new ElementNodeBuilder();
        }
        return this.freeENBList.remove(this.freeENBList.size() - 1);
    }

    private void freeENB(ElementNodeBuilder enb) {
        this.freeENBList.add(enb);
    }

    @Override
    protected boolean createsDictionary() {
        return true;
    }
}

