/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.node;

import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IMutableValueStorage;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.builders.nodes.DictionaryBuilder;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;

public abstract class AbstractNodeConstructorScalarEvaluator
extends AbstractTaggedValueArgumentScalarEvaluator {
    protected final IHyracksTaskContext ctx;
    private final ArrayBackedValueStorage abvs;
    private final DictionaryBuilder db;
    private final ArrayBackedValueStorage contentAbvs;

    public AbstractNodeConstructorScalarEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) {
        super(args);
        this.ctx = ctx;
        this.abvs = new ArrayBackedValueStorage();
        this.db = this.createsDictionary() ? new DictionaryBuilder() : null;
        this.contentAbvs = this.createsDictionary() ? new ArrayBackedValueStorage() : this.abvs;
    }

    @Override
    protected final void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
        this.abvs.reset();
        this.contentAbvs.reset();
        try {
            DataOutput mainOut = this.abvs.getDataOutput();
            mainOut.write(107);
            byte header = (byte)(this.createsDictionary() ? 2 : 0);
            mainOut.write(header);
            this.constructNode(this.db, args, (IMutableValueStorage)this.contentAbvs);
            if (this.createsDictionary()) {
                this.db.write(this.abvs);
                this.abvs.append((IValueReference)this.contentAbvs);
            }
            result.set((IValueReference)this.abvs);
        }
        catch (IOException e) {
            throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
        }
    }

    protected abstract void constructNode(DictionaryBuilder var1, TaggedValuePointable[] var2, IMutableValueStorage var3) throws IOException, SystemException;

    protected abstract boolean createsDictionary();
}

