/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.misc;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IMutableValueStorage;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.builders.sequence.SequenceBuilder;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluatorFactory;
import org.apache.vxquery.runtime.functions.util.AtomizeHelper;

public class FnDataScalarEvaluatorFactory
extends AbstractTaggedValueArgumentScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public FnDataScalarEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        return new FnDataScalarEvaluator(args);
    }

    private static class FnDataScalarEvaluator
    extends AbstractTaggedValueArgumentScalarEvaluator {
        final AtomizeHelper ah = new AtomizeHelper();
        final ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        final SequenceBuilder sb = new SequenceBuilder();
        final SequencePointable seq = (SequencePointable)SequencePointable.FACTORY.createPointable();
        final TaggedValuePointable p = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
        final TaggedValuePointable tempTVP = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();

        public FnDataScalarEvaluator(IScalarEvaluator[] args) {
            super(args);
        }

        @Override
        protected void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
            try {
                this.abvs.reset();
                this.sb.reset((IMutableValueStorage)this.abvs);
                TaggedValuePointable tvp = args[0];
                if (tvp.getTag() == 100) {
                    tvp.getValue((IPointable)this.seq);
                    int seqLen = this.seq.getEntryCount();
                    for (int j = 0; j < seqLen; ++j) {
                        this.seq.getEntry(j, (IPointable)this.p);
                        this.ah.atomize(this.p, this.ppool, (IPointable)this.tempTVP);
                        this.sb.addItem((IValueReference)this.tempTVP);
                    }
                } else {
                    this.ah.atomize(tvp, this.ppool, (IPointable)this.tempTVP);
                    this.sb.addItem((IValueReference)this.tempTVP);
                }
                this.sb.finish();
                result.set((IValueReference)this.abvs);
            }
            catch (IOException e) {
                throw new SystemException(ErrorCode.SYSE0001);
            }
        }
    }
}

