/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.datetime;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDatePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDateTimePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSTimePointable;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluatorFactory;

public class FnDateTimeScalarEvaluatorFactory
extends AbstractTaggedValueArgumentScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public FnDateTimeScalarEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        final XSDatePointable datep = (XSDatePointable)XSDatePointable.FACTORY.createPointable();
        final XSTimePointable timep = (XSTimePointable)XSTimePointable.FACTORY.createPointable();
        final SequencePointable seqp = (SequencePointable)SequencePointable.FACTORY.createPointable();
        final ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        final DataOutput dOut = abvs.getDataOutput();
        return new AbstractTaggedValueArgumentScalarEvaluator(args){

            @Override
            protected void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
                int timezoneMinute;
                int timezoneHour;
                TaggedValuePointable tvp1 = args[0];
                if (tvp1.getTag() == 100) {
                    tvp1.getValue((IPointable)seqp);
                    if (seqp.getEntryCount() == 0) {
                        XDMConstants.setEmptySequence(result);
                        return;
                    }
                }
                if (tvp1.getTag() != 16) {
                    throw new SystemException(ErrorCode.FORG0006);
                }
                tvp1.getValue((IPointable)datep);
                TaggedValuePointable tvp2 = args[1];
                if (tvp2.getTag() == 100) {
                    tvp2.getValue((IPointable)seqp);
                    if (seqp.getEntryCount() == 0) {
                        XDMConstants.setEmptySequence(result);
                        return;
                    }
                }
                if (tvp2.getTag() != 17) {
                    throw new SystemException(ErrorCode.FORG0006);
                }
                tvp2.getValue((IPointable)timep);
                if (datep.getTimezoneHour() == 127L && datep.getTimezoneMinute() == 127L && timep.getTimezoneHour() == 127L && timep.getTimezoneMinute() == 127L) {
                    timezoneHour = 127;
                    timezoneMinute = 127;
                } else if (datep.getTimezoneHour() == 127L && datep.getTimezoneMinute() == 127L && timep.getTimezoneHour() != 127L && timep.getTimezoneMinute() != 127L) {
                    timezoneHour = (byte)timep.getTimezoneHour();
                    timezoneMinute = (byte)timep.getTimezoneMinute();
                } else if (datep.getTimezoneHour() != 127L && datep.getTimezoneMinute() != 127L && timep.getTimezoneHour() == 127L && timep.getTimezoneMinute() == 127L) {
                    timezoneHour = (byte)datep.getTimezoneHour();
                    timezoneMinute = (byte)datep.getTimezoneMinute();
                } else if (datep.getTimezoneHour() == timep.getTimezoneHour() && datep.getTimezoneMinute() == timep.getTimezoneMinute()) {
                    timezoneHour = (byte)datep.getTimezoneHour();
                    timezoneMinute = (byte)datep.getTimezoneMinute();
                } else {
                    throw new SystemException(ErrorCode.FORG0008);
                }
                try {
                    abvs.reset();
                    dOut.write(15);
                    dOut.write(datep.getByteArray(), datep.getStartOffset(), XSDatePointable.TYPE_TRAITS.getFixedLength() - 2);
                    dOut.write(timep.getByteArray(), timep.getStartOffset(), XSTimePointable.TYPE_TRAITS.getFixedLength() - 2);
                    dOut.write(timezoneHour);
                    dOut.write(timezoneMinute);
                    result.set(abvs.getByteArray(), abvs.getStartOffset(), XSDateTimePointable.TYPE_TRAITS.getFixedLength() + 1);
                }
                catch (IOException e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
            }
        };
    }
}

