/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.datetime;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.context.DynamicContext;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDatePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDateTimePointable;
import org.apache.vxquery.datamodel.util.DateTime;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluatorFactory;

public class FnAdjustDateToTimezoneScalarEvaluatorFactory
extends AbstractTaggedValueArgumentScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public FnAdjustDateToTimezoneScalarEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        final DynamicContext dCtx = (DynamicContext)ctx.getJobletContext().getGlobalJobData();
        final XSDatePointable datep = (XSDatePointable)XSDatePointable.FACTORY.createPointable();
        final XSDateTimePointable ctxDatetimep = (XSDateTimePointable)XSDateTimePointable.FACTORY.createPointable();
        final LongPointable longp = (LongPointable)LongPointable.FACTORY.createPointable();
        final ArrayBackedValueStorage abvsInner = new ArrayBackedValueStorage();
        final DataOutput dOutInner = abvsInner.getDataOutput();
        final ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        final DataOutput dOut = abvs.getDataOutput();
        return new AbstractTaggedValueArgumentScalarEvaluator(args){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
                long tz;
                dCtx.getCurrentDateTime((IPointable)ctxDatetimep);
                TaggedValuePointable tvp1 = args[0];
                if (tvp1.getTag() != 16) {
                    throw new SystemException(ErrorCode.FORG0006);
                }
                tvp1.getValue((IPointable)datep);
                if (args.length == 2) {
                    TaggedValuePointable tvp2 = args[1];
                    if (tvp2.getTag() != 20) throw new SystemException(ErrorCode.FORG0006);
                    tvp2.getValue((IPointable)longp);
                    if (Math.abs(longp.getLong()) > 50400000L) {
                        throw new SystemException(ErrorCode.FODT0003);
                    }
                    tz = longp.getLong() / 60000L;
                } else {
                    tz = ctxDatetimep.getTimezoneHour() * 60L + ctxDatetimep.getTimezoneMinute();
                }
                try {
                    abvs.reset();
                    abvsInner.reset();
                    DateTime.adjustDateTimeToTimezone(datep, tz, dOutInner);
                    byte[] bytes = abvsInner.getByteArray();
                    int startOffset = abvsInner.getStartOffset() + 1;
                    bytes[startOffset + 4] = bytes[startOffset + 10];
                    bytes[startOffset + 5] = bytes[startOffset + 11];
                    dOut.write(16);
                    dOut.write(bytes, startOffset, XSDatePointable.TYPE_TRAITS.getFixedLength());
                    result.set((IValueReference)abvs);
                    return;
                }
                catch (IOException e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
            }
        };
    }
}

