/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.datetime;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDurationPointable;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluatorFactory;

public abstract class AbstractValueFromDurationScalarEvaluatorFactory
extends AbstractTaggedValueArgumentScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public AbstractValueFromDurationScalarEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        final XSDurationPointable durationp = (XSDurationPointable)XSDurationPointable.FACTORY.createPointable();
        final LongPointable longp = (LongPointable)LongPointable.FACTORY.createPointable();
        final IntegerPointable intp = (IntegerPointable)IntegerPointable.FACTORY.createPointable();
        final SequencePointable seqp = (SequencePointable)SequencePointable.FACTORY.createPointable();
        final ArrayBackedValueStorage abvsInner = new ArrayBackedValueStorage();
        final DataOutput dOutInner = abvsInner.getDataOutput();
        return new AbstractTaggedValueArgumentScalarEvaluator(args){

            @Override
            protected void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
                TaggedValuePointable tvp1 = args[0];
                long YMDuration = 0L;
                long DTDuration = 0L;
                switch (tvp1.getTag()) {
                    case 100: {
                        tvp1.getValue((IPointable)seqp);
                        if (seqp.getEntryCount() != 0) break;
                        XDMConstants.setEmptySequence(result);
                        return;
                    }
                    case 18: {
                        tvp1.getValue((IPointable)durationp);
                        YMDuration = durationp.getYearMonth();
                        DTDuration = durationp.getDayTime();
                        break;
                    }
                    case 20: {
                        tvp1.getValue((IPointable)longp);
                        DTDuration = longp.getLong();
                        break;
                    }
                    case 19: {
                        tvp1.getValue((IPointable)intp);
                        YMDuration = intp.getInteger();
                        break;
                    }
                    default: {
                        throw new SystemException(ErrorCode.FORG0006);
                    }
                }
                long value = AbstractValueFromDurationScalarEvaluatorFactory.this.convertDuration(YMDuration, DTDuration);
                try {
                    abvsInner.reset();
                    switch (AbstractValueFromDurationScalarEvaluatorFactory.this.getReturnTag()) {
                        case 25: {
                            dOutInner.write(25);
                            dOutInner.writeLong(value);
                            break;
                        }
                        case 24: {
                            long decimalPlace = 3L;
                            if (value % 1000L == 0L) {
                                value /= 1000L;
                                decimalPlace = 0L;
                            } else if (value % 100L == 0L) {
                                value /= 100L;
                                decimalPlace = 1L;
                            } else if (value % 10L == 0L) {
                                value /= 10L;
                                decimalPlace = 2L;
                            }
                            dOutInner.write(24);
                            dOutInner.write((byte)decimalPlace);
                            dOutInner.writeLong(value);
                        }
                    }
                    result.set((IValueReference)abvsInner);
                }
                catch (IOException e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
            }
        };
    }

    protected int getReturnTag() {
        return 25;
    }

    protected abstract long convertDuration(long var1, long var3);
}

