/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.datetime;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluatorFactory;

public abstract class AbstractValueFromDateTimeScalarEvaluatorFactory
extends AbstractTaggedValueArgumentScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public AbstractValueFromDateTimeScalarEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        final ArrayBackedValueStorage abvsInner = new ArrayBackedValueStorage();
        final DataOutput dOutInner = abvsInner.getDataOutput();
        final SequencePointable seqp = (SequencePointable)SequencePointable.FACTORY.createPointable();
        return new AbstractTaggedValueArgumentScalarEvaluator(args){

            @Override
            protected void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
                TaggedValuePointable tvp1 = args[0];
                if (tvp1.getTag() == 100) {
                    tvp1.getValue((IPointable)seqp);
                    if (seqp.getEntryCount() == 0) {
                        XDMConstants.setEmptySequence(result);
                        return;
                    }
                }
                if (tvp1.getTag() != AbstractValueFromDateTimeScalarEvaluatorFactory.this.getInputTag()) {
                    throw new SystemException(ErrorCode.FORG0006);
                }
                try {
                    abvsInner.reset();
                    switch (AbstractValueFromDateTimeScalarEvaluatorFactory.this.getReturnTag()) {
                        case 25: {
                            dOutInner.write(25);
                            dOutInner.writeLong(AbstractValueFromDateTimeScalarEvaluatorFactory.this.getValueAsInteger(tvp1));
                            break;
                        }
                        case 20: {
                            dOutInner.write(20);
                            dOutInner.writeLong(AbstractValueFromDateTimeScalarEvaluatorFactory.this.getValueAsInteger(tvp1));
                            break;
                        }
                        case 24: {
                            long value = AbstractValueFromDateTimeScalarEvaluatorFactory.this.getValueAsInteger(tvp1);
                            long decimalPlace = 3L;
                            if (value % 1000L == 0L) {
                                value /= 1000L;
                                decimalPlace = 0L;
                            } else if (value % 100L == 0L) {
                                value /= 100L;
                                decimalPlace = 1L;
                            } else if (value % 10L == 0L) {
                                value /= 10L;
                                decimalPlace = 2L;
                            }
                            dOutInner.write(24);
                            dOutInner.write((byte)decimalPlace);
                            dOutInner.writeLong(value);
                        }
                    }
                    result.set((IValueReference)abvsInner);
                }
                catch (IOException e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
            }
        };
    }

    protected abstract int getInputTag();

    protected int getReturnTag() {
        return 25;
    }

    protected abstract long getValueAsInteger(TaggedValuePointable var1);
}

