/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.comparison;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import org.apache.vxquery.context.DynamicContext;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluatorFactory;
import org.apache.vxquery.runtime.functions.comparison.AbstractValueComparisonOperation;
import org.apache.vxquery.runtime.functions.util.FunctionHelper;

public abstract class AbstractValueComparisonScalarEvaluatorFactory
extends AbstractTaggedValueArgumentScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public AbstractValueComparisonScalarEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        final ArrayBackedValueStorage abvs = new ArrayBackedValueStorage();
        final DataOutput dOut = abvs.getDataOutput();
        final AbstractValueComparisonOperation aOp = this.createValueComparisonOperation();
        final DynamicContext dCtx = (DynamicContext)ctx.getJobletContext().getGlobalJobData();
        final SequencePointable seqp = (SequencePointable)SequencePointable.FACTORY.createPointable();
        final ArrayBackedValueStorage abvsInteger1 = new ArrayBackedValueStorage();
        final DataOutput dOutInteger1 = abvsInteger1.getDataOutput();
        final ArrayBackedValueStorage abvsInteger2 = new ArrayBackedValueStorage();
        final DataOutput dOutInteger2 = abvsInteger2.getDataOutput();
        return new AbstractTaggedValueArgumentScalarEvaluator(args){

            @Override
            protected void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
                TaggedValuePointable tvp1 = args[0];
                TaggedValuePointable tvp2 = args[1];
                if (tvp1.getTag() == 100) {
                    tvp1.getValue((IPointable)seqp);
                    if (seqp.getEntryCount() == 0) {
                        XDMConstants.setEmptySequence(result);
                        return;
                    }
                    throw new SystemException(ErrorCode.XPTY0004);
                }
                if (tvp2.getTag() == 100) {
                    tvp2.getValue((IPointable)seqp);
                    if (seqp.getEntryCount() == 0) {
                        XDMConstants.setEmptySequence(result);
                        return;
                    }
                    throw new SystemException(ErrorCode.XPTY0004);
                }
                boolean booleanResult = this.transformThenCompareTaggedValues(aOp, tvp1, tvp2, dCtx);
                try {
                    abvs.reset();
                    dOut.write(43);
                    dOut.write(booleanResult ? 1 : 0);
                    result.set((IValueReference)abvs);
                }
                catch (Exception e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
            }

            protected boolean transformThenCompareTaggedValues(AbstractValueComparisonOperation aOp2, TaggedValuePointable tvp1, TaggedValuePointable tvp2, DynamicContext dCtx2) throws SystemException {
                TaggedValuePointable tvp1new = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
                TaggedValuePointable tvp2new = (TaggedValuePointable)TaggedValuePointable.FACTORY.createPointable();
                try {
                    if (tvp1.getTag() == 14) {
                        tvp1.getByteArray()[0] = 4;
                        tvp1new = tvp1;
                    } else if (FunctionHelper.isDerivedFromInteger(tvp1.getTag())) {
                        abvsInteger1.reset();
                        FunctionHelper.getIntegerPointable(tvp1, dOutInteger1);
                        tvp1new.set(abvsInteger1.getByteArray(), abvsInteger1.getStartOffset(), LongPointable.TYPE_TRAITS.getFixedLength() + 1);
                    } else {
                        tvp1new = tvp1;
                    }
                    if (tvp2.getTag() == 14) {
                        tvp2.getByteArray()[0] = 4;
                        tvp2new = tvp2;
                    } else if (FunctionHelper.isDerivedFromInteger(tvp2.getTag())) {
                        abvsInteger2.reset();
                        FunctionHelper.getIntegerPointable(tvp2, dOutInteger2);
                        tvp2new.set(abvsInteger2.getByteArray(), abvsInteger2.getStartOffset(), LongPointable.TYPE_TRAITS.getFixedLength() + 1);
                    } else {
                        tvp2new = tvp2;
                    }
                    return FunctionHelper.compareTaggedValues(aOp2, tvp1new, tvp2new, dCtx2);
                }
                catch (SystemException se) {
                    throw se;
                }
                catch (Exception e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
            }
        };
    }

    protected abstract AbstractValueComparisonOperation createValueComparisonOperation();
}

