/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.castable;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.castable.AbstractCastableAsOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsAnyURIOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsBase64BinaryOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsBooleanOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsByteOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsDTDurationOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsDateOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsDateTimeOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsDecimalOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsDoubleOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsDurationOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsFloatOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsGDayOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsGMonthDayOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsGMonthOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsGYearMonthOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsGYearOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsHexBinaryOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsIntOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsIntegerOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsLongOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsNegativeIntegerOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsNonNegativeIntegerOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsNonPositiveIntegerOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsNotationOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsQNameOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsShortOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsStringOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsTimeOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsUnsignedByteOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsUnsignedIntOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsUnsignedLongOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsUnsignedShortOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsUntypedAtomicOperation;
import org.apache.vxquery.runtime.functions.castable.CastableAsYMDurationOperation;
import org.apache.vxquery.runtime.functions.type.AbstractTypeScalarEvaluatorFactory;
import org.apache.vxquery.runtime.functions.util.FunctionHelper;
import org.apache.vxquery.types.BuiltinTypeRegistry;
import org.apache.vxquery.types.SequenceType;

public class CastableScalarEvaluatorFactory
extends AbstractTypeScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public CastableScalarEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        return new AbstractTypeScalarEvaluatorFactory.AbstractTypeScalarEvaluator(args, ctx){
            final ArrayBackedValueStorage abvs;
            final DataOutput dOut;
            final FunctionHelper.TypedPointables tp;
            AbstractCastableAsOperation aOp;
            {
                this.abvs = new ArrayBackedValueStorage();
                this.dOut = this.abvs.getDataOutput();
                this.tp = new FunctionHelper.TypedPointables();
                this.aOp = new CastableAsStringOperation();
            }

            @Override
            protected void evaluate(TaggedValuePointable tvp, IPointable result) throws SystemException {
                this.abvs.reset();
                byte tid = tvp.getTag();
                try {
                    switch (tid) {
                        case 46: {
                            tvp.getValue((IPointable)this.tp.utf8sp);
                            this.aOp.convertAnyURI(this.tp.utf8sp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 44: {
                            tvp.getValue((IPointable)this.tp.binaryp);
                            this.aOp.convertBase64Binary(this.tp.binaryp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 43: {
                            tvp.getValue((IPointable)this.tp.boolp);
                            this.aOp.convertBoolean(this.tp.boolp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 31: {
                            tvp.getValue((IPointable)this.tp.bytep);
                            this.aOp.convertByte(this.tp.bytep, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 16: {
                            tvp.getValue((IPointable)this.tp.datep);
                            this.aOp.convertDate(this.tp.datep, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 15: {
                            tvp.getValue((IPointable)this.tp.datetimep);
                            this.aOp.convertDatetime(this.tp.datetimep, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 20: {
                            tvp.getValue((IPointable)this.tp.longp);
                            this.aOp.convertDTDuration(this.tp.longp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 24: {
                            tvp.getValue((IPointable)this.tp.decp);
                            this.aOp.convertDecimal(this.tp.decp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 23: {
                            tvp.getValue((IPointable)this.tp.doublep);
                            this.aOp.convertDouble(this.tp.doublep, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 18: {
                            tvp.getValue((IPointable)this.tp.durationp);
                            this.aOp.convertDuration(this.tp.durationp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 22: {
                            tvp.getValue((IPointable)this.tp.floatp);
                            this.aOp.convertFloat(this.tp.floatp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 41: {
                            tvp.getValue((IPointable)this.tp.datep);
                            this.aOp.convertGDay(this.tp.datep, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 42: {
                            tvp.getValue((IPointable)this.tp.datep);
                            this.aOp.convertGMonth(this.tp.datep, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 40: {
                            tvp.getValue((IPointable)this.tp.datep);
                            this.aOp.convertGMonthDay(this.tp.datep, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 39: {
                            tvp.getValue((IPointable)this.tp.datep);
                            this.aOp.convertGYear(this.tp.datep, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 38: {
                            tvp.getValue((IPointable)this.tp.datep);
                            this.aOp.convertGYearMonth(this.tp.datep, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 45: {
                            tvp.getValue((IPointable)this.tp.binaryp);
                            this.aOp.convertHexBinary(this.tp.binaryp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 29: {
                            tvp.getValue((IPointable)this.tp.intp);
                            this.aOp.convertInt(this.tp.intp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 25: {
                            tvp.getValue((IPointable)this.tp.longp);
                            this.aOp.convertInteger(this.tp.longp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 28: {
                            tvp.getValue((IPointable)this.tp.longp);
                            this.aOp.convertLong(this.tp.longp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 27: {
                            tvp.getValue((IPointable)this.tp.longp);
                            this.aOp.convertNegativeInteger(this.tp.longp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 32: {
                            tvp.getValue((IPointable)this.tp.longp);
                            this.aOp.convertNonNegativeInteger(this.tp.longp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 26: {
                            tvp.getValue((IPointable)this.tp.longp);
                            this.aOp.convertNonPositiveInteger(this.tp.longp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 48: {
                            tvp.getValue((IPointable)this.tp.utf8sp);
                            this.aOp.convertNotation(this.tp.utf8sp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 37: {
                            tvp.getValue((IPointable)this.tp.longp);
                            this.aOp.convertPositiveInteger(this.tp.longp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 47: {
                            tvp.getValue((IPointable)this.tp.qnamep);
                            this.aOp.convertQName(this.tp.qnamep, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 100: {
                            XDMConstants.setFalse(result);
                            return;
                        }
                        case 30: {
                            tvp.getValue((IPointable)this.tp.shortp);
                            this.aOp.convertShort(this.tp.shortp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 4: {
                            tvp.getValue((IPointable)this.tp.utf8sp);
                            this.aOp.convertString(this.tp.utf8sp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 17: {
                            tvp.getValue((IPointable)this.tp.timep);
                            this.aOp.convertTime(this.tp.timep, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 36: {
                            tvp.getValue((IPointable)this.tp.shortp);
                            this.aOp.convertShort(this.tp.shortp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 34: {
                            tvp.getValue((IPointable)this.tp.longp);
                            this.aOp.convertUnsignedInt(this.tp.longp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 33: {
                            tvp.getValue((IPointable)this.tp.longp);
                            this.aOp.convertUnsignedLong(this.tp.longp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 35: {
                            tvp.getValue((IPointable)this.tp.intp);
                            this.aOp.convertUnsignedShort(this.tp.intp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 14: {
                            tvp.getValue((IPointable)this.tp.utf8sp);
                            this.aOp.convertUntypedAtomic(this.tp.utf8sp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                        case 19: {
                            tvp.getValue((IPointable)this.tp.intp);
                            this.aOp.convertYMDuration(this.tp.intp, this.dOut);
                            result.set((IValueReference)this.abvs);
                            return;
                        }
                    }
                }
                catch (SystemException se) {
                    throw se;
                }
                catch (Exception e) {
                    throw new SystemException(ErrorCode.SYSE0001, (Throwable)e);
                }
                throw new SystemException(ErrorCode.XPTY0004);
            }

            @Override
            protected void setSequenceType(SequenceType sType) {
                this.aOp = sType.getItemType() == BuiltinTypeRegistry.XS_ANY_URI ? new CastableAsAnyURIOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_BASE64_BINARY ? new CastableAsBase64BinaryOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_BOOLEAN ? new CastableAsBooleanOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_BYTE ? new CastableAsByteOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_DATE ? new CastableAsDateOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_DATETIME ? new CastableAsDateTimeOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_DAY_TIME_DURATION ? new CastableAsDTDurationOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_DECIMAL ? new CastableAsDecimalOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_DOUBLE ? new CastableAsDoubleOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_DURATION ? new CastableAsDurationOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_FLOAT ? new CastableAsFloatOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_G_DAY ? new CastableAsGDayOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_G_MONTH ? new CastableAsGMonthOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_G_MONTH_DAY ? new CastableAsGMonthDayOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_G_YEAR ? new CastableAsGYearOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_G_YEAR_MONTH ? new CastableAsGYearMonthOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_HEX_BINARY ? new CastableAsHexBinaryOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_INT ? new CastableAsIntOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_INTEGER ? new CastableAsIntegerOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_LONG ? new CastableAsLongOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_NEGATIVE_INTEGER ? new CastableAsNegativeIntegerOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_NON_NEGATIVE_INTEGER ? new CastableAsNonNegativeIntegerOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_NON_POSITIVE_INTEGER ? new CastableAsNonPositiveIntegerOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_NOTATION ? new CastableAsNotationOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_QNAME ? new CastableAsQNameOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_SHORT ? new CastableAsShortOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_STRING ? new CastableAsStringOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_TIME ? new CastableAsTimeOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_UNSIGNED_BYTE ? new CastableAsUnsignedByteOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_UNSIGNED_INT ? new CastableAsUnsignedIntOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_UNSIGNED_LONG ? new CastableAsUnsignedLongOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_UNSIGNED_SHORT ? new CastableAsUnsignedShortOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_UNTYPED_ATOMIC ? new CastableAsUntypedAtomicOperation() : (sType.getItemType() == BuiltinTypeRegistry.XS_YEAR_MONTH_DURATION ? new CastableAsYMDurationOperation() : new CastableAsUntypedAtomicOperation())))))))))))))))))))))))))))))))));
            }
        };
    }
}

