/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.cast;

import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.atomic.XSDateTimePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSTimePointable;
import org.apache.vxquery.datamodel.util.DateTime;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.cast.AbstractCastToOperation;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;

public class CastToTimeOperation
extends AbstractCastToOperation {
    @Override
    public void convertDatetime(XSDateTimePointable datetimep, DataOutput dOut) throws SystemException, IOException {
        dOut.write(17);
        dOut.write((byte)datetimep.getHour());
        dOut.write((byte)datetimep.getMinute());
        dOut.writeInt((int)datetimep.getMilliSecond());
        dOut.write((byte)datetimep.getTimezoneHour());
        dOut.write((byte)datetimep.getTimezoneMinute());
    }

    @Override
    public void convertString(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        char c;
        UTF8StringCharacterIterator charIterator = new UTF8StringCharacterIterator(stringp);
        charIterator.reset();
        int index = 0;
        long[] date = new long[5];
        boolean positiveTimezone = false;
        boolean pastDecimal = false;
        int decimalPlace = 3;
        date[3] = 127L;
        date[4] = 127L;
        while ((c = charIterator.next()) != '\u0000') {
            if (Character.isDigit((int)c)) {
                date[index] = date[index] * 10L + (long)Character.getNumericValue((int)c);
                if (!pastDecimal) continue;
                decimalPlace = (byte)(decimalPlace - 1);
                continue;
            }
            if (c == Character.valueOf('-').charValue() || c == Character.valueOf(':').charValue()) {
                pastDecimal = false;
                date[++index] = 0L;
                continue;
            }
            if (c == Character.valueOf('+').charValue()) {
                pastDecimal = false;
                date[++index] = 0L;
                positiveTimezone = true;
                continue;
            }
            if (c == Character.valueOf('.').charValue()) {
                pastDecimal = true;
                continue;
            }
            if (c == Character.valueOf('Z').charValue()) {
                date[3] = 0L;
                date[4] = 0L;
                continue;
            }
            throw new SystemException(ErrorCode.FORG0001);
        }
        date[2] = (long)((double)date[2] * Math.pow(10.0, decimalPlace));
        if (!positiveTimezone && date[3] != 127L) {
            date[3] = date[3] * -1L;
        }
        if (!positiveTimezone && date[4] != 127L) {
            date[4] = date[4] * -1L;
        }
        if (date[0] == 24L) {
            date[0] = 0L;
        }
        if (!DateTime.valid(1972L, 12L, 31L, date[0], date[1], date[2], date[3], date[4])) {
            throw new SystemException(ErrorCode.FORG0001);
        }
        dOut.write(17);
        dOut.write((byte)date[0]);
        dOut.write((byte)date[1]);
        dOut.writeInt((int)date[2]);
        dOut.write((byte)date[3]);
        dOut.write((byte)date[4]);
    }

    @Override
    public void convertTime(XSTimePointable timep, DataOutput dOut) throws SystemException, IOException {
        dOut.write(17);
        dOut.write(timep.getByteArray(), timep.getStartOffset(), timep.getLength());
    }

    @Override
    public void convertUntypedAtomic(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }
}

