/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.cast;

import edu.uci.ics.hyracks.data.std.primitive.BooleanPointable;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.FloatPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.primitive.ShortPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import edu.uci.ics.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.vxquery.datamodel.accessors.atomic.XSBinaryPointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDatePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDateTimePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDecimalPointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDurationPointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSQNamePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSTimePointable;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.cast.AbstractCastToOperation;
import org.apache.vxquery.runtime.functions.cast.CastToDecimalOperation;
import org.apache.vxquery.runtime.functions.util.FunctionHelper;

public class CastToStringOperation
extends AbstractCastToOperation {
    private ByteArrayAccessibleOutputStream baaos = new ByteArrayAccessibleOutputStream();
    private ArrayBackedValueStorage abvsInner = new ArrayBackedValueStorage();
    private DataOutput dOutInner = this.abvsInner.getDataOutput();
    int returnTag = 4;
    private final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int DOUBLE_MANTISSA_BITS = 52;
    private static final int DOUBLE_MANTISSA_OFFSET = -1075;
    private static final int DOUBLE_EXPONENT_MAX = 1023;
    private static final int DOUBLE_EXPONENT_MIN = -1022;
    private static final int FLOAT_MANTISSA_BITS = 23;
    private static final int FLOAT_MANTISSA_OFFSET = -150;
    private static final int FLOAT_EXPONENT_MAX = 127;
    private static final int FLOAT_EXPONENT_MIN = -126;
    private static final int b = 2;
    private static final int B = 10;

    @Override
    public void convertAnyURI(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(this.returnTag);
        dOut.write(stringp.getByteArray(), stringp.getStartOffset(), stringp.getLength());
    }

    @Override
    public void convertBase64Binary(XSBinaryPointable binaryp, DataOutput dOut) throws SystemException, IOException {
        this.baaos.reset();
        Base64OutputStream b64os = new Base64OutputStream((OutputStream)this.baaos, true);
        b64os.write(binaryp.getByteArray(), binaryp.getStartOffset() + 2, binaryp.getLength() - 2);
        dOut.write(this.returnTag);
        dOut.write((byte)(this.baaos.size() >>> 8 & 0xFF));
        dOut.write((byte)(this.baaos.size() >>> 0 & 0xFF));
        dOut.write(this.baaos.getByteArray(), 0, this.baaos.size());
    }

    @Override
    public void convertBoolean(BooleanPointable boolp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        if (boolp.getBoolean()) {
            FunctionHelper.writeCharSequence("true", this.dOutInner);
        } else {
            FunctionHelper.writeCharSequence("false", this.dOutInner);
        }
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertDate(XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeDateAsString(datep, this.dOutInner);
        FunctionHelper.writeTimezoneAsString(datep, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertDatetime(XSDateTimePointable datetimep, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeDateAsString(datetimep, this.dOutInner);
        FunctionHelper.writeChar('T', this.dOutInner);
        FunctionHelper.writeTimeAsString(datetimep, this.dOutInner);
        FunctionHelper.writeTimezoneAsString(datetimep, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertDecimal(XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        byte decimalPlace = decp.getDecimalPlace();
        long value = decp.getDecimalValue();
        byte nDigits = decp.getDigitCount();
        if (!FunctionHelper.isNumberPostive(value)) {
            FunctionHelper.writeChar('-', this.dOutInner);
            value *= -1L;
        }
        if (value == 0L) {
            FunctionHelper.writeChar('0', this.dOutInner);
        } else {
            long pow10 = (long)Math.pow(10.0, nDigits - 1);
            int start = Math.max(decimalPlace, nDigits - 1);
            int end = Math.min(0, decimalPlace);
            for (int i = start; i >= end; --i) {
                if (i >= nDigits || i < 0) {
                    FunctionHelper.writeChar('0', this.dOutInner);
                } else {
                    FunctionHelper.writeChar((char)(48L + value / pow10), this.dOutInner);
                    value %= pow10;
                    pow10 /= 10L;
                }
                if (i != decimalPlace || value <= 0L) continue;
                FunctionHelper.writeChar('.', this.dOutInner);
            }
        }
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertDouble(DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        double value = doublep.getDouble();
        if (!Double.isInfinite(value) && !Double.isNaN(value) && Math.abs(value) >= 1.0E-6 && Math.abs(value) <= 1000000.0) {
            CastToDecimalOperation castToDecimal = new CastToDecimalOperation();
            castToDecimal.convertDouble(doublep, this.dOutInner);
            XSDecimalPointable decp = (XSDecimalPointable)XSDecimalPointable.FACTORY.createPointable();
            decp.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset() + 1, XSDecimalPointable.TYPE_TRAITS.getFixedLength());
            this.convertDecimal(decp, dOut);
        } else if (value == -0.0 || value == 0.0) {
            boolean negative;
            long bits = Double.doubleToLongBits(value);
            boolean bl = negative = bits >> 63 != 0L;
            if (negative) {
                FunctionHelper.writeChar('-', this.dOutInner);
            }
            FunctionHelper.writeCharSequence("0", this.dOutInner);
            this.sendStringDataOutput(dOut);
        } else {
            this.convertDoubleCanonical(doublep, dOut);
        }
    }

    public void convertDoubleCanonical(DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        double value = doublep.getDouble();
        if (Double.isInfinite(value)) {
            if (value == Double.NEGATIVE_INFINITY) {
                FunctionHelper.writeCharSequence("-", this.dOutInner);
            }
            FunctionHelper.writeCharSequence("INF", this.dOutInner);
        } else if (Double.isNaN(value)) {
            FunctionHelper.writeCharSequence("NaN", this.dOutInner);
        } else {
            long bits = Double.doubleToLongBits(value);
            boolean decimalPlaced = false;
            boolean negative = bits >> 63 != 0L;
            int e = (int)(bits >> 52 & 0x7FFL);
            long f = e == 0 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            e += -1075;
            if (negative) {
                FunctionHelper.writeChar('-', this.dOutInner);
            }
            if (value == 0.0) {
                FunctionHelper.writeCharSequence("0.0E0", this.dOutInner);
            } else {
                double mMinus;
                double mPlus;
                double s;
                double r;
                if (e >= 0) {
                    if ((double)f == Math.pow(2.0, 51.0)) {
                        r = (double)f * Math.pow(2.0, e) * 2.0;
                        s = 2.0;
                        mPlus = Math.pow(2.0, e);
                        mMinus = Math.pow(2.0, e + 1);
                    } else {
                        r = (double)f * Math.pow(2.0, e + 1) * 2.0;
                        s = 4.0;
                        mPlus = Math.pow(2.0, e);
                        mMinus = Math.pow(2.0, e);
                    }
                } else if (e == -1022 || (double)f != Math.pow(2.0, 51.0)) {
                    r = (double)f * Math.pow(2.0, e) * 2.0;
                    s = 2.0;
                    mPlus = Math.pow(2.0, e);
                    mMinus = Math.pow(2.0, e + 1);
                } else {
                    r = (double)f * Math.pow(2.0, e + 1) * 2.0;
                    s = 4.0;
                    mPlus = Math.pow(2.0, e);
                    mMinus = Math.pow(2.0, e);
                }
                double k = Math.ceil(Math.log10((r + mPlus) / s));
                if (k >= 0.0) {
                    s *= Math.pow(10.0, k);
                } else {
                    r *= Math.pow(10.0, -k);
                    mPlus *= Math.pow(10.0, -k);
                    mMinus *= Math.pow(10.0, -k);
                }
                while (!(Double.isInfinite(mPlus) || Double.isNaN(mPlus) || Double.isInfinite(mMinus) || Double.isNaN(mMinus) || Double.isInfinite(r) || Double.isNaN(r))) {
                    double d = s == r ? 1.0 : Math.floor(r * 10.0 / s);
                    r = r * 10.0 % s;
                    mPlus *= 10.0;
                    if (r < (mMinus *= 10.0) && r + mPlus > s) {
                        if (r * 2.0 > s) {
                            d += 1.0;
                        }
                        FunctionHelper.writeChar((char)(48.0 + d), this.dOutInner);
                        break;
                    }
                    if (r + mPlus > s) {
                        FunctionHelper.writeChar((char)(48.0 + (d += 1.0)), this.dOutInner);
                        break;
                    }
                    if (r < mMinus) {
                        FunctionHelper.writeChar((char)(48.0 + d), this.dOutInner);
                        break;
                    }
                    FunctionHelper.writeChar((char)(48.0 + d), this.dOutInner);
                    if (decimalPlaced) continue;
                    decimalPlaced = true;
                    FunctionHelper.writeChar('.', this.dOutInner);
                }
                long decimalPlace = FunctionHelper.getPowerOf10(value, 1023L, -1022L) - 1L;
                FunctionHelper.writeChar('E', this.dOutInner);
                FunctionHelper.writeNumberWithPadding(decimalPlace, 1, this.dOutInner);
            }
        }
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertDTDuration(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        long dayTime = longp.getLong();
        if (dayTime == 0L) {
            FunctionHelper.writeCharSequence("PT0S", this.dOutInner);
        } else {
            if (dayTime < 0L) {
                FunctionHelper.writeChar('-', this.dOutInner);
                dayTime *= -1L;
            }
            FunctionHelper.writeChar('P', this.dOutInner);
            if (dayTime >= 86400000L) {
                FunctionHelper.writeNumberWithPadding(dayTime / 86400000L, 1, this.dOutInner);
                FunctionHelper.writeChar('D', this.dOutInner);
                dayTime %= 86400000L;
            }
            if (dayTime > 0L) {
                FunctionHelper.writeChar('T', this.dOutInner);
            }
            if (dayTime >= 3600000L) {
                FunctionHelper.writeNumberWithPadding(dayTime / 3600000L, 1, this.dOutInner);
                FunctionHelper.writeChar('H', this.dOutInner);
                dayTime %= 3600000L;
            }
            if (dayTime >= 60000L) {
                FunctionHelper.writeNumberWithPadding(dayTime / 60000L, 1, this.dOutInner);
                FunctionHelper.writeChar('M', this.dOutInner);
                dayTime %= 60000L;
            }
            if (dayTime > 0L) {
                FunctionHelper.writeNumberWithPadding(dayTime / 1000L, 1, this.dOutInner);
                if (dayTime % 1000L != 0L) {
                    FunctionHelper.writeChar('.', this.dOutInner);
                    FunctionHelper.writeNumberWithPadding(dayTime % 1000L, 3, this.dOutInner);
                }
                FunctionHelper.writeChar('S', this.dOutInner);
            }
        }
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertDuration(XSDurationPointable durationp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        int yearMonth = durationp.getYearMonth();
        long dayTime = durationp.getDayTime();
        if (yearMonth < 0 || dayTime < 0L) {
            FunctionHelper.writeChar('-', this.dOutInner);
            yearMonth *= -1;
            dayTime *= -1L;
        }
        FunctionHelper.writeChar('P', this.dOutInner);
        if (yearMonth >= 12) {
            FunctionHelper.writeNumberWithPadding(yearMonth / 12, 1, this.dOutInner);
            FunctionHelper.writeChar('Y', this.dOutInner);
        }
        if (yearMonth % 12 > 0) {
            FunctionHelper.writeNumberWithPadding(yearMonth % 12, 1, this.dOutInner);
            FunctionHelper.writeChar('M', this.dOutInner);
        }
        if (dayTime >= 86400000L) {
            FunctionHelper.writeNumberWithPadding(dayTime / 86400000L, 1, this.dOutInner);
            FunctionHelper.writeChar('D', this.dOutInner);
            dayTime %= 86400000L;
        }
        if (dayTime > 0L) {
            FunctionHelper.writeChar('T', this.dOutInner);
        }
        if (dayTime >= 3600000L) {
            FunctionHelper.writeNumberWithPadding(dayTime / 3600000L, 1, this.dOutInner);
            FunctionHelper.writeChar('H', this.dOutInner);
            dayTime %= 3600000L;
        }
        if (dayTime >= 60000L) {
            FunctionHelper.writeNumberWithPadding(dayTime / 60000L, 1, this.dOutInner);
            FunctionHelper.writeChar('M', this.dOutInner);
            dayTime %= 60000L;
        }
        if (dayTime > 0L) {
            FunctionHelper.writeNumberWithPadding(dayTime / 1000L, 1, this.dOutInner);
            if (dayTime % 1000L != 0L) {
                FunctionHelper.writeChar('.', this.dOutInner);
                FunctionHelper.writeNumberWithPadding(dayTime % 1000L, 3, this.dOutInner);
            }
            FunctionHelper.writeChar('S', this.dOutInner);
        }
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertFloat(FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        float value = floatp.getFloat();
        if (!Float.isInfinite(value) && !Float.isNaN(value) && (double)Math.abs(value) >= 1.0E-6 && Math.abs(value) <= 1000000.0f) {
            CastToDecimalOperation castToDecimal = new CastToDecimalOperation();
            castToDecimal.convertFloat(floatp, this.dOutInner);
            XSDecimalPointable decp = (XSDecimalPointable)XSDecimalPointable.FACTORY.createPointable();
            decp.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset() + 1, this.abvsInner.getLength());
            this.convertDecimal(decp, dOut);
        } else if (value == -0.0f || value == 0.0f) {
            boolean negative;
            long bits = Float.floatToIntBits(value);
            boolean bl = negative = bits >> 31 != 0L;
            if (negative) {
                FunctionHelper.writeChar('-', this.dOutInner);
            }
            FunctionHelper.writeCharSequence("0", this.dOutInner);
            this.sendStringDataOutput(dOut);
        } else {
            this.convertFloatCanonical(floatp, dOut);
        }
    }

    public void convertFloatCanonical(FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        float value = floatp.getFloat();
        if (Float.isInfinite(value)) {
            if (value == Float.NEGATIVE_INFINITY) {
                FunctionHelper.writeCharSequence("-", this.dOutInner);
            }
            FunctionHelper.writeCharSequence("INF", this.dOutInner);
        } else if (Float.isNaN(value)) {
            FunctionHelper.writeCharSequence("NaN", this.dOutInner);
        } else {
            long bits = Float.floatToIntBits(value);
            boolean decimalPlaced = false;
            boolean negative = bits >> 31 != 0L;
            int e = (int)(bits >> 23 & 0xFFL);
            int f = (int)(e == 0 ? (bits & 0x7FFFFFL) << 1 : bits & 0x7FFFFFL | 0x800000L);
            e += -150;
            if (negative) {
                FunctionHelper.writeChar('-', this.dOutInner);
            }
            if (value == 0.0f) {
                FunctionHelper.writeCharSequence("0.0E0", this.dOutInner);
            } else {
                double mMinus;
                double mPlus;
                double s;
                double r;
                if (e >= 0) {
                    if ((double)f == Math.pow(2.0, 22.0)) {
                        r = (double)f * Math.pow(2.0, e) * 2.0;
                        s = 2.0;
                        mPlus = Math.pow(2.0, e);
                        mMinus = Math.pow(2.0, e + 1);
                    } else {
                        r = (double)f * Math.pow(2.0, e + 1) * 2.0;
                        s = 4.0;
                        mPlus = Math.pow(2.0, e);
                        mMinus = Math.pow(2.0, e);
                    }
                } else if (e == -126 || (double)f != Math.pow(2.0, 22.0)) {
                    r = (double)f * Math.pow(2.0, e) * 2.0;
                    s = 2.0;
                    mPlus = Math.pow(2.0, e);
                    mMinus = Math.pow(2.0, e + 1);
                } else {
                    r = (double)f * Math.pow(2.0, e + 1) * 2.0;
                    s = 4.0;
                    mPlus = Math.pow(2.0, e);
                    mMinus = Math.pow(2.0, e);
                }
                double k = Math.ceil(Math.log10((r + mPlus) / s));
                if (k >= 0.0) {
                    s *= Math.pow(10.0, k);
                } else {
                    r *= Math.pow(10.0, -k);
                    mPlus *= Math.pow(10.0, -k);
                    mMinus *= Math.pow(10.0, -k);
                }
                while (!(Double.isInfinite(mPlus) || Double.isNaN(mPlus) || Double.isInfinite(mMinus) || Double.isNaN(mMinus))) {
                    double d = s == r ? 1.0 : Math.floor(r * 10.0 / s);
                    r = r * 10.0 % s;
                    mPlus *= 10.0;
                    if (r < (mMinus *= 10.0) && r + mPlus > s) {
                        if (r * 2.0 > s) {
                            d += 1.0;
                        }
                        FunctionHelper.writeChar((char)(48.0 + d), this.dOutInner);
                        break;
                    }
                    if (r + mPlus > s) {
                        FunctionHelper.writeChar((char)(48.0 + (d += 1.0)), this.dOutInner);
                        break;
                    }
                    if (r < mMinus) {
                        FunctionHelper.writeChar((char)(48.0 + d), this.dOutInner);
                        break;
                    }
                    FunctionHelper.writeChar((char)(48.0 + d), this.dOutInner);
                    if (decimalPlaced) continue;
                    decimalPlaced = true;
                    FunctionHelper.writeChar('.', this.dOutInner);
                }
                long decimalPlace = FunctionHelper.getPowerOf10(value, 127L, -126L) - 1L;
                FunctionHelper.writeChar('E', this.dOutInner);
                FunctionHelper.writeNumberWithPadding(decimalPlace, 1, this.dOutInner);
            }
        }
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertGDay(XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeChar('-', this.dOutInner);
        FunctionHelper.writeChar('-', this.dOutInner);
        FunctionHelper.writeChar('-', this.dOutInner);
        FunctionHelper.writeNumberWithPadding(datep.getDay(), 2, this.dOutInner);
        FunctionHelper.writeTimezoneAsString(datep, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertGMonth(XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeChar('-', this.dOutInner);
        FunctionHelper.writeChar('-', this.dOutInner);
        FunctionHelper.writeNumberWithPadding(datep.getMonth(), 2, this.dOutInner);
        FunctionHelper.writeTimezoneAsString(datep, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertGMonthDay(XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeChar('-', this.dOutInner);
        FunctionHelper.writeChar('-', this.dOutInner);
        FunctionHelper.writeNumberWithPadding(datep.getMonth(), 2, this.dOutInner);
        FunctionHelper.writeChar('-', this.dOutInner);
        FunctionHelper.writeNumberWithPadding(datep.getDay(), 2, this.dOutInner);
        FunctionHelper.writeTimezoneAsString(datep, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertGYear(XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(datep.getYear(), 4, this.dOutInner);
        FunctionHelper.writeTimezoneAsString(datep, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertGYearMonth(XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(datep.getYear(), 4, this.dOutInner);
        FunctionHelper.writeChar('-', this.dOutInner);
        FunctionHelper.writeNumberWithPadding(datep.getMonth(), 2, this.dOutInner);
        FunctionHelper.writeTimezoneAsString(datep, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertHexBinary(XSBinaryPointable binaryp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        for (int index = 0; index < binaryp.getBinaryLength(); ++index) {
            int bi = binaryp.getByteArray()[binaryp.getBinaryStart() + index] & 0xFF;
            FunctionHelper.writeChar(this.hex[bi >> 4], this.dOutInner);
            FunctionHelper.writeChar(this.hex[bi & 0xF], this.dOutInner);
        }
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(longp.getLong(), 1, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertNotation(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(this.returnTag);
        dOut.write(stringp.getByteArray(), stringp.getStartOffset(), stringp.getLength());
    }

    @Override
    public void convertQName(XSQNamePointable qnamep, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        if (qnamep.getPrefixUTFLength() > 0) {
            this.dOutInner.write(qnamep.getByteArray(), qnamep.getStartOffset() + qnamep.getUriLength() + 2, qnamep.getPrefixUTFLength());
            FunctionHelper.writeChar(':', this.dOutInner);
        }
        this.dOutInner.write(qnamep.getByteArray(), qnamep.getStartOffset() + qnamep.getUriLength() + qnamep.getPrefixLength() + 2, qnamep.getLocalNameUTFLength());
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertString(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(this.returnTag);
        dOut.write(stringp.getByteArray(), stringp.getStartOffset(), stringp.getLength());
    }

    @Override
    public void convertTime(XSTimePointable timep, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeTimeAsString(timep, this.dOutInner);
        FunctionHelper.writeTimezoneAsString(timep, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertUntypedAtomic(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }

    @Override
    public void convertYMDuration(IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        int yearMonth = intp.getInteger();
        if (yearMonth == 0) {
            FunctionHelper.writeCharSequence("P0M", this.dOutInner);
        } else {
            if (yearMonth < 0) {
                FunctionHelper.writeChar('-', this.dOutInner);
                yearMonth *= -1;
            }
            FunctionHelper.writeChar('P', this.dOutInner);
            if (yearMonth >= 12) {
                FunctionHelper.writeNumberWithPadding(yearMonth / 12, 1, this.dOutInner);
                FunctionHelper.writeChar('Y', this.dOutInner);
            }
            if (yearMonth % 12 > 0) {
                FunctionHelper.writeNumberWithPadding(yearMonth % 12, 1, this.dOutInner);
                FunctionHelper.writeChar('M', this.dOutInner);
            }
        }
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertByte(BytePointable bytep, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(bytep.longValue(), 1, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertInt(IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(intp.longValue(), 1, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertLong(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(longp.longValue(), 1, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertNegativeInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(longp.longValue(), 1, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertNonNegativeInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(longp.longValue(), 1, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertNonPositiveInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(longp.longValue(), 1, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertPositiveInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(longp.longValue(), 1, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertShort(ShortPointable shortp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(shortp.longValue(), 1, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertUnsignedByte(ShortPointable shortp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(shortp.longValue(), 1, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertUnsignedInt(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(longp.longValue(), 1, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertUnsignedLong(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(longp.longValue(), 1, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertUnsignedShort(IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner.reset();
        FunctionHelper.writeNumberWithPadding(intp.longValue(), 1, this.dOutInner);
        this.sendStringDataOutput(dOut);
    }

    @Override
    public void convertEntity(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }

    @Override
    public void convertID(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }

    @Override
    public void convertIDREF(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }

    @Override
    public void convertLanguage(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }

    @Override
    public void convertName(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }

    @Override
    public void convertNCName(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }

    @Override
    public void convertNMToken(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }

    @Override
    public void convertNormalizedString(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }

    @Override
    public void convertToken(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }

    private void sendStringDataOutput(DataOutput dOut) throws SystemException, IOException {
        dOut.write(this.returnTag);
        dOut.write((byte)(this.abvsInner.getLength() >>> 8 & 0xFF));
        dOut.write((byte)(this.abvsInner.getLength() >>> 0 & 0xFF));
        dOut.write(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset(), this.abvsInner.getLength());
    }
}

