/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.cast;

import edu.uci.ics.hyracks.data.std.api.INumeric;
import edu.uci.ics.hyracks.data.std.primitive.BooleanPointable;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.FloatPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.primitive.ShortPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.atomic.XSDecimalPointable;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.cast.AbstractCastToOperation;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;

public class CastToIntegerOperation
extends AbstractCastToOperation {
    boolean negativeAllowed = true;
    boolean negativeRequired = false;
    int returnTag = 25;

    @Override
    public void convertBoolean(BooleanPointable boolp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(this.returnTag);
        dOut.writeLong(boolp.getBoolean() ? 1 : 0);
    }

    @Override
    public void convertDecimal(XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        this.writeIntegerValue(decp, dOut);
    }

    @Override
    public void convertDouble(DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        double doubleValue = doublep.getDouble();
        if (Double.isInfinite(doubleValue) || Double.isNaN(doubleValue)) {
            throw new SystemException(ErrorCode.FOCA0002);
        }
        if (doubleValue > 9.223372036854776E18 || doubleValue < -9.223372036854776E18) {
            throw new SystemException(ErrorCode.FOCA0003);
        }
        if (doublep.longValue() < 0L && !this.negativeAllowed || doublep.longValue() > 0L && this.negativeRequired) {
            throw new SystemException(ErrorCode.FORG0001);
        }
        dOut.write(this.returnTag);
        dOut.writeLong(doublep.longValue());
    }

    @Override
    public void convertFloat(FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        float floatValue = floatp.getFloat();
        if (Float.isInfinite(floatValue) || Float.isNaN(floatValue)) {
            throw new SystemException(ErrorCode.FOCA0002);
        }
        if (floatValue > 9.223372E18f || floatValue < -9.223372E18f) {
            throw new SystemException(ErrorCode.FOCA0003);
        }
        if (floatp.longValue() < 0L && !this.negativeAllowed || floatp.longValue() > 0L && this.negativeRequired) {
            throw new SystemException(ErrorCode.FORG0001);
        }
        dOut.write(this.returnTag);
        dOut.writeLong(floatp.longValue());
    }

    @Override
    public void convertInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeIntegerValue((INumeric)longp, dOut);
    }

    @Override
    public void convertString(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        UTF8StringCharacterIterator charIterator = new UTF8StringCharacterIterator(stringp);
        charIterator.reset();
        long value = 0L;
        char c = '\u0000';
        boolean negative = false;
        long limit = -9223372036854775807L;
        c = charIterator.next();
        if (c == Character.valueOf('-').charValue() && this.negativeAllowed) {
            negative = true;
            c = charIterator.next();
            limit = Long.MIN_VALUE;
        }
        do {
            if (Character.isDigit((int)c)) {
                if (value < limit + (long)Character.getNumericValue((int)c)) {
                    throw new SystemException(ErrorCode.FORG0001);
                }
            } else {
                throw new SystemException(ErrorCode.FORG0001);
            }
            value = value * 10L - (long)Character.getNumericValue((int)c);
        } while ((c = charIterator.next()) != '\u0000');
        if (this.negativeRequired && value != 0L && !negative) {
            throw new SystemException(ErrorCode.FORG0001);
        }
        dOut.write(this.returnTag);
        dOut.writeLong(negative ? value : -value);
    }

    @Override
    public void convertUntypedAtomic(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }

    @Override
    public void convertByte(BytePointable bytep, DataOutput dOut) throws SystemException, IOException {
        this.writeIntegerValue((INumeric)bytep, dOut);
    }

    @Override
    public void convertInt(IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.writeIntegerValue((INumeric)intp, dOut);
    }

    @Override
    public void convertLong(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeIntegerValue((INumeric)longp, dOut);
    }

    @Override
    public void convertNegativeInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeIntegerValue((INumeric)longp, dOut);
    }

    @Override
    public void convertNonNegativeInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeIntegerValue((INumeric)longp, dOut);
    }

    @Override
    public void convertNonPositiveInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeIntegerValue((INumeric)longp, dOut);
    }

    @Override
    public void convertPositiveInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeIntegerValue((INumeric)longp, dOut);
    }

    @Override
    public void convertShort(ShortPointable shortp, DataOutput dOut) throws SystemException, IOException {
        this.writeIntegerValue((INumeric)shortp, dOut);
    }

    @Override
    public void convertUnsignedByte(ShortPointable shortp, DataOutput dOut) throws SystemException, IOException {
        this.writeIntegerValue((INumeric)shortp, dOut);
    }

    @Override
    public void convertUnsignedInt(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeIntegerValue((INumeric)longp, dOut);
    }

    @Override
    public void convertUnsignedLong(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeIntegerValue((INumeric)longp, dOut);
    }

    @Override
    public void convertUnsignedShort(IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.writeIntegerValue((INumeric)intp, dOut);
    }

    private void writeIntegerValue(INumeric numericp, DataOutput dOut) throws SystemException, IOException {
        if (numericp.longValue() < 0L && !this.negativeAllowed || numericp.longValue() > 0L && this.negativeRequired) {
            throw new SystemException(ErrorCode.FORG0001);
        }
        dOut.write(this.returnTag);
        dOut.writeLong(numericp.longValue());
    }
}

