/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.cast;

import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.atomic.XSBinaryPointable;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.cast.AbstractCastToOperation;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;

public class CastToHexBinaryOperation
extends AbstractCastToOperation {
    private ArrayBackedValueStorage abvsInner = new ArrayBackedValueStorage();
    private DataOutput dOutInner = this.abvsInner.getDataOutput();

    @Override
    public void convertBase64Binary(XSBinaryPointable binaryp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(45);
        dOut.write(binaryp.getByteArray(), binaryp.getStartOffset(), binaryp.getLength());
    }

    @Override
    public void convertHexBinary(XSBinaryPointable binaryp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(45);
        dOut.write(binaryp.getByteArray(), binaryp.getStartOffset(), binaryp.getLength());
    }

    @Override
    public void convertString(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        UTF8StringCharacterIterator charIterator = new UTF8StringCharacterIterator(stringp);
        charIterator.reset();
        this.abvsInner.reset();
        char c1 = '\u0000';
        char c2 = '\u0000';
        int length = 0;
        while ((c1 = charIterator.next()) != '\u0000') {
            c2 = charIterator.next();
            if (c2 == '\u0000') {
                throw new SystemException(ErrorCode.FORG0001);
            }
            if (Character.digit((int)c1, 16) < 0 || Character.digit((int)c1, 16) > 15 || Character.digit((int)c2, 16) < 0 || Character.digit((int)c2, 16) > 15) {
                throw new SystemException(ErrorCode.FORG0001);
            }
            this.dOutInner.write((Character.digit((int)c1, 16) << 4) + Character.digit((int)c2, 16));
            ++length;
        }
        dOut.write(45);
        dOut.write((byte)(length >>> 8 & 0xFF));
        dOut.write((byte)(length >>> 0 & 0xFF));
        dOut.write(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset(), length);
    }

    @Override
    public void convertUntypedAtomic(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }
}

