/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.cast;

import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.atomic.XSDatePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDateTimePointable;
import org.apache.vxquery.datamodel.util.DateTime;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.cast.AbstractCastToOperation;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;

public class CastToGMonthOperation
extends AbstractCastToOperation {
    @Override
    public void convertDate(XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        dOut.write(42);
        dOut.writeShort(1972);
        dOut.write((byte)datep.getMonth());
        dOut.write(29);
        dOut.write((byte)datep.getTimezoneHour());
        dOut.write((byte)datep.getTimezoneMinute());
    }

    @Override
    public void convertDatetime(XSDateTimePointable datetimep, DataOutput dOut) throws SystemException, IOException {
        dOut.write(42);
        dOut.writeShort(1972);
        dOut.write((byte)datetimep.getMonth());
        dOut.write(29);
        dOut.write((byte)datetimep.getTimezoneHour());
        dOut.write((byte)datetimep.getTimezoneMinute());
    }

    @Override
    public void convertGMonth(XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        dOut.write(42);
        dOut.write(datep.getByteArray(), datep.getStartOffset(), datep.getLength());
    }

    @Override
    public void convertString(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        char c;
        UTF8StringCharacterIterator charIterator = new UTF8StringCharacterIterator(stringp);
        charIterator.reset();
        int index = 0;
        long[] date = new long[5];
        boolean positiveTimezone = false;
        date[3] = 127L;
        date[4] = 127L;
        while ((c = charIterator.next()) != '\u0000') {
            if (Character.isDigit((int)c)) {
                date[index] = date[index] * 10L + (long)Character.getNumericValue((int)c);
                continue;
            }
            if (c == Character.valueOf('-').charValue() || c == Character.valueOf(':').charValue()) {
                date[++index] = 0L;
                continue;
            }
            if (c == Character.valueOf('+').charValue()) {
                date[++index] = 0L;
                positiveTimezone = true;
                continue;
            }
            if (c == Character.valueOf('Z').charValue()) {
                date[3] = 0L;
                date[4] = 0L;
                continue;
            }
            throw new SystemException(ErrorCode.FORG0001);
        }
        if (!positiveTimezone && date[3] != 127L) {
            date[3] = date[3] * -1L;
        }
        if (!positiveTimezone && date[4] != 127L) {
            date[4] = date[4] * -1L;
        }
        if (!DateTime.valid(1972L, date[2], 29L, 0L, 0L, 0L, date[3], date[4])) {
            throw new SystemException(ErrorCode.FODT0001);
        }
        dOut.write(42);
        dOut.writeShort(1972);
        dOut.write((byte)date[2]);
        dOut.write(29);
        dOut.write((byte)date[3]);
        dOut.write((byte)date[4]);
    }

    @Override
    public void convertUntypedAtomic(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }
}

