/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.cast;

import edu.uci.ics.hyracks.data.std.api.INumeric;
import edu.uci.ics.hyracks.data.std.primitive.BooleanPointable;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.FloatPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.primitive.ShortPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.atomic.XSDecimalPointable;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.cast.AbstractCastToOperation;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;

public class CastToFloatOperation
extends AbstractCastToOperation {
    private static final float[] powersOf10upTo10 = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
    private static final float[] powersOf10from20to30 = new float[]{1.0E20f, 1.0E21f, 1.0E22f, 1.0E23f, 1.0E24f, 1.0E25f, 1.0E26f, 1.0E27f, 1.0E28f, 1.0E29f, 1.0E30f};

    @Override
    public void convertBoolean(BooleanPointable boolp, DataOutput dOut) throws SystemException, IOException {
        float value = boolp.getBoolean() ? 1 : 0;
        dOut.write(22);
        dOut.writeFloat(value);
    }

    @Override
    public void convertDecimal(XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        float value = decp.floatValue();
        dOut.write(22);
        dOut.writeFloat(value);
    }

    @Override
    public void convertDouble(DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        float value = doublep.floatValue();
        dOut.write(22);
        dOut.writeFloat(value);
    }

    @Override
    public void convertFloat(FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(22);
        dOut.write(floatp.getByteArray(), floatp.getStartOffset(), floatp.getLength());
    }

    @Override
    public void convertInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        float value = longp.floatValue();
        dOut.write(22);
        dOut.writeFloat(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void convertString(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        float valueFloat;
        UTF8StringCharacterIterator charIterator = new UTF8StringCharacterIterator(stringp);
        charIterator.reset();
        int decimalPlace = 0;
        long value = 0L;
        boolean pastDecimal = false;
        boolean negativeValue = false;
        char c = '\u0000';
        char c2 = '\u0000';
        char c3 = '\u0000';
        c = charIterator.next();
        if (c == Character.valueOf('-').charValue()) {
            negativeValue = true;
            c = charIterator.next();
        }
        if (c == Character.valueOf('I').charValue() || c == Character.valueOf('N').charValue()) {
            c2 = charIterator.next();
            c3 = charIterator.next();
            if (charIterator.next() != '\u0000') {
                throw new SystemException(ErrorCode.FORG0001);
            }
            if (c == Character.valueOf('I').charValue() && c2 == Character.valueOf('N').charValue() && c3 == Character.valueOf('F').charValue()) {
                valueFloat = Float.NEGATIVE_INFINITY;
            } else {
                if (c != Character.valueOf('N').charValue() || c2 != Character.valueOf('a').charValue() || c3 != Character.valueOf('N').charValue()) throw new SystemException(ErrorCode.FORG0001);
                valueFloat = Float.NaN;
            }
        } else {
            do {
                if (Character.isDigit((int)c)) {
                    value = value * 10L - (long)Character.getNumericValue((int)c);
                    if (!pastDecimal) continue;
                    decimalPlace = (byte)(decimalPlace - 1);
                    continue;
                }
                if (c == Character.valueOf('.').charValue() && !pastDecimal) {
                    pastDecimal = true;
                    continue;
                }
                if (c == Character.valueOf('E').charValue() || c == Character.valueOf('e').charValue()) break;
                throw new SystemException(ErrorCode.FORG0001);
            } while ((c = charIterator.next()) != '\u0000');
            if (c == Character.valueOf('E').charValue() || c == Character.valueOf('e').charValue()) {
                int moveOffset = 0;
                boolean negativeOffset = false;
                c = charIterator.next();
                if (c == Character.valueOf('-').charValue()) {
                    negativeOffset = true;
                    c = charIterator.next();
                }
                do {
                    if (!Character.isDigit((int)c)) {
                        throw new SystemException(ErrorCode.FORG0001);
                    }
                    moveOffset = moveOffset * 10 + Character.getNumericValue((int)c);
                } while ((c = charIterator.next()) != '\u0000');
                decimalPlace = (byte)(decimalPlace + (negativeOffset ? -moveOffset : moveOffset));
            }
            valueFloat = value;
            if (decimalPlace != 0 && valueFloat != 0.0f) {
                if (decimalPlace >= 0) {
                    if (decimalPlace <= 10) {
                        valueFloat *= powersOf10upTo10[decimalPlace];
                    } else if (decimalPlace <= 20) {
                        valueFloat *= powersOf10upTo10[10];
                        valueFloat *= powersOf10upTo10[decimalPlace - 10];
                    } else if (decimalPlace <= 30) {
                        valueFloat *= powersOf10from20to30[decimalPlace];
                    } else if (decimalPlace <= 38) {
                        valueFloat *= powersOf10from20to30[10];
                        valueFloat *= powersOf10upTo10[decimalPlace - 30];
                    }
                } else if (decimalPlace >= -10) {
                    valueFloat /= powersOf10upTo10[-decimalPlace];
                } else if (decimalPlace >= -20) {
                    valueFloat /= powersOf10upTo10[10];
                    valueFloat /= powersOf10upTo10[-decimalPlace - 10];
                } else if (decimalPlace >= -30) {
                    valueFloat /= powersOf10from20to30[-decimalPlace];
                } else if (decimalPlace >= -40) {
                    valueFloat /= powersOf10from20to30[10];
                    valueFloat /= powersOf10upTo10[-decimalPlace - 30];
                } else if (decimalPlace >= -45) {
                    valueFloat /= powersOf10from20to30[0];
                    valueFloat /= powersOf10from20to30[-decimalPlace - 20];
                }
            }
        }
        dOut.write(22);
        if (valueFloat == 0.0f) {
            dOut.writeFloat(negativeValue ? -0.0f : 0.0f);
            return;
        } else {
            dOut.writeFloat(negativeValue ? valueFloat : -valueFloat);
        }
    }

    @Override
    public void convertUntypedAtomic(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }

    @Override
    public void convertByte(BytePointable bytep, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)bytep, dOut);
    }

    @Override
    public void convertInt(IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)intp, dOut);
    }

    @Override
    public void convertLong(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)longp, dOut);
    }

    @Override
    public void convertNegativeInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)longp, dOut);
    }

    @Override
    public void convertNonNegativeInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)longp, dOut);
    }

    @Override
    public void convertNonPositiveInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)longp, dOut);
    }

    @Override
    public void convertPositiveInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)longp, dOut);
    }

    @Override
    public void convertShort(ShortPointable shortp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)shortp, dOut);
    }

    @Override
    public void convertUnsignedByte(ShortPointable shortp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)shortp, dOut);
    }

    @Override
    public void convertUnsignedInt(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)longp, dOut);
    }

    @Override
    public void convertUnsignedLong(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)longp, dOut);
    }

    @Override
    public void convertUnsignedShort(IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)intp, dOut);
    }

    private void writeDoubleValue(INumeric numericp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(22);
        dOut.writeFloat(numericp.floatValue());
    }
}

