/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.cast;

import edu.uci.ics.hyracks.data.std.api.INumeric;
import edu.uci.ics.hyracks.data.std.primitive.BooleanPointable;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.FloatPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.primitive.ShortPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.atomic.XSDecimalPointable;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.cast.AbstractCastToOperation;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;

public class CastToDoubleOperation
extends AbstractCastToOperation {
    private static final double[] powersOf10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final double[] powersOf2 = new double[]{1.0E16, 1.0E32f, 1.0E64, 1.0E128, 1.0E256};

    @Override
    public void convertBoolean(BooleanPointable boolp, DataOutput dOut) throws SystemException, IOException {
        double value = boolp.getBoolean() ? 1 : 0;
        dOut.write(23);
        dOut.writeDouble(value);
    }

    @Override
    public void convertDecimal(XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        double value = decp.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value);
    }

    @Override
    public void convertDouble(DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        dOut.write(23);
        dOut.write(doublep.getByteArray(), doublep.getStartOffset(), doublep.getLength());
    }

    @Override
    public void convertFloat(FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        double value = floatp.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value);
    }

    @Override
    public void convertInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        double value = longp.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void convertString(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        double valueDouble;
        UTF8StringCharacterIterator charIterator = new UTF8StringCharacterIterator(stringp);
        charIterator.reset();
        int decimalPlace = 0;
        long value = 0L;
        boolean pastDecimal = false;
        boolean negativeValue = false;
        char c = '\u0000';
        char c2 = '\u0000';
        char c3 = '\u0000';
        long limit = -9223372036854775807L;
        c = charIterator.next();
        if (c == Character.valueOf('-').charValue()) {
            negativeValue = true;
            c = charIterator.next();
            limit = Long.MIN_VALUE;
        }
        if (c == Character.valueOf('I').charValue() || c == Character.valueOf('N').charValue()) {
            c2 = charIterator.next();
            c3 = charIterator.next();
            if (charIterator.next() != '\u0000') {
                throw new SystemException(ErrorCode.FORG0001);
            }
            if (c == Character.valueOf('I').charValue() && c2 == Character.valueOf('N').charValue() && c3 == Character.valueOf('F').charValue()) {
                valueDouble = Double.NEGATIVE_INFINITY;
            } else {
                if (c != Character.valueOf('N').charValue() || c2 != Character.valueOf('a').charValue() || c3 != Character.valueOf('N').charValue()) throw new SystemException(ErrorCode.FORG0001);
                valueDouble = Double.NaN;
            }
        } else {
            do {
                if (Character.isDigit((int)c)) {
                    if (value < limit / 10L + (long)Character.getNumericValue((int)c)) {
                        throw new SystemException(ErrorCode.FOCA0006);
                    }
                    value = value * 10L - (long)Character.getNumericValue((int)c);
                    if (!pastDecimal) continue;
                    decimalPlace = (short)(decimalPlace - 1);
                    continue;
                }
                if (c == Character.valueOf('.').charValue() && !pastDecimal) {
                    pastDecimal = true;
                    continue;
                }
                if (c == Character.valueOf('E').charValue() || c == Character.valueOf('e').charValue()) break;
                throw new SystemException(ErrorCode.FORG0001);
            } while ((c = charIterator.next()) != '\u0000');
            if (c == Character.valueOf('E').charValue() || c == Character.valueOf('e').charValue()) {
                int moveOffset = 0;
                boolean negativeOffset = false;
                c = charIterator.next();
                if (c == Character.valueOf('-').charValue()) {
                    negativeOffset = true;
                    c = charIterator.next();
                }
                do {
                    if (!Character.isDigit((int)c)) {
                        throw new SystemException(ErrorCode.FORG0001);
                    }
                    moveOffset = moveOffset * 10 + Character.getNumericValue((int)c);
                } while ((c = charIterator.next()) != '\u0000');
                if (moveOffset > 324 || moveOffset < -324) {
                    throw new SystemException(ErrorCode.FOCA0006);
                }
                decimalPlace = (short)(decimalPlace + (negativeOffset ? -moveOffset : moveOffset));
            }
            valueDouble = value;
            if (decimalPlace != 0 && valueDouble != 0.0) {
                int j;
                if (decimalPlace >= 0) {
                    if (decimalPlace <= 16) {
                        valueDouble *= powersOf10[decimalPlace];
                    } else {
                        if ((decimalPlace & 0xF) != 0) {
                            valueDouble *= powersOf10[decimalPlace & 0xF];
                        }
                        short s = (short)(decimalPlace >> 4);
                        if (s != 0) {
                            j = 0;
                            for (decimalPlace = (int)(v36020); decimalPlace > 1; decimalPlace = (int)((short)(decimalPlace >> 1))) {
                                if ((decimalPlace & 1) != 0) {
                                    valueDouble *= powersOf2[j];
                                }
                                ++j;
                            }
                            double t = valueDouble * powersOf2[j];
                            if (Double.isInfinite(t)) {
                                t = valueDouble / 2.0;
                                if (Double.isInfinite(t *= powersOf2[j])) {
                                    valueDouble = Double.POSITIVE_INFINITY;
                                }
                                t = -1.7976931348623157E308;
                            }
                            valueDouble = t;
                        }
                    }
                } else if (decimalPlace >= -16) {
                    valueDouble /= powersOf10[-decimalPlace];
                } else {
                    if ((decimalPlace & 0xF) != 0) {
                        valueDouble /= powersOf10[decimalPlace & 0xF];
                    }
                    short s = (short)(decimalPlace >> 4);
                    if (s != 0) {
                        j = 0;
                        for (decimalPlace = (int)(v36086); decimalPlace > 1; decimalPlace = (int)((short)(decimalPlace >> 1))) {
                            if ((decimalPlace & 1) != 0) {
                                valueDouble /= powersOf2[j];
                            }
                            ++j;
                        }
                        double t = valueDouble / powersOf2[j];
                        if (t == 0.0) {
                            t = valueDouble * 2.0;
                            if ((t /= powersOf2[j]) == 0.0) {
                                valueDouble = 0.0;
                            }
                            t = Double.MIN_VALUE;
                        }
                        valueDouble = t;
                    }
                }
            }
        }
        dOut.write(23);
        if (valueDouble == 0.0) {
            dOut.writeDouble(negativeValue ? -0.0 : 0.0);
            return;
        } else {
            dOut.writeDouble(negativeValue ? valueDouble : -valueDouble);
        }
    }

    @Override
    public void convertUntypedAtomic(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }

    @Override
    public void convertByte(BytePointable bytep, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)bytep, dOut);
    }

    @Override
    public void convertInt(IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)intp, dOut);
    }

    @Override
    public void convertLong(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)longp, dOut);
    }

    @Override
    public void convertNegativeInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)longp, dOut);
    }

    @Override
    public void convertNonNegativeInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)longp, dOut);
    }

    @Override
    public void convertNonPositiveInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)longp, dOut);
    }

    @Override
    public void convertPositiveInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)longp, dOut);
    }

    @Override
    public void convertShort(ShortPointable shortp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)shortp, dOut);
    }

    @Override
    public void convertUnsignedByte(ShortPointable shortp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)shortp, dOut);
    }

    @Override
    public void convertUnsignedInt(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)longp, dOut);
    }

    @Override
    public void convertUnsignedLong(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)longp, dOut);
    }

    @Override
    public void convertUnsignedShort(IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.writeDoubleValue((INumeric)intp, dOut);
    }

    private void writeDoubleValue(INumeric numericp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(23);
        dOut.writeDouble(numericp.doubleValue());
    }
}

