/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.cast;

import edu.uci.ics.hyracks.data.std.api.INumeric;
import edu.uci.ics.hyracks.data.std.primitive.BooleanPointable;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.FloatPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.primitive.ShortPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.atomic.XSDecimalPointable;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.cast.AbstractCastToOperation;
import org.apache.vxquery.runtime.functions.cast.CastToStringOperation;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;

public class CastToDecimalOperation
extends AbstractCastToOperation {
    private ArrayBackedValueStorage abvsInner = new ArrayBackedValueStorage();
    private DataOutput dOutInner = this.abvsInner.getDataOutput();
    private CastToStringOperation castToString = new CastToStringOperation();
    private UTF8StringPointable stringp = (UTF8StringPointable)UTF8StringPointable.FACTORY.createPointable();

    @Override
    public void convertBoolean(BooleanPointable boolp, DataOutput dOut) throws SystemException, IOException {
        long value = boolp.getBoolean() ? 1 : 0;
        dOut.write(24);
        dOut.writeByte(0);
        dOut.writeLong(value);
    }

    @Override
    public void convertDecimal(XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(24);
        dOut.write(decp.getByteArray(), decp.getStartOffset(), decp.getLength());
    }

    @Override
    public void convertDouble(DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        if (doublep.getDouble() == 0.0) {
            boolean negative;
            long bits = Double.doubleToLongBits(doublep.getDouble());
            boolean bl = negative = bits >> 63 != 0L;
            if (negative) {
                throw new SystemException(ErrorCode.FORG0001);
            }
        }
        this.abvsInner.reset();
        this.castToString.convertDoubleCanonical(doublep, this.dOutInner);
        this.stringp.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset() + 1, this.abvsInner.getLength() - 1);
        this.convertStringExtra(this.stringp, dOut, true);
    }

    @Override
    public void convertFloat(FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        if (floatp.getFloat() == 0.0f) {
            boolean negative;
            long bits = Float.floatToIntBits(floatp.getFloat());
            boolean bl = negative = bits >> 31 != 0L;
            if (negative) {
                throw new SystemException(ErrorCode.FORG0001);
            }
        }
        this.abvsInner.reset();
        this.castToString.convertFloatCanonical(floatp, this.dOutInner);
        this.stringp.set(this.abvsInner.getByteArray(), this.abvsInner.getStartOffset() + 1, this.abvsInner.getLength() - 1);
        this.convertStringExtra(this.stringp, dOut, true);
    }

    @Override
    public void convertInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(24);
        dOut.write(0);
        dOut.writeLong(longp.getLong());
    }

    @Override
    public void convertString(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertStringExtra(stringp, dOut, false);
    }

    private void convertStringExtra(UTF8StringPointable stringp, DataOutput dOut, boolean connoicalForm) throws SystemException, IOException {
        UTF8StringCharacterIterator charIterator = new UTF8StringCharacterIterator(stringp);
        charIterator.reset();
        int decimalPlace = 0;
        long value = 0L;
        boolean pastDecimal = false;
        boolean negativeValue = false;
        int count = 0;
        char c = '\u0000';
        c = charIterator.next();
        if (c == Character.valueOf('-').charValue()) {
            negativeValue = true;
            c = charIterator.next();
        }
        do {
            if (count + 1 > 18) {
                throw new SystemException(ErrorCode.FOCA0006);
            }
            if (Character.isDigit((int)c)) {
                value = value * 10L + (long)Character.getNumericValue((int)c);
                if (pastDecimal) {
                    decimalPlace = (byte)(decimalPlace + 1);
                }
                ++count;
                continue;
            }
            if (c == Character.valueOf('.').charValue() && !pastDecimal) {
                pastDecimal = true;
                continue;
            }
            if (c == Character.valueOf('E').charValue() || c == Character.valueOf('e').charValue() && connoicalForm) break;
            throw new SystemException(ErrorCode.FORG0001);
        } while ((c = charIterator.next()) != '\u0000');
        if (c == Character.valueOf('E').charValue() || c == Character.valueOf('e').charValue() && connoicalForm) {
            int moveOffset = 0;
            boolean negativeOffset = false;
            c = charIterator.next();
            if (c == Character.valueOf('-').charValue()) {
                negativeOffset = true;
                c = charIterator.next();
            }
            do {
                if (!Character.isDigit((int)c)) {
                    throw new SystemException(ErrorCode.FORG0001);
                }
                moveOffset = moveOffset * 10 + Character.getNumericValue((int)c);
            } while ((c = charIterator.next()) != '\u0000');
            decimalPlace = (byte)(decimalPlace - (negativeOffset ? -moveOffset : moveOffset));
        }
        while (value != 0L && value % 10L == 0L) {
            value /= 10L;
            decimalPlace = (byte)(decimalPlace - 1);
        }
        if (decimalPlace > 18) {
            throw new SystemException(ErrorCode.FOCA0006);
        }
        dOut.write(24);
        dOut.write(decimalPlace);
        dOut.writeLong(negativeValue ? -value : value);
    }

    @Override
    public void convertUntypedAtomic(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }

    @Override
    public void convertByte(BytePointable bytep, DataOutput dOut) throws SystemException, IOException {
        this.writeDecimalValue((INumeric)bytep, dOut);
    }

    @Override
    public void convertInt(IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.writeDecimalValue((INumeric)intp, dOut);
    }

    @Override
    public void convertLong(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDecimalValue((INumeric)longp, dOut);
    }

    @Override
    public void convertNegativeInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDecimalValue((INumeric)longp, dOut);
    }

    @Override
    public void convertNonNegativeInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDecimalValue((INumeric)longp, dOut);
    }

    @Override
    public void convertNonPositiveInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDecimalValue((INumeric)longp, dOut);
    }

    @Override
    public void convertPositiveInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDecimalValue((INumeric)longp, dOut);
    }

    @Override
    public void convertShort(ShortPointable shortp, DataOutput dOut) throws SystemException, IOException {
        this.writeDecimalValue((INumeric)shortp, dOut);
    }

    @Override
    public void convertUnsignedByte(ShortPointable shortp, DataOutput dOut) throws SystemException, IOException {
        this.writeDecimalValue((INumeric)shortp, dOut);
    }

    @Override
    public void convertUnsignedInt(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDecimalValue((INumeric)longp, dOut);
    }

    @Override
    public void convertUnsignedLong(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.writeDecimalValue((INumeric)longp, dOut);
    }

    @Override
    public void convertUnsignedShort(IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.writeDecimalValue((INumeric)intp, dOut);
    }

    private void writeDecimalValue(INumeric numericp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(24);
        dOut.write(0);
        dOut.writeLong(numericp.longValue());
    }
}

