/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.cast;

import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.atomic.XSDatePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDateTimePointable;
import org.apache.vxquery.datamodel.util.DateTime;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.cast.AbstractCastToOperation;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;

public class CastToDateTimeOperation
extends AbstractCastToOperation {
    @Override
    public void convertDate(XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        dOut.write(15);
        dOut.writeShort((short)datep.getYear());
        dOut.write((byte)datep.getMonth());
        dOut.write((byte)datep.getDay());
        dOut.write(0);
        dOut.write(0);
        dOut.writeInt(0);
        dOut.write((byte)datep.getTimezoneHour());
        dOut.write((byte)datep.getTimezoneMinute());
    }

    @Override
    public void convertDatetime(XSDateTimePointable datetimep, DataOutput dOut) throws SystemException, IOException {
        dOut.write(15);
        dOut.write(datetimep.getByteArray(), datetimep.getStartOffset(), datetimep.getLength());
    }

    @Override
    public void convertString(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        char c;
        UTF8StringCharacterIterator charIterator = new UTF8StringCharacterIterator(stringp);
        charIterator.reset();
        int index = 0;
        long[] date = new long[8];
        boolean positiveTimezone = false;
        boolean pastDecimal = false;
        boolean negativeYear = false;
        int decimalPlace = 3;
        date[6] = 127L;
        date[7] = 127L;
        while ((c = charIterator.next()) != '\u0000') {
            if (Character.isDigit((int)c)) {
                date[index] = date[index] * 10L + (long)Character.getNumericValue((int)c);
                if (!pastDecimal) continue;
                decimalPlace = (byte)(decimalPlace - 1);
                continue;
            }
            if (c == Character.valueOf('-').charValue() && index == 0 && date[index] == 0L) {
                negativeYear = true;
                continue;
            }
            if (c == Character.valueOf('-').charValue() || c == Character.valueOf(':').charValue() || c == Character.valueOf('T').charValue()) {
                pastDecimal = false;
                date[++index] = 0L;
                continue;
            }
            if (c == Character.valueOf('+').charValue()) {
                pastDecimal = false;
                date[++index] = 0L;
                positiveTimezone = true;
                continue;
            }
            if (c == Character.valueOf('.').charValue()) {
                pastDecimal = true;
                continue;
            }
            if (c == Character.valueOf('Z').charValue()) {
                date[6] = 0L;
                date[7] = 0L;
                continue;
            }
            throw new SystemException(ErrorCode.FORG0001);
        }
        date[5] = (long)((double)date[5] * Math.pow(10.0, decimalPlace));
        if (negativeYear) {
            date[0] = date[0] * -1L;
        }
        if (!positiveTimezone && date[6] != 127L) {
            date[6] = date[6] * -1L;
        }
        if (!positiveTimezone && date[7] != 127L) {
            date[7] = date[7] * -1L;
        }
        if (date[3] == 24L) {
            date[3] = 0L;
        }
        if (!DateTime.valid(date[0], date[1], date[2], date[3], date[4], date[5], date[6], date[7])) {
            throw new SystemException(ErrorCode.FORG0001);
        }
        dOut.write(15);
        dOut.writeShort((short)date[0]);
        dOut.write((byte)date[1]);
        dOut.write((byte)date[2]);
        dOut.write((byte)date[3]);
        dOut.write((byte)date[4]);
        dOut.writeInt((int)date[5]);
        dOut.write((byte)date[6]);
        dOut.write((byte)date[7]);
    }

    @Override
    public void convertUntypedAtomic(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }
}

