/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.cast;

import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.atomic.XSDatePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDateTimePointable;
import org.apache.vxquery.datamodel.util.DateTime;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.cast.AbstractCastToOperation;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;

public class CastToDateOperation
extends AbstractCastToOperation {
    @Override
    public void convertDate(XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        dOut.write(16);
        dOut.write(datep.getByteArray(), datep.getStartOffset(), datep.getLength());
    }

    @Override
    public void convertDatetime(XSDateTimePointable datetimep, DataOutput dOut) throws SystemException, IOException {
        dOut.write(16);
        dOut.writeShort((short)datetimep.getYear());
        dOut.write((byte)datetimep.getMonth());
        dOut.write((byte)datetimep.getDay());
        dOut.write((byte)datetimep.getTimezoneHour());
        dOut.write((byte)datetimep.getTimezoneMinute());
    }

    @Override
    public void convertString(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        char c;
        UTF8StringCharacterIterator charIterator = new UTF8StringCharacterIterator(stringp);
        charIterator.reset();
        int index = 0;
        long[] date = new long[5];
        boolean positiveTimezone = false;
        boolean negativeYear = false;
        date[3] = 127L;
        date[4] = 127L;
        while ((c = charIterator.next()) != '\u0000') {
            if (Character.isDigit((int)c)) {
                date[index] = date[index] * 10L + (long)Character.getNumericValue((int)c);
                continue;
            }
            if (c == Character.valueOf('-').charValue() && index == 0 && date[index] == 0L) {
                negativeYear = true;
                continue;
            }
            if (c == Character.valueOf('-').charValue() || c == Character.valueOf(':').charValue()) {
                date[++index] = 0L;
                continue;
            }
            if (c == Character.valueOf('+').charValue()) {
                date[++index] = 0L;
                positiveTimezone = true;
                continue;
            }
            if (c == Character.valueOf('Z').charValue()) {
                date[3] = 0L;
                date[4] = 0L;
                continue;
            }
            throw new SystemException(ErrorCode.FORG0001);
        }
        if (negativeYear) {
            date[0] = date[0] * -1L;
        }
        if (!positiveTimezone && date[3] != 127L) {
            date[3] = date[3] * -1L;
        }
        if (!positiveTimezone && date[4] != 127L) {
            date[4] = date[4] * -1L;
        }
        if (!DateTime.valid(date[0], date[1], date[2], 0L, 0L, 0L, date[3], date[4])) {
            throw new SystemException(ErrorCode.FORG0001);
        }
        dOut.write(16);
        dOut.writeShort((short)date[0]);
        dOut.write((byte)date[1]);
        dOut.write((byte)date[2]);
        dOut.write((byte)date[3]);
        dOut.write((byte)date[4]);
    }

    @Override
    public void convertUntypedAtomic(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }
}

