/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.cast;

import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.atomic.XSDurationPointable;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.cast.AbstractCastToOperation;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;

public class CastToDTDurationOperation
extends AbstractCastToOperation {
    @Override
    public void convertDTDuration(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(20);
        dOut.write(longp.getByteArray(), longp.getStartOffset(), longp.getLength());
    }

    @Override
    public void convertDuration(XSDurationPointable durationp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(20);
        dOut.writeLong(durationp.getDayTime());
    }

    @Override
    public void convertString(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        UTF8StringCharacterIterator charIterator = new UTF8StringCharacterIterator(stringp);
        charIterator.reset();
        boolean pastDecimal = false;
        boolean timeSection = false;
        int decimalPlace = 3;
        int value = 0;
        long day = 0L;
        long hour = 0L;
        long minute = 0L;
        long millisecond = 0L;
        long negativeResult = 1L;
        char c = charIterator.next();
        if (c == Character.valueOf('-').charValue()) {
            negativeResult = -1L;
            c = charIterator.next();
        }
        if (c != Character.valueOf('P').charValue()) {
            throw new SystemException(ErrorCode.FORG0001);
        }
        while ((c = charIterator.next()) != '\u0000') {
            if (Character.isDigit((int)c)) {
                value = value * 10 + Character.getNumericValue((int)c);
                if (!pastDecimal) continue;
                decimalPlace = (byte)(decimalPlace - 1);
                continue;
            }
            if (c == Character.valueOf('T').charValue()) {
                timeSection = true;
                continue;
            }
            if (c == Character.valueOf('.').charValue()) {
                pastDecimal = true;
                continue;
            }
            if (c == Character.valueOf('D').charValue() && !timeSection) {
                day = value;
                value = 0;
                pastDecimal = false;
                continue;
            }
            if (c == Character.valueOf('H').charValue() && timeSection) {
                hour = value;
                value = 0;
                pastDecimal = false;
                continue;
            }
            if (c == Character.valueOf('M').charValue() && timeSection) {
                minute = value;
                value = 0;
                pastDecimal = false;
                continue;
            }
            if (c == Character.valueOf('S').charValue() && timeSection) {
                millisecond = (long)((double)value * Math.pow(10.0, decimalPlace));
                value = 0;
                pastDecimal = false;
                continue;
            }
            throw new SystemException(ErrorCode.FORG0001);
        }
        long dayTime = day * 86400000L + hour * 3600000L + minute * 60000L + millisecond;
        dOut.write(20);
        dOut.writeLong(negativeResult * dayTime);
    }

    @Override
    public void convertYMDuration(IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(20);
        dOut.writeLong(0L);
    }

    @Override
    public void convertUntypedAtomic(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }
}

