/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.cast;

import edu.uci.ics.hyracks.data.std.primitive.BooleanPointable;
import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.FloatPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.datamodel.accessors.atomic.XSDecimalPointable;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.cast.AbstractCastToOperation;
import org.apache.vxquery.runtime.functions.strings.LowerCaseCharacterIterator;
import org.apache.vxquery.runtime.functions.strings.UTF8StringCharacterIterator;

public class CastToBooleanOperation
extends AbstractCastToOperation {
    @Override
    public void convertBoolean(BooleanPointable boolp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(43);
        dOut.write(boolp.getByteArray(), boolp.getStartOffset(), boolp.getLength());
    }

    @Override
    public void convertDecimal(XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(43);
        if (decp.getDecimalValue() == 0L && decp.getBeforeDecimalPlace() == 0L) {
            dOut.write(0);
        } else {
            dOut.write(1);
        }
    }

    @Override
    public void convertDouble(DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        dOut.write(43);
        if (Double.isNaN(doublep.getDouble()) || doublep.getDouble() == 0.0) {
            dOut.write(0);
        } else {
            dOut.write(1);
        }
    }

    @Override
    public void convertFloat(FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(43);
        if (Float.isNaN(floatp.getFloat()) || floatp.getFloat() == 0.0f) {
            dOut.write(0);
        } else {
            dOut.write(1);
        }
    }

    @Override
    public void convertInteger(LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        dOut.write(43);
        if (longp.getLong() == 0L) {
            dOut.write(0);
        } else {
            dOut.write(1);
        }
    }

    @Override
    public void convertString(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        int result = 2;
        LowerCaseCharacterIterator charIterator = new LowerCaseCharacterIterator(new UTF8StringCharacterIterator(stringp));
        charIterator.reset();
        char c1 = charIterator.next();
        char c2 = charIterator.next();
        char c3 = charIterator.next();
        char c4 = charIterator.next();
        char c5 = charIterator.next();
        char c6 = charIterator.next();
        if (c1 == Character.valueOf('1').charValue() && c2 == '\u0000') {
            result = 1;
        } else if (c1 == Character.valueOf('0').charValue() && c2 == '\u0000') {
            result = 0;
        } else if (c1 == Character.valueOf('t').charValue() && c2 == Character.valueOf('r').charValue() && c3 == Character.valueOf('u').charValue() && c4 == Character.valueOf('e').charValue() && c5 == '\u0000') {
            result = 1;
        } else if (c1 == Character.valueOf('f').charValue() && c2 == Character.valueOf('a').charValue() && c3 == Character.valueOf('l').charValue() && c4 == Character.valueOf('s').charValue() && c5 == Character.valueOf('e').charValue() && c6 == '\u0000') {
            result = 0;
        }
        if (result == 2) {
            throw new SystemException(ErrorCode.FORG0001);
        }
        dOut.write(43);
        dOut.write(result);
    }

    @Override
    public void convertUntypedAtomic(UTF8StringPointable stringp, DataOutput dOut) throws SystemException, IOException {
        this.convertString(stringp, dOut);
    }
}

