/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.bool;

import edu.uci.ics.hyracks.algebricks.common.exceptions.AlgebricksException;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluator;
import edu.uci.ics.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.api.IValueReference;
import edu.uci.ics.hyracks.data.std.primitive.BytePointable;
import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.FloatPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.primitive.ShortPointable;
import edu.uci.ics.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.vxquery.datamodel.accessors.SequencePointable;
import org.apache.vxquery.datamodel.accessors.TaggedValuePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDecimalPointable;
import org.apache.vxquery.datamodel.values.XDMConstants;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluator;
import org.apache.vxquery.runtime.functions.base.AbstractTaggedValueArgumentScalarEvaluatorFactory;

public class FnBooleanScalarEvaluatorFactory
extends AbstractTaggedValueArgumentScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;

    public FnBooleanScalarEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        super(args);
    }

    @Override
    protected IScalarEvaluator createEvaluator(IHyracksTaskContext ctx, IScalarEvaluator[] args) throws AlgebricksException {
        return new FnBooleanScalarEvaluator(args);
    }

    private static class FnBooleanScalarEvaluator
    extends AbstractTaggedValueArgumentScalarEvaluator {
        final SequencePointable seqp = (SequencePointable)SequencePointable.FACTORY.createPointable();
        final LongPointable lp = (LongPointable)LongPointable.FACTORY.createPointable();
        final IntegerPointable ip = (IntegerPointable)IntegerPointable.FACTORY.createPointable();
        final ShortPointable sp = (ShortPointable)ShortPointable.FACTORY.createPointable();
        final BytePointable bp = (BytePointable)BytePointable.FACTORY.createPointable();
        final XSDecimalPointable decp = (XSDecimalPointable)XSDecimalPointable.FACTORY.createPointable();
        final DoublePointable dp = (DoublePointable)DoublePointable.FACTORY.createPointable();
        final FloatPointable fp = (FloatPointable)FloatPointable.FACTORY.createPointable();
        final UTF8StringPointable utf8p = (UTF8StringPointable)UTF8StringPointable.FACTORY.createPointable();

        public FnBooleanScalarEvaluator(IScalarEvaluator[] args) {
            super(args);
        }

        @Override
        protected void evaluate(TaggedValuePointable[] args, IPointable result) throws SystemException {
            TaggedValuePointable tvp = args[0];
            boolean booleanResult = true;
            switch (tvp.getTag()) {
                case 100: {
                    tvp.getValue((IPointable)this.seqp);
                    if (this.seqp.getEntryCount() != 0) break;
                    booleanResult = false;
                    break;
                }
                case 43: {
                    result.set((IValueReference)tvp);
                    return;
                }
                case 24: {
                    tvp.getValue((IPointable)this.decp);
                    if (this.decp.longValue() != 0L) break;
                    booleanResult = false;
                    break;
                }
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 32: 
                case 33: 
                case 34: 
                case 37: {
                    tvp.getValue((IPointable)this.lp);
                    if (this.lp.longValue() != 0L) break;
                    booleanResult = false;
                    break;
                }
                case 29: 
                case 35: {
                    tvp.getValue((IPointable)this.ip);
                    if (this.ip.intValue() != 0) break;
                    booleanResult = false;
                    break;
                }
                case 30: 
                case 36: {
                    tvp.getValue((IPointable)this.sp);
                    if (this.sp.shortValue() != 0) break;
                    booleanResult = false;
                    break;
                }
                case 31: {
                    tvp.getValue((IPointable)this.bp);
                    if (this.bp.byteValue() != 0) break;
                    booleanResult = false;
                    break;
                }
                case 23: {
                    tvp.getValue((IPointable)this.dp);
                    if (this.dp.doubleValue() != 0.0 && !Double.isNaN(this.dp.doubleValue())) break;
                    booleanResult = false;
                    break;
                }
                case 22: {
                    tvp.getValue((IPointable)this.fp);
                    if (this.fp.floatValue() != 0.0f && !Float.isNaN(this.fp.floatValue())) break;
                    booleanResult = false;
                    break;
                }
                case 4: 
                case 46: {
                    tvp.getValue((IPointable)this.utf8p);
                    if (this.utf8p.getUTFLength() != 0) break;
                    booleanResult = false;
                    break;
                }
                default: {
                    throw new SystemException(ErrorCode.FORG0006);
                }
            }
            if (booleanResult) {
                XDMConstants.setTrue(result);
            } else {
                XDMConstants.setFalse(result);
            }
        }
    }
}

