/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vxquery.runtime.functions.arithmetic;

import edu.uci.ics.hyracks.data.std.api.IPointable;
import edu.uci.ics.hyracks.data.std.primitive.DoublePointable;
import edu.uci.ics.hyracks.data.std.primitive.FloatPointable;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.data.std.primitive.LongPointable;
import edu.uci.ics.hyracks.data.std.util.ArrayBackedValueStorage;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.vxquery.context.DynamicContext;
import org.apache.vxquery.datamodel.accessors.atomic.XSDatePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDateTimePointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSDecimalPointable;
import org.apache.vxquery.datamodel.accessors.atomic.XSTimePointable;
import org.apache.vxquery.datamodel.util.DateTime;
import org.apache.vxquery.exceptions.ErrorCode;
import org.apache.vxquery.exceptions.SystemException;
import org.apache.vxquery.runtime.functions.arithmetic.AbstractArithmeticOperation;

public class SubtractOperation
extends AbstractArithmeticOperation {
    protected final ArrayBackedValueStorage abvsInner1 = new ArrayBackedValueStorage();
    protected final DataOutput dOutInner1 = this.abvsInner1.getDataOutput();
    protected final ArrayBackedValueStorage abvsInner2 = new ArrayBackedValueStorage();
    protected final DataOutput dOutInner2 = this.abvsInner2.getDataOutput();
    private XSDecimalPointable decp1 = (XSDecimalPointable)XSDecimalPointable.FACTORY.createPointable();
    private XSDecimalPointable decp2 = (XSDecimalPointable)XSDecimalPointable.FACTORY.createPointable();
    private XSDateTimePointable ctxDatetimep = (XSDateTimePointable)XSDateTimePointable.FACTORY.createPointable();
    private XSDateTimePointable datetimep1 = (XSDateTimePointable)XSDateTimePointable.FACTORY.createPointable();
    private XSDateTimePointable datetimep2 = (XSDateTimePointable)XSDateTimePointable.FACTORY.createPointable();
    private XSDateTimePointable datetimep3 = (XSDateTimePointable)XSDateTimePointable.FACTORY.createPointable();
    private XSDateTimePointable datetimep4 = (XSDateTimePointable)XSDateTimePointable.FACTORY.createPointable();

    @Override
    public void operateDateDate(XSDatePointable datep1, XSDatePointable datep2, DynamicContext dCtx, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner1.reset();
        this.datetimep1.set(this.abvsInner1.getByteArray(), this.abvsInner1.getStartOffset(), XSDateTimePointable.TYPE_TRAITS.getFixedLength());
        this.datetimep1.setDateTime(datep1.getYear(), datep1.getMonth(), datep1.getDay(), 0L, 0L, 0L, datep1.getTimezoneHour(), datep1.getTimezoneMinute());
        this.datetimep2.set(this.abvsInner1.getByteArray(), this.abvsInner1.getStartOffset() + XSDateTimePointable.TYPE_TRAITS.getFixedLength(), XSDateTimePointable.TYPE_TRAITS.getFixedLength());
        this.datetimep2.setDateTime(datep2.getYear(), datep2.getMonth(), datep2.getDay(), 0L, 0L, 0L, datep2.getTimezoneHour(), datep2.getTimezoneMinute());
        this.operateDatetimeDatetime(this.datetimep1, this.datetimep2, dCtx, dOut);
    }

    @Override
    public void operateDateDTDuration(XSDatePointable datep1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner1.reset();
        DateTime.normalizeDateTime(datep1.getYearMonth(), datep1.getDayTime() - longp2.getLong(), datep1.getTimezoneHour(), datep1.getTimezoneMinute(), this.dOutInner1);
        byte[] bytes = this.abvsInner1.getByteArray();
        int startOffset = this.abvsInner1.getStartOffset() + 1;
        bytes[startOffset + 4] = bytes[startOffset + 10];
        bytes[startOffset + 5] = bytes[startOffset + 11];
        dOut.write(16);
        dOut.write(bytes, startOffset, XSDatePointable.TYPE_TRAITS.getFixedLength());
    }

    @Override
    public void operateDatetimeDatetime(XSDateTimePointable datetimep1, XSDateTimePointable datetimep2, DynamicContext dCtx, DataOutput dOut) throws SystemException, IOException {
        long[] monthDayLimits;
        dCtx.getCurrentDateTime((IPointable)this.ctxDatetimep);
        this.abvsInner2.reset();
        DateTime.getUtcTimezoneDateTime(datetimep1, this.ctxDatetimep, this.dOutInner2);
        int startOffset1 = this.abvsInner2.getStartOffset() + 1;
        this.datetimep3.set(this.abvsInner2.getByteArray(), startOffset1, XSDateTimePointable.TYPE_TRAITS.getFixedLength());
        DateTime.getUtcTimezoneDateTime(datetimep2, this.ctxDatetimep, this.dOutInner2);
        int startOffset2 = startOffset1 + 1 + XSDateTimePointable.TYPE_TRAITS.getFixedLength();
        this.datetimep4.set(this.abvsInner2.getByteArray(), startOffset2, XSDateTimePointable.TYPE_TRAITS.getFixedLength());
        long year = this.datetimep3.getYear();
        long month = this.datetimep3.getMonth();
        long dayTime = this.datetimep3.getDayTime();
        long[] lArray = monthDayLimits = DateTime.isLeapYear(year) ? DateTime.DAYS_OF_MONTH_LEAP : DateTime.DAYS_OF_MONTH_ORDI;
        while (year != this.datetimep4.getYear() || year == this.datetimep4.getYear() && month != this.datetimep4.getMonth()) {
            if (year > this.datetimep4.getYear()) {
                if (month == 1L) {
                    monthDayLimits = DateTime.isLeapYear(--year) ? DateTime.DAYS_OF_MONTH_LEAP : DateTime.DAYS_OF_MONTH_ORDI;
                    month = 12L;
                    dayTime += monthDayLimits[(int)month - 1] * 86400000L;
                    continue;
                }
                dayTime += monthDayLimits[(int)(--month) - 1] * 86400000L;
                continue;
            }
            if (year < this.datetimep4.getYear()) {
                if (month == 12L) {
                    month = 1L;
                    monthDayLimits = DateTime.isLeapYear(++year) ? DateTime.DAYS_OF_MONTH_LEAP : DateTime.DAYS_OF_MONTH_ORDI;
                    dayTime -= monthDayLimits[(int)month - 1] * 86400000L;
                    continue;
                }
                dayTime -= monthDayLimits[(int)(++month) - 1] * 86400000L;
                continue;
            }
            if (month > this.datetimep4.getMonth()) {
                dayTime += monthDayLimits[(int)(--month) - 1] * 86400000L;
                continue;
            }
            if (month >= this.datetimep4.getMonth()) continue;
            dayTime -= monthDayLimits[(int)(++month) - 1] * 86400000L;
        }
        dOut.write(20);
        dOut.writeLong(dayTime -= this.datetimep4.getDayTime());
    }

    @Override
    public void operateDatetimeDTDuration(XSDateTimePointable datetimep, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner1.reset();
        DateTime.normalizeDateTime(datetimep.getYearMonth(), datetimep.getDayTime() - longp.getLong(), datetimep.getTimezoneHour(), datetimep.getTimezoneMinute(), this.dOutInner1);
        dOut.write(15);
        dOut.write(this.abvsInner1.getByteArray(), this.abvsInner1.getStartOffset() + 1, XSDateTimePointable.TYPE_TRAITS.getFixedLength());
    }

    @Override
    public void operateDatetimeYMDuration(XSDateTimePointable datetimep, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner1.reset();
        DateTime.normalizeDateTime(datetimep.getYearMonth() - (long)intp.getInteger(), datetimep.getDayTime(), datetimep.getTimezoneHour(), datetimep.getTimezoneMinute(), this.dOutInner1);
        dOut.write(15);
        dOut.write(this.abvsInner1.getByteArray(), this.abvsInner1.getStartOffset() + 1, XSDateTimePointable.TYPE_TRAITS.getFixedLength());
    }

    @Override
    public void operateDateYMDuration(XSDatePointable datep, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner1.reset();
        DateTime.normalizeDateTime(datep.getYearMonth() - (long)intp.getInteger(), datep.getDayTime(), datep.getTimezoneHour(), datep.getTimezoneMinute(), this.dOutInner1);
        byte[] bytes = this.abvsInner1.getByteArray();
        int startOffset = this.abvsInner1.getStartOffset() + 1;
        bytes[startOffset + 4] = bytes[startOffset + 10];
        bytes[startOffset + 5] = bytes[startOffset + 11];
        dOut.write(16);
        dOut.write(bytes, startOffset, XSDatePointable.TYPE_TRAITS.getFixedLength());
    }

    @Override
    public void operateDecimalDecimal(XSDecimalPointable decp1, XSDecimalPointable decp2, DataOutput dOut) throws SystemException, IOException {
        long value1 = decp1.getDecimalValue();
        long value2 = decp2.getDecimalValue();
        byte place1 = decp1.getDecimalPlace();
        byte place2 = decp2.getDecimalPlace();
        byte count1 = decp1.getDigitCount();
        byte count2 = decp2.getDigitCount();
        while (place1 > place2) {
            place2 = (byte)(place2 + 1);
            value2 *= 10L;
            count2 = (byte)(count2 + 1);
        }
        while (place1 < place2) {
            place1 = (byte)(place1 + 1);
            value1 *= 10L;
            count1 = (byte)(count1 + 1);
        }
        if (count1 > 18 || count2 > 18) {
            throw new SystemException(ErrorCode.XPDY0002);
        }
        dOut.write(24);
        dOut.writeByte(place1);
        dOut.writeLong(value1 -= value2);
    }

    @Override
    public void operateDecimalDouble(XSDecimalPointable decp, DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        double value = decp.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value -= doublep.doubleValue());
    }

    @Override
    public void operateDecimalDTDuration(XSDecimalPointable decp, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        long value = this.operateDecimalInt(decp, longp.longValue());
        dOut.write(20);
        dOut.writeLong(value);
    }

    @Override
    public void operateDecimalFloat(XSDecimalPointable decp, FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        float value = decp.floatValue();
        dOut.write(22);
        dOut.writeFloat(value -= floatp.floatValue());
    }

    @Override
    public void operateDecimalInteger(XSDecimalPointable decp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner1.reset();
        this.decp2.set(this.abvsInner1.getByteArray(), this.abvsInner1.getStartOffset(), XSDecimalPointable.TYPE_TRAITS.getFixedLength());
        this.decp2.setDecimal(longp2.longValue(), (byte)0);
        this.operateDecimalDecimal(decp1, this.decp2, dOut);
    }

    @Override
    public void operateDecimalYMDuration(XSDecimalPointable decp, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        int value = (int)this.operateDecimalInt(decp, intp.intValue());
        dOut.write(19);
        dOut.writeInt(value);
    }

    @Override
    public void operateDoubleDecimal(DoublePointable doublep, XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        double value = doublep.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value -= decp.doubleValue());
    }

    @Override
    public void operateDoubleDouble(DoublePointable doublep, DoublePointable doublep2, DataOutput dOut) throws SystemException, IOException {
        double value = doublep.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value -= doublep2.doubleValue());
    }

    @Override
    public void operateDoubleDTDuration(DoublePointable doublep, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        long value = doublep.intValue();
        dOut.write(20);
        dOut.writeLong(value -= (long)longp.intValue());
    }

    @Override
    public void operateDoubleFloat(DoublePointable doublep, FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        double value = doublep.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value -= floatp.doubleValue());
    }

    @Override
    public void operateDoubleInteger(DoublePointable doublep, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        double value = doublep.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value -= longp.doubleValue());
    }

    @Override
    public void operateDoubleYMDuration(DoublePointable doublep, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        int value = doublep.intValue();
        dOut.write(19);
        dOut.writeInt(value -= intp.intValue());
    }

    @Override
    public void operateDTDurationDate(LongPointable longp, XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDTDurationDatetime(LongPointable longp, XSDateTimePointable datetimep, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateDTDurationDecimal(LongPointable longp, XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        long value = longp.longValue();
        dOut.write(20);
        dOut.writeLong(value -= decp.longValue());
    }

    @Override
    public void operateDTDurationDouble(LongPointable longp, DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        long value = longp.longValue();
        dOut.write(20);
        dOut.writeLong(value -= doublep.longValue());
    }

    @Override
    public void operateDTDurationDTDuration(LongPointable longp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        long value = longp1.longValue();
        dOut.write(20);
        dOut.writeLong(value -= longp2.longValue());
    }

    @Override
    public void operateDTDurationFloat(LongPointable longp, FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        long value = longp.longValue();
        dOut.write(20);
        dOut.writeLong(value -= floatp.longValue());
    }

    @Override
    public void operateDTDurationInteger(LongPointable longp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        long value = longp1.longValue();
        dOut.write(20);
        dOut.writeLong(value -= longp2.longValue());
    }

    @Override
    public void operateDTDurationTime(LongPointable longp, XSTimePointable timep, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateFloatDecimal(FloatPointable floatp, XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        float value = floatp.floatValue();
        dOut.write(22);
        dOut.writeDouble(value -= decp.floatValue());
    }

    @Override
    public void operateFloatDouble(FloatPointable floatp, DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        double value = floatp.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value -= doublep.doubleValue());
    }

    @Override
    public void operateFloatDTDuration(FloatPointable floatp, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        long value = floatp.longValue();
        dOut.write(20);
        dOut.writeLong(value -= longp.longValue());
    }

    @Override
    public void operateFloatFloat(FloatPointable floatp, FloatPointable floatp2, DataOutput dOut) throws SystemException, IOException {
        float value = floatp.floatValue();
        dOut.write(22);
        dOut.writeFloat(value -= floatp2.floatValue());
    }

    @Override
    public void operateFloatInteger(FloatPointable floatp, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        float value = floatp.floatValue();
        dOut.write(22);
        dOut.writeFloat(value -= longp.floatValue());
    }

    @Override
    public void operateFloatYMDuration(FloatPointable floatp, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        int value = floatp.intValue();
        dOut.write(19);
        dOut.writeInt(value -= intp.intValue());
    }

    @Override
    public void operateIntegerDecimal(LongPointable longp, XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        double value = longp.doubleValue();
        dOut.write(24);
        dOut.writeDouble(value -= decp.doubleValue());
    }

    @Override
    public void operateIntegerDouble(LongPointable longp, DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        double value = longp.doubleValue();
        dOut.write(23);
        dOut.writeDouble(value -= doublep.doubleValue());
    }

    @Override
    public void operateIntegerDTDuration(LongPointable longp1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        long value = longp1.longValue();
        dOut.write(20);
        dOut.writeLong(value -= longp2.longValue());
    }

    @Override
    public void operateIntegerFloat(LongPointable longp, FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        float value = longp.floatValue();
        dOut.write(22);
        dOut.writeFloat(value -= floatp.floatValue());
    }

    @Override
    public void operateIntegerInteger(LongPointable longp, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        long value = longp.getLong();
        dOut.write(25);
        dOut.writeLong(value -= longp2.getLong());
    }

    @Override
    public void operateIntegerYMDuration(LongPointable longp, IntegerPointable intp, DataOutput dOut) throws SystemException, IOException {
        int value = longp.intValue();
        dOut.write(19);
        dOut.writeInt(value -= intp.intValue());
    }

    @Override
    public void operateTimeDTDuration(XSTimePointable timep1, LongPointable longp2, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner1.reset();
        this.datetimep1.set(this.abvsInner1.getByteArray(), this.abvsInner1.getStartOffset(), XSDateTimePointable.TYPE_TRAITS.getFixedLength());
        this.datetimep1.setDateTime(1972L, 12L, 31L, timep1.getHour(), timep1.getMinute(), timep1.getMilliSecond(), timep1.getTimezoneHour(), timep1.getTimezoneMinute());
        DateTime.normalizeDateTime(this.datetimep1.getYearMonth(), this.datetimep1.getDayTime() - longp2.getLong(), timep1.getTimezoneHour(), timep1.getTimezoneMinute(), this.dOutInner1);
        int startOffset = this.abvsInner1.getStartOffset() + 1 + 4;
        dOut.write(17);
        dOut.write(this.abvsInner1.getByteArray(), startOffset, XSTimePointable.TYPE_TRAITS.getFixedLength());
    }

    @Override
    public void operateTimeTime(XSTimePointable timep1, XSTimePointable timep2, DynamicContext dCtx, DataOutput dOut) throws SystemException, IOException {
        this.abvsInner1.reset();
        this.datetimep1.set(this.abvsInner1.getByteArray(), this.abvsInner1.getStartOffset(), XSDateTimePointable.TYPE_TRAITS.getFixedLength());
        this.datetimep1.setDateTime(1972L, 12L, 31L, timep1.getHour(), timep1.getMinute(), timep1.getMilliSecond(), timep1.getTimezoneHour(), timep1.getTimezoneMinute());
        this.datetimep2.set(this.abvsInner1.getByteArray(), this.abvsInner1.getStartOffset() + XSDateTimePointable.TYPE_TRAITS.getFixedLength(), XSDateTimePointable.TYPE_TRAITS.getFixedLength());
        this.datetimep2.setDateTime(1972L, 12L, 31L, timep2.getHour(), timep2.getMinute(), timep2.getMilliSecond(), timep2.getTimezoneHour(), timep2.getTimezoneMinute());
        this.operateDatetimeDatetime(this.datetimep1, this.datetimep2, dCtx, dOut);
    }

    @Override
    public void operateYMDurationDate(IntegerPointable intp, XSDatePointable datep, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateYMDurationDatetime(IntegerPointable intp, XSDateTimePointable datetimep, DataOutput dOut) throws SystemException, IOException {
        throw new SystemException(ErrorCode.XPTY0004);
    }

    @Override
    public void operateYMDurationDecimal(IntegerPointable intp, XSDecimalPointable decp, DataOutput dOut) throws SystemException, IOException {
        int value = intp.intValue();
        dOut.write(19);
        dOut.writeInt(value -= decp.intValue());
    }

    @Override
    public void operateYMDurationDouble(IntegerPointable intp, DoublePointable doublep, DataOutput dOut) throws SystemException, IOException {
        int value = intp.intValue();
        dOut.write(19);
        dOut.writeInt(value -= doublep.intValue());
    }

    @Override
    public void operateYMDurationFloat(IntegerPointable intp, FloatPointable floatp, DataOutput dOut) throws SystemException, IOException {
        int value = intp.intValue();
        dOut.write(19);
        dOut.writeInt(value -= floatp.intValue());
    }

    @Override
    public void operateYMDurationInteger(IntegerPointable intp, LongPointable longp, DataOutput dOut) throws SystemException, IOException {
        int value = intp.intValue();
        dOut.write(19);
        dOut.writeInt(value -= longp.intValue());
    }

    @Override
    public void operateYMDurationYMDuration(IntegerPointable intp, IntegerPointable intp2, DataOutput dOut) throws SystemException, IOException {
        int value = intp.intValue();
        dOut.write(19);
        dOut.writeInt(value -= intp2.intValue());
    }

    public long operateIntDecimal(long longValue, XSDecimalPointable decp2) throws SystemException, IOException {
        this.abvsInner1.reset();
        this.decp1.set(this.abvsInner1.getByteArray(), this.abvsInner1.getStartOffset(), XSDecimalPointable.TYPE_TRAITS.getFixedLength());
        this.decp1.setDecimal(longValue, (byte)0);
        long value1 = longValue;
        long value2 = decp2.getDecimalValue();
        byte place1 = 0;
        byte place2 = decp2.getDecimalPlace();
        byte count1 = this.decp1.getDigitCount();
        byte count2 = decp2.getDigitCount();
        while (place1 > place2) {
            place2 = (byte)(place2 + 1);
            value2 *= 10L;
            count2 = (byte)(count2 + 1);
        }
        while (place1 < place2) {
            place1 = (byte)(place1 + 1);
            value1 *= 10L;
            count1 = (byte)(count1 + 1);
        }
        if (count1 > 18 || count2 > 18) {
            throw new SystemException(ErrorCode.XPDY0002);
        }
        decp2.setDecimal(value1 -= value2, place1);
        return decp2.longValue();
    }

    public long operateDecimalInt(XSDecimalPointable decp1, long longValue) throws SystemException, IOException {
        this.abvsInner2.reset();
        this.decp2.set(this.abvsInner2.getByteArray(), this.abvsInner2.getStartOffset(), XSDecimalPointable.TYPE_TRAITS.getFixedLength());
        this.decp2.setDecimal(longValue, (byte)0);
        long value1 = decp1.getDecimalValue();
        long value2 = this.decp2.getDecimalValue();
        byte place1 = decp1.getDecimalPlace();
        byte place2 = this.decp2.getDecimalPlace();
        byte count1 = decp1.getDigitCount();
        byte count2 = this.decp2.getDigitCount();
        while (place1 > place2) {
            place2 = (byte)(place2 + 1);
            value2 *= 10L;
            count2 = (byte)(count2 + 1);
        }
        while (place1 < place2) {
            place1 = (byte)(place1 + 1);
            value1 *= 10L;
            count1 = (byte)(count1 + 1);
        }
        if (count1 > 18 || count2 > 18) {
            throw new SystemException(ErrorCode.XPDY0002);
        }
        this.decp2.setDecimal(value1 -= value2, place1);
        return this.decp2.longValue();
    }
}

